/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

import com.mathworks.toolbox.javabuilder.MWException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MWArrayUtils {
    public static <T> T structFromProperties(Properties properties, Class<T> clazz) {
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        String[] stringArray = new String[n];
        enumeration = properties.propertyNames();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        T t = null;
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, String[].class);
            t = constructor.newInstance(1, 1, stringArray);
            Method method = clazz.getMethod("set", String.class, Integer.TYPE, Object.class);
            for (String string : stringArray) {
                method.invoke(t, string, 1, properties.getProperty(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public static <T> T structFromMap(Map<String, Object> map, Class<T> clazz) throws MWException {
        T t;
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, String[].class);
            t = constructor.newInstance(1, 1, map.keySet().toArray(new String[map.size()]));
            Method method = clazz.getMethod("set", String.class, Integer.TYPE, Object.class);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                method.invoke(t, entry.getKey(), 1, entry.getValue());
            }
        }
        catch (Exception exception) {
            throw new MWException("Issue creating MWStructArray from map.  Error: " + exception.getMessage());
        }
        return t;
    }

    public static <T> T structFromBean(Object object, Class<T> clazz) throws IntrospectionException, MWException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            Method method = propertyDescriptor.getReadMethod();
            try {
                if (method == null || method.getName().equalsIgnoreCase("getClass")) continue;
                hashMap.put(propertyDescriptor.getName(), method.invoke(object, new Object[0]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MWException("Issue creating MWStructArray from Bean.  Error: " + illegalArgumentException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MWException("Issue creating MWStructArray from Bean.  Error: " + illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MWException("Issue creating MWStructArray from Bean.  Error: " + invocationTargetException.getMessage());
            }
        }
        return MWArrayUtils.structFromMap(hashMap, clazz);
    }
}

