/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.mjs.CloudMJSClient;
import com.mathworks.webservices.mjs.CloudMJSConfigAccess;
import com.mathworks.webservices.mjs.CloudMJSDataAccess;
import com.mathworks.webservices.mjs.CloudMJSJobAccess;
import com.mathworks.webservices.mjs.CloudMJSQueueAccess;
import com.mathworks.webservices.mjs.CloudMJSTaskAccess;
import com.mathworks.webservices.mjs.core.GDSWebServiceClient;
import com.mathworks.webservices.mjs.core.http.CloudMJSHttpClient;
import com.mathworks.webservices.mjs.core.http.ContentTypeBaseHandler;
import com.mathworks.webservices.mjs.core.raw.RawByteResponseHandler;
import com.mathworks.webservices.mjs.core.xml.GDSJaxbResponseHandler;
import com.mathworks.webservices.mjs.exception.AuthenticationException;
import com.mathworks.webservices.mjs.exception.CloudMJSBaseException;
import com.mathworks.webservices.mjs.exception.ContentListEmptyException;
import com.mathworks.webservices.mjs.exception.ContentTooLargeException;
import com.mathworks.webservices.mjs.exception.IllegalPartialContentLengthException;
import com.mathworks.webservices.mjs.exception.IllegalStartLocationException;
import com.mathworks.webservices.mjs.exception.MaximumContentLengthExceededException;
import com.mathworks.webservices.mjs.exception.MetadataEmptyException;
import com.mathworks.webservices.mjs.exception.NoUserIdException;
import com.mathworks.webservices.mjs.exception.NotLoggedInException;
import com.mathworks.webservices.mjs.exception.ParentResourceNotExistException;
import com.mathworks.webservices.mjs.exception.PartialContentTooLargeException;
import com.mathworks.webservices.mjs.exception.QueueNotSpecifiedException;
import com.mathworks.webservices.mjs.exception.ResourceExistsException;
import com.mathworks.webservices.mjs.exception.ResourceNotFoundException;
import com.mathworks.webservices.mjs.exception.ServiceException;
import com.mathworks.webservices.mjs.exception.SessionExpiredException;
import com.mathworks.webservices.mjs.exception.SessionNotFoundException;
import com.mathworks.webservices.mjs.exception.StartLocationTooLargeException;
import com.mathworks.webservices.mjs.exception.TooManyContentsException;
import com.mathworks.webservices.mjs.exception.UnknownErrorException;
import com.mathworks.webservices.mjs.exception.UuidNotSpecifiedException;
import com.mathworks.webservices.mjs.impl.CloudMJSConfigAccessImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSDataAccessImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSJobAccessImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSQueueAccessImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSTaskAccessImpl;
import com.mathworks.webservices.mjs.model.CloudMJSErrorCode;
import com.mathworks.webservices.mjs.model.request.CloudLoginRequest;
import com.mathworks.webservices.mjs.model.request.CloudLogoutRequest;
import com.mathworks.webservices.mjs.model.response.LoginResponse;
import com.mathworks.webservices.mjs.model.response.LogoutResponse;

public class CloudMJSClientImpl
extends GDSWebServiceClient
implements CloudMJSClient {
    private CloudMJSQueueAccess cloudMJSQueueAccess;
    private CloudMJSDataAccess cloudMJSDataAccess;
    private CloudMJSTaskAccess cloudMJSTaskAccess;
    private CloudMJSJobAccess cloudMJSJobAccess;
    private CloudMJSConfigAccess cloudMJSConfigAccess;
    private String sessionId;
    private String queueUuid;

    public CloudMJSClientImpl(String endpoint, String clientString) {
        this(new ClientConfiguration());
        this.setEndpoint(endpoint);
        this.setClientString(clientString);
    }

    public CloudMJSClientImpl() {
        this(new ClientConfiguration());
    }

    public CloudMJSClientImpl(ClientConfiguration clientConfiguration) {
        super(new CloudMJSHttpClient(clientConfiguration));
        this.init();
    }

    public CloudMJSClientImpl(MathWorksHttpClient httpClient) {
        super(httpClient);
        this.init();
    }

    private void init() {
        this.initializeHandlers();
        this.cloudMJSQueueAccess = new CloudMJSQueueAccessImpl(this);
        this.cloudMJSDataAccess = new CloudMJSDataAccessImpl(this);
        this.cloudMJSTaskAccess = new CloudMJSTaskAccessImpl(this);
        this.cloudMJSJobAccess = new CloudMJSJobAccessImpl(this);
        this.cloudMJSConfigAccess = new CloudMJSConfigAccessImpl(this);
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public synchronized String getSessionId() {
        return this.sessionId;
    }

    public synchronized void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public synchronized String getQueueUuid() {
        return this.queueUuid;
    }

    public synchronized void setQueueUuid(String queueUuid) {
        this.queueUuid = queueUuid;
    }

    @Override
    public LoginResponse login(CloudLoginRequest loginRequest) {
        HttpRequest req = new HttpRequest(HttpMethodName.GET, this.endpoint, "/service/v1/login");
        req.addHeader("x-mw-authentication-token", loginRequest.getLoginToken());
        if (loginRequest.getClientString() != null) {
            req.setClientString(loginRequest.getClientString());
        }
        try {
            LoginResponse loginResponse = (LoginResponse)this.executeRequestNew(req).getResponsePayload();
            this.setSessionId(loginResponse.getSessionId());
            return loginResponse;
        }
        catch (MathWorksServiceException ex) {
            throw this.generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public LogoutResponse logout(CloudLogoutRequest logoutRequest) {
        HttpRequest req = new HttpRequest(HttpMethodName.GET, this.endpoint, "/service/v1/logout");
        req.addHeader("x-mw-gds-session-id", this.getSessionId());
        if (logoutRequest.getClientString() != null) {
            req.setClientString(logoutRequest.getClientString());
        }
        try {
            LogoutResponse logoutResponse = (LogoutResponse)this.executeRequestNew(req).getResponsePayload();
            this.setSessionId(null);
            return logoutResponse;
        }
        catch (MathWorksServiceException ex) {
            throw this.generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudMJSJobAccess getJobAccess() {
        return this.cloudMJSJobAccess;
    }

    @Override
    public CloudMJSTaskAccess getTaskAccess() {
        return this.cloudMJSTaskAccess;
    }

    @Override
    public CloudMJSDataAccess getDataAccess() {
        return this.cloudMJSDataAccess;
    }

    @Override
    public CloudMJSQueueAccess getQueueAccess() {
        return this.cloudMJSQueueAccess;
    }

    public CloudMJSConfigAccess getConfigAccess() {
        return this.cloudMJSConfigAccess;
    }

    public CloudMJSBaseException generateClientSideException(String errorString, Exception cause) {
        return this.generateClientSideException(errorString, cause.getLocalizedMessage(), cause);
    }

    public CloudMJSBaseException generateClientSideException(String errorString, String message, Exception cause) {
        try {
            CloudMJSErrorCode errorCode = CloudMJSErrorCode.valueOf(errorString);
            switch (errorCode) {
                case SERVICE_ERROR: {
                    return new ServiceException(message, cause);
                }
                case AUTHENTICATION_ERROR: {
                    return new AuthenticationException(message, cause);
                }
                case SESSION_ID_CANNOT_BE_EMPTY: {
                    return new NotLoggedInException(message, cause);
                }
                case SESSION_NOT_FOUND: {
                    return new SessionNotFoundException(message, cause);
                }
                case SESSION_EXPIRED: {
                    return new SessionExpiredException(message, cause);
                }
                case RESOURCE_ALREADY_EXISTS: {
                    return new ResourceExistsException(message, cause);
                }
                case EMPTY_UUID: {
                    return new UuidNotSpecifiedException(message, cause);
                }
                case EMPTY_CONTENT_LIST: {
                    return new ContentListEmptyException(message, cause);
                }
                case RESOURCE_NOT_FOUND: {
                    return new ResourceNotFoundException(message, cause);
                }
                case ILLEGAL_PARTIAL_CONTENT_LENGTH: {
                    return new IllegalPartialContentLengthException(message, cause);
                }
                case ILLEGAL_START_LOCATION: {
                    return new IllegalStartLocationException(message, cause);
                }
                case PARTIAL_CONTENT_TOO_LARGE: {
                    return new PartialContentTooLargeException(message, cause);
                }
                case START_LOCATION_TOO_LARGE: {
                    return new StartLocationTooLargeException(message, cause);
                }
                case CONTENT_TOO_LARGE: {
                    return new ContentTooLargeException(message, cause);
                }
                case EMPTY_QUEUE_UUID: {
                    return new QueueNotSpecifiedException(message, cause);
                }
                case EMPTY_METADATA: {
                    return new MetadataEmptyException(message, cause);
                }
                case MAX_CONTENT_LENGTH_EXCEEDED: {
                    return new MaximumContentLengthExceededException(message, cause);
                }
                case TOO_MANY_CONTENTS: {
                    return new TooManyContentsException(message, cause);
                }
                case USER_ID_CANNOT_BE_EMPTY: {
                    return new NoUserIdException(message, cause);
                }
                case PARENT_RESOURCE_DOES_NOT_EXIST: {
                    return new ParentResourceNotExistException(message, cause);
                }
                case EMPTY_ACTION: {
                    return new ServiceException(message, cause);
                }
            }
            return new UnknownErrorException("Unexpected error code in server response", errorCode.toString(), cause);
        }
        catch (IllegalArgumentException iae) {
            return new UnknownErrorException("Unknown error received from server: " + errorString, errorString, cause);
        }
    }

    private void initializeHandlers() {
        ContentTypeBaseHandler handler = new ContentTypeBaseHandler();
        handler.setResponseHandler("application/xml", new GDSJaxbResponseHandler("com.mathworks.webservices.mjs.model.response"));
        handler.setResponseHandler("text/plain", new RawByteResponseHandler());
        handler.setResponseHandler("application/octet-stream", new RawByteResponseHandler());
        handler.setResponseHandler("*/*", new RawByteResponseHandler());
        this.setResponseHandlerNew(handler);
    }
}

