/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.mjs.CloudMJSJobAccess;
import com.mathworks.webservices.mjs.exception.ContentIsEmptyException;
import com.mathworks.webservices.mjs.exception.ContentListEmptyException;
import com.mathworks.webservices.mjs.impl.BaseServiceImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSClientImpl;
import com.mathworks.webservices.mjs.model.ErrorReturn;
import com.mathworks.webservices.mjs.model.ProgressReporter;
import com.mathworks.webservices.mjs.model.job.CloudJob;
import com.mathworks.webservices.mjs.model.job.CloudJobList;
import com.mathworks.webservices.mjs.model.job.CloudJobMetadata;
import com.mathworks.webservices.mjs.model.job.JobUpdateProgressReport;
import com.mathworks.webservices.mjs.model.request.CloudJobCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobUpdateRequest;
import com.mathworks.webservices.mjs.model.response.CloudJobCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobUpdateResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXB;

public class CloudMJSJobAccessImpl
extends BaseServiceImpl
implements CloudMJSJobAccess {
    public CloudMJSJobAccessImpl(CloudMJSClientImpl cloudMJSClient) {
        super(cloudMJSClient);
    }

    @Override
    public CloudJobCreateResponse create(CloudJobCreateRequest cloudJobCreateRequest) {
        this.basicValidation(cloudJobCreateRequest);
        if (cloudJobCreateRequest.getCloudJob() == null) {
            throw new ContentIsEmptyException("CloudJob content cannot be empty");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CloudJobList jobList = new CloudJobList();
        jobList.setCloudJobList(Collections.singletonList(cloudJobCreateRequest.getCloudJob()));
        JAXB.marshal((Object)jobList, (OutputStream)outputStream);
        EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/jobs", null, cloudJobCreateRequest);
        request.addParameter("updateExisting", "false");
        try {
            return (CloudJobCreateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    private CloudJobUpdateResponse updateImpl(CloudJobUpdateRequest cloudJobUpdateRequest, List<CloudJob> jobsToUpdate) {
        CloudJobList cloudJobList = new CloudJobList();
        cloudJobList.setCloudJobList(jobsToUpdate);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)cloudJobList, (OutputStream)outputStream);
        EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/jobs", null, cloudJobUpdateRequest);
        request.addParameter("updateExisting", "true");
        try {
            return (CloudJobUpdateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudJobUpdateResponse update(CloudJobUpdateRequest cloudJobUpdateRequest) {
        this.basicValidation(cloudJobUpdateRequest);
        if (cloudJobUpdateRequest.getCloudJobs() == null || cloudJobUpdateRequest.getCloudJobs().length == 0) {
            throw new ContentListEmptyException("List of jobs cannot be null or empty");
        }
        ProgressReporter<JobUpdateProgressReport> progressReporter = cloudJobUpdateRequest.getProgressReporter();
        int recordsCompleted = 0;
        int maximumNumberOfVectorizedRecords = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumNumberOfVectorizedRecords();
        List<CloudJob> allCouldJobs = Arrays.asList(cloudJobUpdateRequest.getCloudJobs());
        List<List<CloudJob>> sublists = this.subLists(allCouldJobs, maximumNumberOfVectorizedRecords);
        ArrayList<String> updatedUuids = new ArrayList<String>(allCouldJobs.size());
        ArrayList<ErrorReturn> errors = new ArrayList<ErrorReturn>();
        for (List<CloudJob> sublist : sublists) {
            CloudJobUpdateResponse cloudJobUpdateResponse = this.updateImpl(cloudJobUpdateRequest, sublist);
            updatedUuids.addAll(cloudJobUpdateResponse.getUpdatedUuids());
            if (cloudJobUpdateResponse.getErrors() != null) {
                errors.addAll(cloudJobUpdateResponse.getErrors());
            }
            this.reportStatus(progressReporter, new JobUpdateProgressReport(recordsCompleted += sublist.size(), allCouldJobs.size()), "jobUpdate");
        }
        CloudJobUpdateResponse cloudJobUpdateResponse = new CloudJobUpdateResponse();
        cloudJobUpdateResponse.setUpdatedUuids(updatedUuids);
        cloudJobUpdateResponse.setErrors(errors);
        return cloudJobUpdateResponse;
    }

    @Override
    public CloudJobReadResponse read(CloudJobReadRequest cloudJobReadRequest) {
        this.basicValidation(cloudJobReadRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/jobs", null, cloudJobReadRequest);
        this.addRequestMetadataCriteria(request, cloudJobReadRequest.getCloudJobMetadata());
        try {
            return (CloudJobReadResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudJobMetadataReadResponse metadataRead(CloudJobMetadataReadRequest cloudJobMetadataReadRequest) {
        this.basicValidation(cloudJobMetadataReadRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/jobs", null, cloudJobMetadataReadRequest);
        this.addRequestMetadataCriteria(request, cloudJobMetadataReadRequest.getCloudJobMetadata());
        request.addParameter("metadataOnly", Boolean.TRUE.toString());
        try {
            return (CloudJobMetadataReadResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudJobRemoveResponse remove(CloudJobRemoveRequest cloudJobRemoveRequest) {
        this.basicValidation(cloudJobRemoveRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.DELETE, "/v1/jobs", null, cloudJobRemoveRequest);
        this.addRequestMetadataCriteria(request, cloudJobRemoveRequest.getCloudJobMetadata());
        if (cloudJobRemoveRequest.getAllowRemoveAll() != null) {
            request.addParameter("allowRemoveAll", cloudJobRemoveRequest.getAllowRemoveAll().toString());
        }
        try {
            return (CloudJobRemoveResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    private void addRequestMetadataCriteria(HttpRequest request, CloudJobMetadata[] criteriaList) {
        if (criteriaList == null) {
            return;
        }
        for (int index = 0; index < criteriaList.length; ++index) {
            CloudJobMetadata criteria = criteriaList[index];
            if (criteria == null) continue;
            this.addCriteriaParam(request, index, "uuid", criteria.getUuid());
            this.addCriteriaParam(request, index, "queuenum", criteria.getQueuenum());
            this.addCriteriaParam(request, index, "sequence", criteria.getSequence());
            this.addCriteriaParam(request, index, "state", criteria.getState());
            this.addCriteriaParam(request, index, "type", criteria.getType());
        }
    }
}

