/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.impl;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.mjs.CloudMJSTaskAccess;
import com.mathworks.webservices.mjs.exception.ContentListEmptyException;
import com.mathworks.webservices.mjs.impl.BaseServiceImpl;
import com.mathworks.webservices.mjs.impl.CloudMJSClientImpl;
import com.mathworks.webservices.mjs.model.ErrorReturn;
import com.mathworks.webservices.mjs.model.ProgressReporter;
import com.mathworks.webservices.mjs.model.request.CloudTaskCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskUpdateRequest;
import com.mathworks.webservices.mjs.model.response.CloudTaskCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskUpdateResponse;
import com.mathworks.webservices.mjs.model.task.CloudTask;
import com.mathworks.webservices.mjs.model.task.CloudTaskList;
import com.mathworks.webservices.mjs.model.task.CloudTaskMetadata;
import com.mathworks.webservices.mjs.model.task.TaskCreateProgressReport;
import com.mathworks.webservices.mjs.model.task.TaskUpdateProgressReport;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXB;

public class CloudMJSTaskAccessImpl
extends BaseServiceImpl
implements CloudMJSTaskAccess {
    public CloudMJSTaskAccessImpl(CloudMJSClientImpl cloudMJSClient) {
        super(cloudMJSClient);
    }

    @Override
    public CloudTaskCreateResponse create(CloudTaskCreateRequest cloudTaskCreateRequest) {
        this.basicValidation(cloudTaskCreateRequest);
        if (cloudTaskCreateRequest.getCloudTasks() == null || cloudTaskCreateRequest.getCloudTasks().length == 0) {
            throw new ContentListEmptyException("List of tasks to be created cannot be null or empty");
        }
        ProgressReporter<TaskCreateProgressReport> progressReporter = cloudTaskCreateRequest.getProgressReporter();
        int maxVectorizedSize = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumNumberOfVectorizedRecords();
        List<CloudTask> fullMetadataList = Arrays.asList(cloudTaskCreateRequest.getCloudTasks());
        List<List<CloudTask>> subLists = this.subLists(fullMetadataList, maxVectorizedSize);
        ArrayList<CloudTaskMetadata> createdTaskMetadata = new ArrayList<CloudTaskMetadata>(fullMetadataList.size());
        ArrayList<ErrorReturn> errors = new ArrayList<ErrorReturn>();
        TaskCreateProgressReport status = new TaskCreateProgressReport(0L, fullMetadataList.size());
        for (List<CloudTask> taskList : subLists) {
            CloudTaskList cloudTaskList = new CloudTaskList();
            cloudTaskList.setCloudTaskList(taskList);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JAXB.marshal((Object)cloudTaskList, (OutputStream)outputStream);
            EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/tasks", null, cloudTaskCreateRequest);
            try {
                CloudTaskCreateResponse response = (CloudTaskCreateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
                createdTaskMetadata.addAll(response.getCreatedTaskMetadata());
                errors.addAll(response.getErrors());
            }
            catch (MathWorksServiceException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            catch (MathWorksClientException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            status = new TaskCreateProgressReport(status.getUnitsCompleted() + (long)taskList.size(), fullMetadataList.size());
            this.reportStatus(progressReporter, status, "taskCreate");
        }
        CloudTaskCreateResponse response = new CloudTaskCreateResponse();
        response.setCreatedTaskMetadata(createdTaskMetadata);
        response.setErrors(errors);
        return response;
    }

    @Override
    public CloudTaskUpdateResponse update(CloudTaskUpdateRequest cloudTaskUpdateRequest) {
        this.basicValidation(cloudTaskUpdateRequest);
        if (cloudTaskUpdateRequest.getCloudTasks() == null || cloudTaskUpdateRequest.getCloudTasks().length == 0) {
            throw new ContentListEmptyException("List of tasks to be updated cannot be null or empty");
        }
        ProgressReporter<TaskUpdateProgressReport> progressReporter = cloudTaskUpdateRequest.getProgressReporter();
        int maxVectorizedSize = this.getCloudMJSClient().getConfigAccess().getServerConfiguration().getMaximumNumberOfVectorizedRecords();
        List<CloudTask> fullMetadataList = Arrays.asList(cloudTaskUpdateRequest.getCloudTasks());
        List<List<CloudTask>> subLists = this.subLists(fullMetadataList, maxVectorizedSize);
        ArrayList<String> updatedTaskUuids = new ArrayList<String>(fullMetadataList.size());
        ArrayList<ErrorReturn> errors = new ArrayList<ErrorReturn>();
        TaskUpdateProgressReport status = new TaskUpdateProgressReport(0L, fullMetadataList.size());
        for (List<CloudTask> taskList : subLists) {
            CloudTaskList cloudTaskList = new CloudTaskList();
            cloudTaskList.setCloudTaskList(taskList);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JAXB.marshal((Object)cloudTaskList, (OutputStream)outputStream);
            EntityEnclosingRequest request = this.createEntityEnclosingRequest(outputStream, "application/xml", "/v1/tasks", null, cloudTaskUpdateRequest);
            request.addParameter("updateExisting", Boolean.TRUE.toString());
            try {
                CloudTaskUpdateResponse response = (CloudTaskUpdateResponse)this.getCloudMJSClient().executeRequestNew((HttpRequest)request).getResponsePayload();
                updatedTaskUuids.addAll(response.getUpdatedUuids());
                errors.addAll(response.getErrors());
            }
            catch (MathWorksServiceException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            catch (MathWorksClientException ex) {
                throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
            }
            status = new TaskUpdateProgressReport(status.getUnitsCompleted() + (long)taskList.size(), fullMetadataList.size());
            this.reportStatus(progressReporter, status, "taskUpdate");
        }
        CloudTaskUpdateResponse response = new CloudTaskUpdateResponse();
        response.setUpdatedUuids(updatedTaskUuids);
        response.setErrors(errors);
        return response;
    }

    @Override
    public CloudTaskReadResponse read(CloudTaskReadRequest cloudTaskReadRequest) {
        this.basicValidation(cloudTaskReadRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/tasks", null, cloudTaskReadRequest);
        this.addRequestMetadataCriteria(request, cloudTaskReadRequest.getCloudTaskMetadata());
        try {
            return (CloudTaskReadResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudTaskMetadataReadResponse metadataRead(CloudTaskMetadataReadRequest cloudTaskMetadataReadRequest) {
        this.basicValidation(cloudTaskMetadataReadRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.GET, "/v1/tasks", null, cloudTaskMetadataReadRequest);
        this.addRequestMetadataCriteria(request, cloudTaskMetadataReadRequest.getCloudTaskMetadata());
        request.addParameter("metadataOnly", Boolean.TRUE.toString());
        try {
            return (CloudTaskMetadataReadResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    @Override
    public CloudTaskRemoveResponse remove(CloudTaskRemoveRequest cloudTaskRemoveRequest) {
        this.basicValidation(cloudTaskRemoveRequest);
        HttpRequest request = this.createHttpRequestWithQueueContext(HttpMethodName.DELETE, "/v1/tasks", null, cloudTaskRemoveRequest);
        this.addRequestMetadataCriteria(request, cloudTaskRemoveRequest.getCloudTaskMetadata());
        if (cloudTaskRemoveRequest.getAllowRemoveAll() != null) {
            request.addParameter("allowRemoveAll", cloudTaskRemoveRequest.getAllowRemoveAll().toString());
        }
        try {
            return (CloudTaskRemoveResponse)this.getCloudMJSClient().executeRequestNew(request).getResponsePayload();
        }
        catch (MathWorksServiceException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
        catch (MathWorksClientException ex) {
            throw this.getCloudMJSClient().generateClientSideException(ex.getErrorCode(), (Exception)((Object)ex));
        }
    }

    private void addRequestMetadataCriteria(HttpRequest request, CloudTaskMetadata[] criteriaList) {
        if (criteriaList == null) {
            return;
        }
        for (int index = 0; index < criteriaList.length; ++index) {
            CloudTaskMetadata criteria = criteriaList[index];
            if (criteria == null) continue;
            this.addCriteriaParam(request, index, "uuid", criteria.getUuid());
            this.addCriteriaParam(request, index, "jobUuid", criteria.getJobUuid());
            this.addCriteriaParam(request, index, "sequence", criteria.getSequence());
            this.addCriteriaParam(request, index, "state", criteria.getState());
        }
    }
}

