/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mjs.core;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.xml.ErrorMessage;
import com.mathworks.webservices.client.core.xml.ErrorResponse;
import com.mathworks.webservices.mjs.core.GDSServiceResponse;
import com.mathworks.webservices.mjs.core.http.ContentTypeBaseHandler;
import com.mathworks.webservices.mjs.core.http.GDSResponseHandler;
import com.mathworks.webservices.mjs.core.raw.RawByteResponseHandler;
import com.mathworks.webservices.mjs.core.xml.GDSJaxbResponseHandler;
import java.io.IOException;
import org.apache.commons.httpclient.Header;

public class GDSWebServiceClient
extends MathWorksWebServiceClient {
    private final int SERVICE_MOVED_PERMANENTLY = 301;
    private final int SERVICE_NOT_FOUND = 404;
    private final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private final int SERVICE_UNAVAILABLE = 503;
    private String locale;
    private String clientString;
    private GDSResponseHandler responseHandlerNew;
    private GDSResponseHandler errorResponseHandler;

    public GDSWebServiceClient(MathWorksHttpClient httpClient) {
        super(httpClient, null);
        this.initializeErrorHandler();
    }

    public GDSWebServiceClient(ClientConfiguration config) {
        super(config);
        this.initializeErrorHandler();
    }

    public void setLocale(String locale) {
        this.locale = locale;
        super.setLocale(locale);
    }

    public void setClientString(String clientString) {
        this.clientString = clientString;
        super.setClientString(clientString);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getLocale() {
        return this.locale;
    }

    public GDSServiceResponse executeRequestNew(HttpRequest request) {
        this.addClientLevelLocaleAndClientStringIfEmptyOnRequest(request);
        this.validateRequest(request);
        if (this.getResponseHandlerNew() == null) {
            throw new MathWorksClientException("Handler not set. Cannot execute request");
        }
        try {
            ServiceUnavailableException sue;
            ErrorResponse error;
            Object responseBody;
            Header endpointHeader;
            request.getRequest().setFollowRedirects(false);
            HttpResponse httpResp = this.httpClient.invoke(request.getRequest());
            int respCode = httpResp.getStatusCode();
            if (301 == respCode && (endpointHeader = request.getRequest().getResponseHeader("x-mw-new-endpoint")) != null) {
                String newEndpoint = endpointHeader.getValue();
                if (newEndpoint != null && !newEndpoint.equalsIgnoreCase(this.endpoint)) {
                    this.endpoint = newEndpoint;
                    request.setEndpoint(this.endpoint);
                    httpResp = this.httpClient.invoke(request.getRequest(true));
                    respCode = httpResp.getStatusCode();
                } else {
                    throw new ServiceNotFoundException("301 response did not provide a valid endpoint header.");
                }
            }
            if (407 == respCode) {
                throw new ProxyAuthenticationRequiredException(httpResp.getStatusText());
            }
            if (404 == respCode) {
                try {
                    responseBody = this.getErrorResponseHandler().handleResponse(httpResp);
                }
                catch (Exception ex) {
                    ServiceNotFoundException snfe = new ServiceNotFoundException(httpResp.getStatusText());
                    snfe.setRequestId(httpResp.getRequestId());
                    throw snfe;
                }
                if (responseBody instanceof ErrorResponse) {
                    error = (ErrorResponse)responseBody;
                    ErrorMessage message = this.getErrorMessage(error);
                    ServiceNotFoundException ex = new ServiceNotFoundException(message.getMessage());
                    ex.setErrorCode(message.getCode());
                    ex.setRequestId(error.getRequestId());
                    throw ex;
                }
                ServiceNotFoundException snfe = new ServiceNotFoundException(httpResp.getStatusText());
                snfe.setRequestId(httpResp.getRequestId());
                throw snfe;
            }
            if (503 == respCode) {
                try {
                    responseBody = this.getErrorResponseHandler().handleResponse(httpResp);
                }
                catch (Exception ex) {
                    ServiceUnavailableException sue2 = new ServiceUnavailableException(httpResp.getStatusText());
                    sue2.setRequestId(httpResp.getRequestId());
                    sue2.setStatusCode(respCode);
                    throw sue2;
                }
                if (responseBody instanceof ErrorResponse) {
                    error = (ErrorResponse)responseBody;
                    ErrorMessage message = this.getErrorMessage(error);
                    ServiceUnavailableException ex = new ServiceUnavailableException(message.getMessage());
                    ex.setStatusCode(respCode);
                    ex.setErrorCode(message.getCode());
                    ex.setRequestId(error.getRequestId());
                    throw ex;
                }
                sue = new ServiceUnavailableException(httpResp.getStatusText());
                sue.setRequestId(httpResp.getRequestId());
                sue.setStatusCode(respCode);
                throw sue;
            }
            if (301 != respCode && respCode > 299) {
                try {
                    responseBody = this.getErrorResponseHandler().handleResponse(httpResp);
                }
                catch (Exception ex) {
                    MathWorksClientException sue3 = new MathWorksClientException(httpResp.getStatusText());
                    sue3.setRequestId(httpResp.getRequestId());
                    throw sue3;
                }
                if (responseBody instanceof ErrorResponse) {
                    error = (ErrorResponse)responseBody;
                    ErrorMessage message = this.getErrorMessage(error);
                    if ("Server".equalsIgnoreCase(error.getErrorType())) {
                        MathWorksServiceException ex = new MathWorksServiceException(message.getMessage());
                        ex.setStatusCode(respCode);
                        ex.setErrorCode(message.getCode());
                        ex.setRequestId(error.getRequestId());
                        throw ex;
                    }
                    MathWorksClientException ex = new MathWorksClientException(message.getMessage());
                    ex.setErrorCode(message.getCode());
                    ex.setRequestId(error.getRequestId());
                    throw ex;
                }
                sue = new MathWorksClientException(httpResp.getStatusText());
                sue.setRequestId(httpResp.getRequestId());
                throw sue;
            }
            GDSServiceResponse response = new GDSServiceResponse();
            response.setHeaders(httpResp.getHeaders());
            response.setRequestId(httpResp.getRequestId());
            response.setStatusCode(respCode);
            response.setSignature(httpResp.getSignature());
            Object body = this.getResponseHandlerNew().handleResponse(httpResp);
            response.setResponsePayload(body);
            GDSServiceResponse gDSServiceResponse = response;
            return gDSServiceResponse;
        }
        catch (IOException e) {
            throw new MathWorksClientException("unable to connect to host. " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (request.getRequest() != null) {
                request.getRequest().releaseConnection();
            }
        }
    }

    public GDSResponseHandler getResponseHandlerNew() {
        return this.responseHandlerNew;
    }

    public void setResponseHandlerNew(GDSResponseHandler responseHandlerNew) {
        this.responseHandlerNew = responseHandlerNew;
    }

    public GDSResponseHandler getErrorResponseHandler() {
        return this.errorResponseHandler;
    }

    private void initializeErrorHandler() {
        ContentTypeBaseHandler handler = new ContentTypeBaseHandler();
        handler.setResponseHandler("application/xml", new GDSJaxbResponseHandler("com.mathworks.webservices.client.core.xml"));
        handler.setResponseHandler("*/*", new RawByteResponseHandler());
        this.errorResponseHandler = handler;
    }

    private ErrorMessage getErrorMessage(ErrorResponse error) {
        try {
            ErrorMessage message = (ErrorMessage)error.getErrors().get(0);
            return message;
        }
        catch (Throwable t) {
            ErrorMessage message = new ErrorMessage();
            message.setCode("");
            message.setMessage("");
            return message;
        }
    }

    private void addClientLevelLocaleAndClientStringIfEmptyOnRequest(HttpRequest request) {
        String locale;
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            request.setClientString(this.clientString);
        }
        if ((locale = request.getLocale()) == null || "".equals(locale)) {
            request.setLocale(this.locale);
        }
        if (((locale = (String)request.getHeaders().get("Accept-Language")) == null || "".equals(locale)) && this.locale != null && !this.locale.isEmpty()) {
            String bcp47LocaleString = this.locale.replaceAll("_", "-");
            request.addHeader("Accept-Language", bcp47LocaleString);
        }
    }

    private void validateRequest(HttpRequest request) throws MathWorksClientException {
        String endpoint = request.getEndpoint();
        if (endpoint == null || "".equals(endpoint)) {
            throw new MathWorksClientException("You must define an endpoint for the service client.");
        }
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            throw new MathWorksClientException("You must set the clientString on your request.");
        }
        String locale = request.getLocale();
        if (locale == null || "".equals(locale)) {
            throw new MathWorksClientException("You must set the locale on your request.");
        }
    }
}

