/*
 * Decompiled with CFR 0.152.
 */
package net.jini.config;

import [Ljava.lang.String;;
import com.sun.jini.logging.Levels;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationFile;
import net.jini.config.Utilities;
import net.jini.security.Security;

public class ConfigurationProvider {
    private static final String resourceName = "META-INF/services/" + Configuration.class.getName();
    private static final Logger logger = Logger.getLogger("net.jini.config");

    private ConfigurationProvider() {
        throw new AssertionError();
    }

    public static Configuration getInstance(String[] stringArray) throws ConfigurationException {
        return ConfigurationProvider.getInstance(stringArray, null);
    }

    public static Configuration getInstance(String[] stringArray, ClassLoader classLoader) throws ConfigurationException {
        Object object;
        ClassLoader classLoader2 = classLoader != null ? classLoader : (ClassLoader)Security.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        final ClassLoader classLoader3 = classLoader2 == null ? Utilities.bootstrapResourceLoader : classLoader2;
        String string = null;
        ConfigurationException configurationException = null;
        try {
            string = (String)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ConfigurationException, IOException {
                    URL uRL = null;
                    Enumeration<URL> enumeration = classLoader3.getResources(resourceName);
                    while (enumeration.hasMoreElements()) {
                        uRL = enumeration.nextElement();
                    }
                    return uRL == null ? null : ConfigurationProvider.getProviderName(uRL);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException.getException();
            configurationException = object instanceof ConfigurationException ? (ConfigurationException)object : new ConfigurationException("problem accessing provider resources", (Throwable)object);
        }
        catch (RuntimeException runtimeException) {
            configurationException = new ConfigurationException("problem accessing provider resources", runtimeException);
        }
        if (configurationException != null) {
            logger.log(Levels.FAILED, "getting configuration provider throws", configurationException);
            throw configurationException;
        }
        if (string == null) {
            return new ConfigurationFile(stringArray, classLoader);
        }
        try {
            Class<?> clazz = Class.forName(string, true, classLoader2);
            if (Configuration.class.isAssignableFrom(clazz)) {
                object = clazz.getConstructor(String;.class, ClassLoader.class);
                return (Configuration)((Constructor)object).newInstance(stringArray, classLoader);
            }
            configurationException = new ConfigurationException("provider class " + string + " does not implement Configuration");
        }
        catch (ClassNotFoundException classNotFoundException) {
            configurationException = new ConfigurationException("provider class " + string + " not found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            configurationException = new ConfigurationException("provider class " + string + " does not have the right constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            configurationException = new ConfigurationException("provider class " + string + " constructor is not public");
        }
        catch (InstantiationException instantiationException) {
            configurationException = new ConfigurationException("provider class " + string + " is abstract");
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException();
            if (object instanceof Error) {
                throw (Error)object;
            }
            configurationException = object instanceof ConfigurationException ? (ConfigurationException)object : new ConfigurationException("problem with provider class", (Throwable)object);
        }
        catch (RuntimeException runtimeException) {
            configurationException = new ConfigurationException("problem with provider class", runtimeException);
        }
        logger.log(Levels.FAILED, "getting configuration throws", configurationException);
        throw configurationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProviderName(URL uRL) throws ConfigurationException, IOException {
        String string;
        block9: {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    int n;
                    int n2 = string.indexOf(35);
                    if (n2 >= 0) {
                        string = string.substring(0, n2);
                    }
                    if ((n = (string = string.trim()).length()) == 0) continue;
                    if (string2 != null) {
                        throw new ConfigurationException("resource specifies multiple providers");
                    }
                    string2 = string;
                }
                if (string2 == null) {
                    throw new ConfigurationException("resource specifies no providers");
                }
                string = string2;
                Object var8_7 = null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_8 = null;
                    if (inputStream == null) break block10;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }
}

