/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlParser;
import com.mathworks.help.helpui.HelpBrowserSearchConfig;
import com.mathworks.help.helpui.LanguageDocUrlRule;
import com.mathworks.help.helpui.LocalDocSetParser;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.HelpPathBuilder;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.Url;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public abstract class AbstractDocConfig<T extends Url>
implements DocConfig<T> {
    private final File fDocSetDir;
    private final DocumentationSet fDocumentationSet;
    private final Collection<File> fLocalDocRoots = new HashSet<File>();
    private final Collection<File> fAddOnDirs = new LinkedList<File>();
    private DocUrlParser fDocUrlParser;
    private SearchConfig fSearchConfig;

    protected AbstractDocConfig(File file, DocLanguage docLanguage) {
        this.fDocSetDir = file;
        this.fDocumentationSet = LocalDocSetParser.parseDocumentationSet(file, docLanguage);
    }

    protected void addDocAddOns(Map<DocAddOn, File> map) {
        for (Map.Entry<DocAddOn, File> entry : map.entrySet()) {
            DocAddOn docAddOn = entry.getKey();
            File file = entry.getValue();
            this.fLocalDocRoots.add(file);
            docAddOn.getParentProduct().addDocAddOn(docAddOn);
            File file2 = (File)docAddOn.getHelpLocation().buildHelpPath((Object)file, (HelpPathBuilder)new FileHelpPathBuilder(), new String[0]);
            this.fAddOnDirs.add(file2);
        }
    }

    @Override
    public synchronized DocUrlParser getDocUrlParser() {
        if (this.fDocUrlParser == null) {
            DocRoot docRoot = this.getDocRoot();
            Collection<File> collection = this.getLocalDocRoots();
            DocumentationSet documentationSet = this.getDocumentationSet();
            this.fDocUrlParser = new DocUrlParser(docRoot, collection, documentationSet, this.getDocUrlNavigationRules());
        }
        return this.fDocUrlParser;
    }

    @Override
    public synchronized SearchConfig getSearchConfig() {
        if (this.fSearchConfig == null) {
            this.fSearchConfig = this.buildSearchConfig();
        }
        return this.fSearchConfig;
    }

    private SearchConfig buildSearchConfig() {
        return new HelpBrowserSearchConfig(this.getDocumentationSet().getLanguage(), this.fDocSetDir, this.fAddOnDirs);
    }

    @Override
    public DocumentationSet getDocumentationSet() {
        return this.fDocumentationSet;
    }

    @Override
    public Collection<DocUrlNavigationRule> getDocUrlNavigationRules() {
        ArrayList<DocUrlNavigationRule> arrayList = new ArrayList<DocUrlNavigationRule>();
        arrayList.add(new LanguageDocUrlRule(this.getDocumentationSet().getLanguage()));
        return arrayList;
    }

    protected Collection<File> getLocalDocRoots() {
        return Collections.unmodifiableCollection(this.fLocalDocRoots);
    }
}

