/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.help.helpui.FileUrlHelpPathBuilder;
import com.mathworks.help.helpui.WebDocUrlConfig;
import com.mathworks.help.helpui.WebUrlHelpPathBuilder;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.HelpPathBuilder;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.html.ChildUrlRelativizer;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DocRoot<T extends Url> {
    static final String SEARCH_RESULTS_PAGE = "searchresults.html";
    static final String SEARCH_RESULTS_PAGE_DIR = "templates";
    private static final String SEARCH_RESULTS_RELATIVE_PATH = "templates/searchresults.html";
    private final DocRootUrlBuilderFactory<T> fDocRootUrlBuilderFactory;

    private DocRoot(DocRootUrlBuilderFactory<T> docRootUrlBuilderFactory) {
        this.fDocRootUrlBuilderFactory = docRootUrlBuilderFactory;
    }

    public static DocRoot<FileUrl> create(FileUrl fileUrl) {
        return new DocRoot<FileUrl>(new FileDocRootUrlBuilderFactory(fileUrl));
    }

    public static DocRoot<WebUrl> create(WebUrl webUrl, WebDocUrlConfig webDocUrlConfig) {
        return new DocRoot<WebUrl>(new WebDocRootUrlBuilderFactory(webUrl, webDocUrlConfig));
    }

    public T buildDocPageUrl(DocPage docPage) {
        return this.buildDocSetItemUrl(docPage.getDocSetItem(), docPage.getRelativeUrl());
    }

    public T buildDocSetItemUrl(DocSetItem docSetItem, String string) {
        if (string == null || string.trim().isEmpty()) {
            return this.buildDocSetItemLandingPageUrl(docSetItem);
        }
        return this.buildUrl(docSetItem, string);
    }

    public T buildDocSetItemUrl(DocSetItem docSetItem, RelativeUrl relativeUrl) {
        if (relativeUrl == null) {
            return this.buildDocSetItemLandingPageUrl(docSetItem);
        }
        return this.buildUrl(docSetItem, relativeUrl);
    }

    public T buildGlobalPageUrl(String string) {
        if (string == null || string.trim().isEmpty()) {
            return this.buildGlobalLandingPageUrl();
        }
        return this.buildUrl((HelpLocation)null, string);
    }

    public T buildGlobalPageUrl(RelativeUrl relativeUrl) {
        if (relativeUrl == null) {
            return this.buildGlobalLandingPageUrl();
        }
        return this.buildUrl((HelpLocation)null, relativeUrl);
    }

    public T buildHelpLocationUrl(DocSetItem docSetItem) {
        return this.buildHelpLocationUrl(docSetItem.getHelpLocation());
    }

    public T buildHelpLocationUrl(HelpLocation helpLocation) {
        return this.buildUrl(helpLocation, new String[0]);
    }

    public T buildDocSetItemLandingPageUrl(DocSetItem docSetItem) {
        return this.buildDocPageUrl(DocPage.getDocSetItemLandingPage(docSetItem));
    }

    public T buildGlobalLandingPageUrl() {
        return this.buildDocPageUrl(DocPage.getGlobalLandingPage());
    }

    public T buildSearchPageUrl(String string) {
        DocumentationQuery documentationQuery = new DocumentationQuery(string, ContentFormat.DOC_CENTER_DOC);
        return this.buildSearchPageUrl(documentationQuery, 1);
    }

    public T buildSearchPageUrl(DocumentationQuery documentationQuery, int n) {
        UrlBuilder<T> urlBuilder = this.fDocRootUrlBuilderFactory.createSearchUrlBuilder();
        urlBuilder.addParameter("qdoc", new String[]{documentationQuery.getFullSearchString()});
        if (n != 1) {
            urlBuilder.addParameter("page", new String[]{String.valueOf(n)});
        }
        return (T)urlBuilder.toUrl();
    }

    private T buildUrl(DocSetItem docSetItem, String ... stringArray) {
        HelpLocation helpLocation = docSetItem == null ? null : docSetItem.getHelpLocation();
        return this.buildUrl(helpLocation, stringArray);
    }

    private T buildUrl(DocSetItem docSetItem, RelativeUrl relativeUrl) {
        HelpLocation helpLocation = docSetItem == null ? null : docSetItem.getHelpLocation();
        return this.buildUrl(helpLocation, relativeUrl);
    }

    private T buildUrl(HelpLocation helpLocation, String ... stringArray) {
        UrlBuilder<T> urlBuilder = this.getHelpLocationUrlBuilder(helpLocation);
        if (stringArray.length > 0) {
            urlBuilder.append(stringArray);
        }
        return (T)urlBuilder.toUrl();
    }

    private T buildUrl(HelpLocation helpLocation, RelativeUrl relativeUrl) {
        UrlBuilder<T> urlBuilder = this.getHelpLocationUrlBuilder(helpLocation);
        urlBuilder.append(relativeUrl);
        return (T)urlBuilder.toUrl();
    }

    private UrlBuilder<T> getHelpLocationUrlBuilder(HelpLocation helpLocation) {
        return ((DocRootUrlBuilderFactory)this.fDocRootUrlBuilderFactory).createDocUrlBuilder(helpLocation);
    }

    RelativeUrl getRelativeUrlTo(Url url, Iterable<DocUrlNavigationRule> iterable) {
        DocUrlType docUrlType = this.getDocUrlType(url);
        UrlBuilder urlBuilder = url.toUrlBuilder();
        for (DocUrlNavigationRule object2 : iterable) {
            object2.remove(urlBuilder, docUrlType);
        }
        url = urlBuilder.toUrl();
        List<T> list = this.fDocRootUrlBuilderFactory.getBaseUrlsForRelativePath();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Url url2 = (Url)iterator.next();
            ChildUrlRelativizer childUrlRelativizer = new ChildUrlRelativizer(url2);
            RelativeUrl relativeUrl = childUrlRelativizer.getRelativeUrlTo(url);
            if (relativeUrl == null) continue;
            return relativeUrl;
        }
        return null;
    }

    static String getLanguageParameter(DocLanguage docLanguage) {
        return docLanguage == null ? null : docLanguage.getDirectory().replaceAll("_", "-");
    }

    public boolean isUnderDocRoot(Url url) {
        List<T> list = this.fDocRootUrlBuilderFactory.getBaseUrlsForRelativePath();
        for (Url url2 : list) {
            ChildUrlRelativizer childUrlRelativizer = new ChildUrlRelativizer(url2);
            if (!childUrlRelativizer.isChild(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchPageUrl(Url url) {
        Url url2 = this.fDocRootUrlBuilderFactory.createSearchUrlBuilder().toUrl();
        Set set = url2.diffTo(url);
        return !set.contains(Url.UrlPart.BASE);
    }

    private boolean isGlobalLandingPage(Url url) {
        T t = this.buildGlobalLandingPageUrl();
        Set set = t.diffTo(url);
        return !set.contains(Url.UrlPart.BASE);
    }

    public DocUrlType getDocUrlType(Url url) {
        if (this.isSearchPageUrl(url)) {
            return DocUrlType.SEARCH;
        }
        if (this.isGlobalLandingPage(url)) {
            return DocUrlType.GLOBAL_LANDING_PAGE;
        }
        return DocUrlType.CONTENT;
    }

    private static class FileDocRootUrlBuilderFactory
    extends DocRootUrlBuilderFactory<FileUrl> {
        private final FileUrl iSearchResultsPage;

        private FileDocRootUrlBuilderFactory(FileUrl fileUrl) {
            super((Url)fileUrl, new FileUrlHelpPathBuilder(), null);
            this.iSearchResultsPage = new FileUrl(FileDocRootUrlBuilderFactory.findSearchResultsPage(fileUrl.getFile()));
        }

        private static File findSearchResultsPage(File file) {
            File file2 = file;
            for (int n = 0; n < 3 && file2 != null; file2 = file2.getParentFile(), ++n) {
                File file3 = new File(file2, DocRoot.SEARCH_RESULTS_RELATIVE_PATH);
                if (!file3.exists()) continue;
                return file3;
            }
            return new File(file, DocRoot.SEARCH_RESULTS_RELATIVE_PATH);
        }

        @Override
        protected FileUrl createContentDocRootUrl() {
            return (FileUrl)this.getDocRootUrl();
        }

        @Override
        protected UrlBuilder<FileUrl> createSearchUrlBuilder() {
            return this.iSearchResultsPage.toUrlBuilder();
        }

        @Override
        protected List<FileUrl> getBaseUrlsForRelativePath() {
            return Arrays.asList((FileUrl)this.getDocRootUrl());
        }
    }

    private static class WebDocRootUrlBuilderFactory
    extends DocRootUrlBuilderFactory<WebUrl> {
        private final DocLanguage iLanguage;
        private final String iRelease;
        private final WebUrl iDocRootWithRelease;

        private WebDocRootUrlBuilderFactory(WebUrl webUrl, WebDocUrlConfig webDocUrlConfig) {
            super((Url)WebDocRootUrlBuilderFactory.fixWebDocRoot(webUrl), new WebUrlHelpPathBuilder(), null);
            this.iLanguage = webDocUrlConfig.getLanguage();
            this.iRelease = webDocUrlConfig.getRelease();
            this.iDocRootWithRelease = WebDocRootUrlBuilderFactory.getDocRootWithRelease((WebUrl)super.getDocRootUrl(), this.iRelease);
        }

        private static WebUrl getDocRootWithRelease(WebUrl webUrl, String string) {
            if (string != null) {
                return (WebUrl)webUrl.toUrlBuilder().append(new String[]{"releases", string}).toUrl();
            }
            return null;
        }

        private static WebUrl fixWebDocRoot(WebUrl webUrl) {
            String string = webUrl.toString();
            if (!(string = string.replaceFirst("/releases/[Rr]20\\d\\d[AaBb]/?$", "/")).equals(webUrl.toString())) {
                try {
                    return new WebUrl(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return webUrl;
        }

        @Override
        protected WebUrl createContentDocRootUrl() {
            return this.iDocRootWithRelease == null ? (WebUrl)this.getDocRootUrl() : this.iDocRootWithRelease;
        }

        @Override
        protected UrlBuilder<WebUrl> createSearchUrlBuilder() {
            UrlBuilder urlBuilder = ((WebUrl)this.getDocRootUrl()).toUrlBuilder();
            urlBuilder.append(new String[]{"search", "doccenter", this.iLanguage.getDirectory(), this.iRelease});
            return urlBuilder;
        }

        @Override
        protected List<WebUrl> getBaseUrlsForRelativePath() {
            if (this.iDocRootWithRelease == null) {
                return Arrays.asList((WebUrl)this.getDocRootUrl());
            }
            return Arrays.asList(this.iDocRootWithRelease, (WebUrl)this.getDocRootUrl());
        }
    }

    private static abstract class DocRootUrlBuilderFactory<T extends Url> {
        private final T iDocRootUrl;
        private final HelpPathBuilder<T> iHelpPathBuilder;

        private DocRootUrlBuilderFactory(T t, HelpPathBuilder<T> helpPathBuilder) {
            this.iDocRootUrl = t;
            this.iHelpPathBuilder = helpPathBuilder;
        }

        protected final T getDocRootUrl() {
            return this.iDocRootUrl;
        }

        private UrlBuilder<T> createDocUrlBuilder(HelpLocation helpLocation) {
            T t = this.createContentDocRootUrl();
            if (helpLocation == null) {
                return UrlBuilder.fromUrl(t);
            }
            Url url = (Url)helpLocation.buildHelpPath(t, this.iHelpPathBuilder, new String[0]);
            return UrlBuilder.fromUrl((Url)url);
        }

        protected abstract T createContentDocRootUrl();

        protected abstract UrlBuilder<T> createSearchUrlBuilder();

        protected abstract List<T> getBaseUrlsForRelativePath();

        /* synthetic */ DocRootUrlBuilderFactory(Url url, HelpPathBuilder helpPathBuilder, 1 var3_3) {
            this(url, helpPathBuilder);
        }
    }
}

