/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonStringUtils;
import com.mathworks.help.helpui.search.DocSearchResultPage;
import com.mathworks.help.helpui.search.LocalDocSearchPage;
import com.mathworks.help.helpui.search.NoResultJsonBuilder;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchEngineDocSearcher;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.Url;
import com.mathworks.html.UrlVisitor;
import com.mathworks.html.WebUrl;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchIndexException;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchStringParseException;
import java.io.File;

public class DocSearchPageChangedListener
implements PageChangedListener {
    private static final int MAX_RESULTS = Integer.MAX_VALUE;
    private static final int NUM_SEARCH_RESULTS = 10;
    private final HtmlComponent fHtmlComponent;
    private final DocConfig<FileUrl> fDocConfig;

    public DocSearchPageChangedListener(HtmlComponent htmlComponent, DocConfig<FileUrl> docConfig) {
        this.fHtmlComponent = htmlComponent;
        this.fDocConfig = docConfig;
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        Url url;
        if (pageChangedEvent != null && (url = pageChangedEvent.getNewUrl()) != null) {
            url.accept((UrlVisitor)new DocSearchUrlVisitor());
        }
    }

    private DocRoot<FileUrl> getDocRoot() {
        return this.fDocConfig.getDocRoot();
    }

    private void doSearchAsynchronous(final FileUrl fileUrl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocSearchPageChangedListener.this.doSearch(fileUrl);
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearch(FileUrl fileUrl) {
        LocalDocSearchPage localDocSearchPage = LocalDocSearchPage.fromSearchResultsPage(fileUrl);
        if (!DocSearchPageChangedListener.validateSearchText(localDocSearchPage)) {
            this.doDisplaySearchError(HelpBrowserUtils.getString("helpbrowser.error.search.string"), "");
            return;
        }
        DocumentationQuery documentationQuery = localDocSearchPage.getQuery();
        String string = documentationQuery.getSearchText();
        SearchEngineDocSearcher searchEngineDocSearcher = null;
        try {
            searchEngineDocSearcher = this.getSearcher(documentationQuery);
            searchEngineDocSearcher.doSearch();
            int n = DocSearchPageChangedListener.getStartPosition(localDocSearchPage.getPageNum());
            SearchResults searchResults = searchEngineDocSearcher.getSearchResults(n, 10);
            if (searchResults.getFullResultCount() == 0) {
                this.doDisplayNoResults(string);
                return;
            }
            DocSearchResultPage docSearchResultPage = new DocSearchResultPage(this.fDocConfig, localDocSearchPage, (SearchResults<DocumentationSearchResult>)searchResults, searchEngineDocSearcher.getFacetResults());
            JsonEntity jsonEntity = docSearchResultPage.getJsonPageData();
            JsonEntity jsonEntity2 = docSearchResultPage.getJsonFacetLabel();
            JsonEntity jsonEntity3 = docSearchResultPage.getJsonFacetResults();
            JsonEntity jsonEntity4 = docSearchResultPage.getJsonSearchResults();
            JsonEntity jsonEntity5 = docSearchResultPage.getJsonSearchTerm();
            this.doDisplaySearchResults(jsonEntity4.getJsonString(), jsonEntity.getJsonString(), jsonEntity3.getJsonString(), jsonEntity2.getJsonString(), jsonEntity5.getJsonString());
        }
        catch (SearchStringParseException searchStringParseException) {
            this.doDisplaySearchError(DocSearchPageChangedListener.getErrorMessage(searchStringParseException), string);
        }
        catch (SearchIndexException searchIndexException) {
            this.doDisplaySearchError(DocSearchPageChangedListener.getErrorMessage(searchIndexException), string);
        }
        catch (Exception exception) {
            this.doDisplaySearchError(HelpBrowserUtils.getString("helpbrowser.error.search.general"), string);
        }
        finally {
            if (searchEngineDocSearcher != null) {
                try {
                    searchEngineDocSearcher.cleanup();
                }
                catch (SearchException searchException) {}
            }
        }
    }

    private static boolean validateSearchText(LocalDocSearchPage localDocSearchPage) {
        DocumentationQuery documentationQuery = localDocSearchPage.getQuery();
        String string = documentationQuery.getSearchText();
        return string != null && !string.trim().isEmpty() || !documentationQuery.getFacets().isEmpty();
    }

    private SearchEngineDocSearcher getSearcher(DocumentationQuery documentationQuery) throws SearchStringParseException {
        SearchConfig searchConfig = this.fDocConfig.getSearchConfig();
        DocumentationSet documentationSet = this.fDocConfig.getDocumentationSet();
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)searchConfig, (DocumentationSet)documentationSet);
        SearchEngineDocSearcher searchEngineDocSearcher = new SearchEngineDocSearcher(documentationSet, searchEngine, documentationQuery);
        searchEngineDocSearcher.setMaxResults(Integer.MAX_VALUE);
        ProductFilter productFilter = this.fDocConfig.getProductFilter();
        if (productFilter != null) {
            searchEngineDocSearcher.addProductFilter(productFilter);
        }
        return searchEngineDocSearcher;
    }

    public static int getStartPosition(int n) {
        return (n - 1) * 10;
    }

    public static int getEndPosition(int n, int n2) {
        int n3 = n + 10 - 1;
        if (n3 < n2) {
            return n3;
        }
        return n2 - 1;
    }

    private static String getErrorMessage(SearchStringParseException searchStringParseException) {
        return HelpBrowserUtils.getString(DocSearchPageChangedListener.getErrorMessageKey(searchStringParseException.getType()));
    }

    private static String getErrorMessageKey(SearchStringParseException.Type type) {
        switch (type) {
            case EMPTY_SEARCH_STRING: {
                return "helpbrowser.error.search.string";
            }
            case MISMATCHED_QUOTES: {
                return "helpbrowser.error.search.mismatched_quotes";
            }
            case TOO_FEW_NONWILDCARD_CHARS: {
                return "helpbrowser.error.search.too_few_nonwildcard";
            }
            case WILDCARD_IN_EXACT_PHRASE: {
                return "helpbrowser.error.search.wildcard_exact_phrase";
            }
            case STARTS_WITH_WILDCARD: {
                return "helpbrowser.error.search.wildcard_start";
            }
            case NO_SEARCHABLE_WORDS: {
                return "helpbrowser.error.search.no_searchable_words";
            }
            case TOO_FEW_CHARS: {
                return "helpbrowser.error.search.too_few_chars";
            }
        }
        return "helpbrowser.error.search.general";
    }

    private static String getErrorMessage(SearchIndexException searchIndexException) {
        return HelpBrowserUtils.getString(DocSearchPageChangedListener.getErrorMessageKey(searchIndexException.getType()));
    }

    private static String getErrorMessageKey(SearchIndexException.Type type) {
        switch (type) {
            case INDEX_NOT_FOUND: {
                return "helpbrowser.error.index.index_not_found";
            }
            case INDEX_INCOMPATIBLE: {
                return "helpbrowser.error.index.index_incompatible";
            }
        }
        return "helpbrowser.error.index.general";
    }

    private void doDisplaySearchError(String string, String string2) {
        String string3 = JsonStringUtils.toJsonString(string);
        String string4 = JsonStringUtils.toJsonString(string2);
        this.fHtmlComponent.executeScript(String.format("displayError(%s,%s);", string3, string4));
    }

    private void doDisplaySearchResults(String string, String string2, String string3, String string4, String string5) {
        this.fHtmlComponent.executeScript(String.format("populateLookupTable(%s);", string4));
        this.fHtmlComponent.executeScript(String.format("populateResultsList(%s, %s);", string, string5));
        this.fHtmlComponent.executeScript(String.format("populateResultData(%s);", string2));
        this.fHtmlComponent.executeScript(String.format("populateFacets(%s);", string3));
    }

    private void doDisplayNoResults(String string) {
        NoResultJsonBuilder noResultJsonBuilder = new NoResultJsonBuilder(string);
        JsonEntity jsonEntity = noResultJsonBuilder.getJsonNoResults();
        this.fHtmlComponent.executeScript(String.format("displayMessage(%s);", jsonEntity.getJsonString()));
    }

    private class DocSearchUrlVisitor
    implements UrlVisitor {
        private DocSearchUrlVisitor() {
        }

        public void visitFileUrl(FileUrl fileUrl) {
            if (DocSearchPageChangedListener.this.getDocRoot().isSearchPageUrl((Url)fileUrl) || this.isAlternateSearchPage(fileUrl)) {
                DocSearchPageChangedListener.this.doSearchAsynchronous(fileUrl);
            }
        }

        private boolean isAlternateSearchPage(FileUrl fileUrl) {
            File file;
            return DocSearchPageChangedListener.this.fDocConfig.getDocUrlParser().resolve((Url)fileUrl) != null && (file = fileUrl.getFile()).getName().equalsIgnoreCase("searchresults.html") && file.getParentFile().getName().equalsIgnoreCase("templates");
        }

        public void visitWebUrl(WebUrl webUrl) {
        }

        public void visitCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
        }
    }
}

