/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.DocUrlNavigationRuleHandler;
import com.mathworks.help.helpui.HelpBrowserComponentHelper;
import com.mathworks.help.helpui.HelpBrowserDocConfig;
import com.mathworks.help.helpui.HelpBrowserFindHandler;
import com.mathworks.help.helpui.HelpBrowserLocaleHelper;
import com.mathworks.help.helpui.HelpBrowserToolBar;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.HelpLinkClickedHandler;
import com.mathworks.help.helpui.LocaleHelper;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.helpsearch.csh.CshResult;
import com.mathworks.helpsearch.csh.SearchEngineCshRetriever;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.html.BasicHtmlActions;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.DefaultViewSourceHandler;
import com.mathworks.html.FileUrl;
import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.FindPanel;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class HelpBrowserComponent {
    private static final String F1_PARAM_NAME = "browser";
    private static final String F1_PARAM_VALUE = "F1help";
    private final String fHelpDir;
    private final JPanel fPanel;
    private final HtmlPanel fHtmlComponent;
    private final DocConfig<FileUrl> fDocConfig;
    private final DocUrlNavigationRuleHandler fRuleHandler;
    private FindPanel fFindPanel;

    public HelpBrowserComponent(String string) {
        this(string, false);
    }

    public HelpBrowserComponent(String string, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "HelpBrowserComponent must be created on the EDT.";
        this.fHtmlComponent = HelpBrowserComponent.createHtmlPanel();
        this.fHelpDir = string;
        File file = HelpBrowserComponent.getHelpDir(this.fHelpDir);
        if (file != null) {
            this.fDocConfig = new HelpBrowserDocConfig(file, (LocaleHelper)new HelpBrowserLocaleHelper());
            this.fRuleHandler = new DocUrlNavigationRuleHandler(this.fDocConfig.getDocUrlNavigationRules());
            this.addHandlersForInstalledDoc(this.fDocConfig, this.fHtmlComponent);
        } else {
            this.fDocConfig = null;
            this.fRuleHandler = new DocUrlNavigationRuleHandler(Collections.emptyList());
        }
        this.fPanel = this.createPanel(this.fHtmlComponent, bl);
        this.setupKeyBindings();
        this.fHtmlComponent.getComponent().requestFocusInWindow();
    }

    private static HtmlPanel createHtmlPanel() {
        try {
            return new HtmlPanel(HtmlPanel.BrowserType.CHROMIUM);
        }
        catch (Throwable throwable) {
            return new HtmlPanel(HtmlPanel.BrowserType.JXBROWSER);
        }
    }

    private static File getHelpDir(String string) {
        boolean bl;
        File file = null;
        boolean bl2 = bl = string != null && !HelpBrowserUtils.isWebAddress(string);
        if (bl && !(file = new File(string)).isDirectory()) {
            file = file.getParentFile();
        }
        return file;
    }

    private void addHandlersForInstalledDoc(DocConfig<FileUrl> docConfig, HtmlPanel htmlPanel) {
        htmlPanel.addPageChangedListener((PageChangedListener)new DocSearchPageChangedListener((HtmlComponent)htmlPanel, docConfig));
        htmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)htmlPanel, docConfig));
        htmlPanel.addRequestHandler((RequestHandler)new InstalledLinkClickedHandler());
    }

    private JPanel createPanel(HtmlPanel htmlPanel, boolean bl) {
        HelpBrowserFindHandler helpBrowserFindHandler = new HelpBrowserFindHandler(this);
        BasicHtmlActions basicHtmlActions = HelpBrowserComponent.createHelpBrowserActions((HtmlComponent)htmlPanel, helpBrowserFindHandler);
        htmlPanel.setActions((HtmlActions)basicHtmlActions);
        HelpBrowserToolBar helpBrowserToolBar = bl ? HelpBrowserComponent.createToolBar(basicHtmlActions) : null;
        return HelpBrowserComponent.createPanel(helpBrowserToolBar, (HtmlComponent)htmlPanel);
    }

    private static BasicHtmlActions createHelpBrowserActions(HtmlComponent htmlComponent, FindInPageHandler findInPageHandler) {
        BasicHtmlActions basicHtmlActions = new BasicHtmlActions(htmlComponent, (BasicHtmlActions.BasicHtmlActionLabels)new HelpBrowserActionLabels());
        basicHtmlActions.setViewSourceHandler((BasicHtmlActions.ViewSourceHandler)new DefaultViewSourceHandler());
        if (findInPageHandler != null) {
            basicHtmlActions.setFindInPageHandler(findInPageHandler);
        }
        return basicHtmlActions;
    }

    private static HelpBrowserToolBar createToolBar(BasicHtmlActions basicHtmlActions) {
        return new HelpBrowserToolBar((HtmlActions)basicHtmlActions, new HelpBrowserComponentHelper());
    }

    private static JPanel createPanel(HelpBrowserToolBar helpBrowserToolBar, HtmlComponent htmlComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setName("HelpBrowserPanel");
        jPanel.getAccessibleContext().setAccessibleName("HelpBrowserPanel");
        jPanel.setLayout(new BorderLayout());
        if (helpBrowserToolBar != null) {
            jPanel.add((Component)helpBrowserToolBar.getComponent(), "North");
        }
        jPanel.add(htmlComponent.getComponent(), "Center");
        return jPanel;
    }

    public Component getComponent() {
        return this.getPanel();
    }

    JPanel getPanel() {
        return this.fPanel;
    }

    public HtmlComponent getHtmlComponent() {
        return this.fHtmlComponent;
    }

    public void setCurrentLocation(String string) {
        if (string == null) {
            return;
        }
        try {
            Url url = Url.parse((String)string);
            this.setCurrentLocation(url);
        }
        catch (MalformedURLException malformedURLException) {
            this.fHtmlComponent.setCurrentLocation(string);
        }
    }

    public void setCurrentLocation(Url url) {
        Url url2 = this.getNavigationUrl(url);
        if (url2 != null) {
            this.loadNavigationUrl(url2);
        }
    }

    private Url getNavigationUrl(Url url) {
        if (url == null || this.fDocConfig == null) {
            return url;
        }
        return this.fRuleHandler.applyRules((UrlBuilder<? extends Url>)url.toUrlBuilder(), this.fDocConfig.getDocRoot().getDocUrlType(url));
    }

    private void loadNavigationUrl(Url url) {
        this.fHtmlComponent.setCurrentLocation(url);
    }

    public String getCurrentLocation() {
        return this.getUserVisibleUrl(this.fHtmlComponent.getCurrentLocation());
    }

    private String getUserVisibleUrl(String string) {
        try {
            Url url = Url.parse((String)string);
            Url url2 = this.getUserVisibleUrl(url);
            if (url2 != null) {
                return url2.toUrlBuilder().toString();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return "";
    }

    private Url getUserVisibleUrl(Url url) {
        if (url == null || this.fDocConfig == null) {
            return url;
        }
        return this.fRuleHandler.removeRules((UrlBuilder<? extends Url>)url.toUrlBuilder(), this.fDocConfig.getDocRoot().getDocUrlType(url));
    }

    public void setHtmlText(String string) {
        if (string != null) {
            this.fHtmlComponent.setHtmlText(string);
        }
    }

    public String getHtmlText() {
        return this.fHtmlComponent.getHtmlText();
    }

    public void dispose() {
        this.fHtmlComponent.dispose();
    }

    void addFindPanel(final FindInPageHandler findInPageHandler) {
        if (this.fFindPanel == null) {
            this.fFindPanel = new FindPanel(this.getHtmlComponent(), findInPageHandler);
            this.getPanel().add(this.fFindPanel.getComponent(), "South");
            this.getPanel().revalidate();
            this.getPanel().repaint();
            this.addHtmlPanelKeyBinding(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    findInPageHandler.closeFindInPage();
                }
            }, "helpbrowser.close_find");
        }
        this.fFindPanel.getComponent().requestFocusInWindow();
        this.fFindPanel.requestFocusInTextField();
    }

    void removeFindPanel() {
        this.getPanel().remove(this.fFindPanel.getComponent());
        this.fFindPanel = null;
        this.removeHtmlPanelKeyBinding(KeyStroke.getKeyStroke(27, 0));
        this.getPanel().revalidate();
        this.getPanel().repaint();
    }

    private void setupKeyBindings() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(70, 128);
        this.addHtmlPanelKeyBinding(keyStroke, StandardHtmlActionId.FIND);
    }

    private void addHtmlPanelKeyBinding(KeyStroke keyStroke, StandardHtmlActionId standardHtmlActionId) {
        String string = "helpbrowser.htmlAction." + standardHtmlActionId.toString();
        HtmlComponentActionWrapper htmlComponentActionWrapper = new HtmlComponentActionWrapper(standardHtmlActionId);
        this.addHtmlPanelKeyBinding(keyStroke, htmlComponentActionWrapper, string);
    }

    private void addHtmlPanelKeyBinding(KeyStroke keyStroke, Action action, Object object) {
        InputMap inputMap = this.getPanel().getInputMap(1);
        inputMap.put(keyStroke, object);
        this.getPanel().getActionMap().put(object, action);
    }

    private void removeHtmlPanelKeyBinding(KeyStroke keyStroke) {
        InputMap inputMap = this.getPanel().getInputMap(1);
        Object object = inputMap.get(keyStroke);
        inputMap.remove(keyStroke);
        this.getPanel().getActionMap().remove(object);
    }

    public void displayCsh(String string, String string2) {
        Url url = this.getUrlForProductTopic(string, string2);
        if (url != null) {
            url = HelpBrowserComponent.addCshQueryString(url);
            this.setCurrentLocation(url);
        }
    }

    public void displayHelp(String string, String string2) {
        Url url = this.getUrlForProductTopic(string, string2);
        if (url != null) {
            this.setCurrentLocation(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Url getUrlForProductTopic(String string, String string2) {
        try (SearchEngineCshRetriever searchEngineCshRetriever = null;){
            if (this.fDocConfig != null) {
                searchEngineCshRetriever = new SearchEngineCshRetriever(this.fDocConfig.getSearchConfig(), this.fDocConfig.getDocumentationSet());
                CshResult cshResult = searchEngineCshRetriever.findProductTopic(string, string2);
                FileUrl fileUrl = this.fDocConfig.getDocRoot().buildDocSetItemUrl((DocSetItem)cshResult.getProduct(), cshResult.getRelativePath());
                return fileUrl;
            }
            Url url = null;
            return url;
        }
    }

    private static Url addCshQueryString(Url url) {
        UrlBuilder urlBuilder = url.toUrlBuilder();
        urlBuilder.setParameter(F1_PARAM_NAME, new String[]{F1_PARAM_VALUE});
        return urlBuilder.toUrl();
    }

    public void displayHelp() {
        this.displayHelp(this.fHelpDir);
    }

    private void displayHelp(String string) {
        Url url = HelpBrowserComponent.getUrlForHelpPage(string);
        if (url != null) {
            this.setCurrentLocation(url);
        }
    }

    private static Url getUrlForHelpPage(String string) {
        try {
            Url url = Url.parse((String)string);
            url = (Url)new HelpPageUrlBuilder().transformUrl(url);
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private class InstalledLinkClickedHandler
    extends HelpLinkClickedHandler {
        private InstalledLinkClickedHandler() {
        }

        @Override
        protected boolean handleLinkClickRequest(BrowserRequest browserRequest) {
            return this.handleLinkClicked(browserRequest.getUrl());
        }

        private boolean handleLinkClicked(Url url) {
            Url url2 = HelpBrowserComponent.this.getNavigationUrl(url);
            if (url2 != null && !url2.equals((Object)url)) {
                HelpBrowserComponent.this.loadNavigationUrl(url2);
                return true;
            }
            return false;
        }
    }

    private static class HelpPageUrlBuilder
    extends UrlTransformer<Url> {
        private HelpPageUrlBuilder() {
        }

        protected Url transformWebUrl(WebUrl webUrl) {
            return webUrl;
        }

        protected Url transformFileUrl(FileUrl fileUrl) {
            File file = fileUrl.getFile();
            if (file.exists() && file.isDirectory()) {
                return fileUrl.toUrlBuilder().append(new String[]{"index.html"}).toUrl();
            }
            return fileUrl;
        }

        protected Url transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl;
        }
    }

    private class HtmlComponentActionWrapper
    extends AbstractAction {
        private final StandardHtmlActionId iActionId;

        private HtmlComponentActionWrapper(StandardHtmlActionId standardHtmlActionId) {
            this.iActionId = standardHtmlActionId;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = (Action)HelpBrowserComponent.this.getHtmlComponent().getActions().getBasicActions().get(this.iActionId);
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    private static class HelpBrowserActionLabels
    implements BasicHtmlActions.BasicHtmlActionLabels {
        private HelpBrowserActionLabels() {
        }

        public String getLabel(StandardHtmlActionId standardHtmlActionId) {
            String string = HelpBrowserActionLabels.getResourceBundleKey(standardHtmlActionId);
            return string == null ? "" : HelpBrowserUtils.getString(string);
        }

        private static String getResourceBundleKey(StandardHtmlActionId standardHtmlActionId) {
            switch (standardHtmlActionId) {
                case GO_BACK: {
                    return "helpbrowser.toolbar.button.back.alttext";
                }
                case GO_FORWARD: {
                    return "helpbrowser.toolbar.button.forward.alttext";
                }
                case RELOAD: {
                    return "helpbrowser.toolbar.button.refresh.alttext";
                }
                case HOME: {
                    return "helpbrowser.toolbar.button.home.alttext";
                }
                case COPY: {
                    return "helpbrowser.toolbar.button.copy.alttext";
                }
                case PRINT: {
                    return "helpbrowser.toolbar.button.print.alttext";
                }
                case FIND: {
                    return "helpbrowser.toolbar.button.find.alttext";
                }
                case VIEW_SOURCE: {
                    return "helpbrowser.toolbar.button.pagesource.alttext";
                }
                case SAVE_AS: {
                    return "helpbrowser.toolbar.button.saveas.alttext";
                }
            }
            return null;
        }
    }
}

