/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;

public class LanguageDocUrlRule
implements DocUrlNavigationRule {
    private static final String WEB_LANGUAGE_PARAM_NAME = "doclanguage";
    private static final String FILE_LANGUAGE_PARAM_NAME = "lang";
    private final DocLanguage fLanguage;

    public LanguageDocUrlRule(DocLanguage docLanguage) {
        this.fLanguage = docLanguage;
    }

    @Override
    public <T extends Url> void apply(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
        if (this.fLanguage != null) {
            switch (urlBuilder.getType()) {
                case FILE: {
                    return;
                }
                case WEB: {
                    String string = DocRoot.getLanguageParameter(this.fLanguage);
                    if (string != null) {
                        urlBuilder.setParameter(WEB_LANGUAGE_PARAM_NAME, new String[]{string});
                    }
                    return;
                }
            }
        }
    }

    @Override
    public <T extends Url> void remove(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
        if (this.fLanguage != null) {
            switch (urlBuilder.getType()) {
                case FILE: {
                    urlBuilder.removeParameter(FILE_LANGUAGE_PARAM_NAME);
                    return;
                }
                case WEB: {
                    urlBuilder.removeParameter(WEB_LANGUAGE_PARAM_NAME);
                    return;
                }
            }
        }
    }
}

