/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.HelpPathBuilder;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.WebHelpPathBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.text.MessageFormat;

class BreadCrumbJsonBuilder {
    private static final String INDEX_FILE = HelpBrowserUtils.getString("helpbrowser.index.file");
    private static final String DOC_CENTER_FILE = HelpBrowserUtils.getString("helpbrowser.doccenter.file");
    private final DocumentationSet fDocumentationSet;
    private final Iterable<ResultCategory> fBreadCrumbs;
    private final HelpLocation fHelpLocation;
    private final String fDisplayName;

    BreadCrumbJsonBuilder(DocumentationSet documentationSet, Iterable<ResultCategory> iterable, HelpLocation helpLocation, String string) {
        this.fDocumentationSet = documentationSet;
        this.fBreadCrumbs = iterable;
        this.fHelpLocation = helpLocation;
        this.fDisplayName = string;
    }

    JsonEntity getJsonBreadcrumbs() {
        if (this.fBreadCrumbs == null) {
            return new JsonArray();
        }
        JsonArray jsonArray = new JsonArray();
        for (ResultCategory resultCategory : this.fBreadCrumbs) {
            JsonEntity jsonEntity = this.getJsonBreadcrumb(resultCategory);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getJsonBreadcrumb(ResultCategory resultCategory) {
        JsonArray jsonArray = new JsonArray();
        JsonEntity jsonEntity = this.getProductLandingPageBreadcrumb();
        jsonArray.addEntity(jsonEntity);
        for (ResultCategory resultCategory2 : resultCategory.getNodesRootFirst()) {
            jsonArray.addEntity(this.getJsonCrumb(resultCategory2));
        }
        return jsonArray;
    }

    private JsonEntity getBreadcrumb(String string) {
        return string.matches("^.*(R20\\d\\d[ab]).*$") ? this.getLandingPageBreadcrumb(string) : this.getProductBreadcrumb(string);
    }

    private JsonEntity getLandingPageBreadcrumb(String string) {
        return BreadCrumbJsonBuilder.getJsonCrumb(BreadCrumbJsonBuilder.getBreadcrumbLabel(string), DOC_CENTER_FILE, null);
    }

    private static String getBreadcrumbLabel(String string) {
        String string2 = HelpBrowserUtils.getString("helpbrowser.seachresults.breadcrumb.release.label");
        string2 = MessageFormat.format(string2, string);
        return string2;
    }

    private JsonEntity getProductBreadcrumb(String string) {
        DocProduct docProduct = this.fDocumentationSet.getProductByShortName(string);
        return BreadCrumbJsonBuilder.getProductBreadcrumb(docProduct.getDisplayName(), docProduct.getHelpLocation());
    }

    private JsonEntity getProductLandingPageBreadcrumb() {
        return BreadCrumbJsonBuilder.getProductBreadcrumb(this.fDisplayName, this.fHelpLocation);
    }

    private static JsonEntity getProductBreadcrumb(String string, HelpLocation helpLocation) {
        return BreadCrumbJsonBuilder.getJsonCrumb(string, INDEX_FILE, helpLocation);
    }

    private JsonEntity getJsonCrumb(ResultCategory resultCategory) {
        return BreadCrumbJsonBuilder.getJsonCrumb(resultCategory.getLabel(), resultCategory.getRelativePath(), this.fHelpLocation);
    }

    private static JsonEntity getJsonCrumb(String string, String string2, HelpLocation helpLocation) {
        String string3 = helpLocation == null ? "" : BreadCrumbJsonBuilder.getLocationPath(helpLocation);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("label", string);
        jsonObject.addStringProperty("relativepath", string2);
        jsonObject.addStringProperty("product", string3);
        jsonObject.addStringProperty("search", HelpBrowserUtils.getString("helpbrowser.seachresults.breadcrumb.search"));
        return jsonObject;
    }

    private static String getLocationPath(HelpLocation helpLocation) {
        return (String)helpLocation.buildHelpPath((Object)"", (HelpPathBuilder)new WebHelpPathBuilder(), new String[0]);
    }
}

