/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.search.index.AbstractIndexer;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DocSearchIndexDocumentIterator;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.HelpLocationRegistry;
import com.mathworks.html.Url;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchIndexException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DocCenterProductCrawler
extends AbstractIndexer {
    private final Collection<IndexerObserver<DocumentationSearchField>> fObservers = new ArrayList<IndexerObserver<DocumentationSearchField>>();

    public static void crawl(String string, DocConfig<? extends Url> docConfig, String string2, boolean bl, IndexerObserver<DocumentationSearchField> indexerObserver) {
        File file = new File(string);
        DocumentationSet documentationSet = docConfig.getDocumentationSet();
        HelpLocationRegistry helpLocationRegistry = new HelpLocationRegistry(documentationSet);
        DocSetItem docSetItem = helpLocationRegistry.getItemByHelpLocation(string2);
        DocCenterProductCrawler.crawl(file, docConfig, docSetItem, bl, indexerObserver);
    }

    public static void crawl(File file, DocConfig<? extends Url> docConfig, DocSetItem docSetItem, boolean bl, IndexerObserver<DocumentationSearchField> indexerObserver) {
        try {
            new DocCenterProductCrawler(file, docSetItem, bl, Arrays.asList(indexerObserver)).index();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public DocCenterProductCrawler(File file, DocSetItem docSetItem, boolean bl, Collection<IndexerObserver<DocumentationSearchField>> collection) {
        super(file, docSetItem, bl);
        this.fObservers.addAll(collection);
    }

    @Override
    protected Indexer getIndexer(IndexerConfig indexerConfig) throws IOException {
        return new MockIndexer();
    }

    @Override
    protected void afterIteratorCreated(DocSearchIndexDocumentIterator<DocumentationSearchField> docSearchIndexDocumentIterator) {
        for (IndexerObserver<DocumentationSearchField> indexerObserver : this.fObservers) {
            docSearchIndexDocumentIterator.addObserver(indexerObserver);
        }
    }

    private static class MockIndexer
    implements Indexer {
        private MockIndexer() {
        }

        public void openIndex() throws SearchIndexException {
        }

        public void addDocument(IndexDocument<? extends SearchField> indexDocument) throws IOException {
        }

        public void closeIndex() throws IOException {
        }
    }
}

