/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.help.helpui.DocSetItemProperties;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.search.index.AbstractIndexer;
import com.mathworks.help.helpui.search.index.LoggingIndexObserver;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.RelativeHelpLocation;
import com.mathworks.helpsearch.index.DocSearchIndexDocumentIterator;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.IndexerObserver;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocSupportPackage;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.SimpleDocProduct;
import com.mathworks.helpsearch.product.SimpleDocumentationSet;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchLanguage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class DocCenterProductIndexer
extends AbstractIndexer {
    public static void main(String[] stringArray) throws IOException {
        Map<String, String> map = DocCenterProductIndexer.parseInputs(stringArray);
        String string = map.get("docroot");
        String string2 = map.get("helploc");
        String string3 = map.get("webdoc");
        boolean bl = DocCenterProductIndexer.resolveBooleanInput(string3);
        File file = new File(string);
        String string4 = DocCenterProductIndexer.validateHelpLocation(file, string2);
        DocCenterProductIndexer.validateRequiredFields(string4, file);
        DocSetItemProperties docSetItemProperties = new DocSetItemProperties(file, string4);
        String string5 = map.get("language");
        DocLanguage docLanguage = DocCenterProductIndexer.resolveDocLanguage(string5);
        DocSetItem docSetItem = DocCenterProductIndexer.buildDocSetItem(docSetItemProperties, string4, docLanguage);
        DocCenterProductIndexer docCenterProductIndexer = new DocCenterProductIndexer(file, docSetItem, bl);
        docCenterProductIndexer.index();
    }

    public static DocLanguage resolveDocLanguage(String string) {
        Object object;
        if (string == null || string.trim().isEmpty()) {
            return DocLanguage.getDefault();
        }
        try {
            object = DocLanguage.valueOf((String)string.toUpperCase(Locale.ENGLISH));
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = DocCenterProductIndexer.toLocale(string);
        if (object == null) {
            return DocLanguage.getDefault();
        }
        return HelpBrowserUtils.getDocLanguageForLocale((Locale)object);
    }

    private static boolean resolveBooleanInput(String string) {
        if (string != null) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("true", "t", "1", "yes", "y"));
            return hashSet.contains(string.trim().toLowerCase(Locale.ENGLISH));
        }
        return false;
    }

    private static Locale toLocale(String string) {
        String[] stringArray = string.split("_");
        try {
            String string2 = stringArray[0].toLowerCase(Locale.ENGLISH);
            if (stringArray.length > 1) {
                String string3 = stringArray[1].toUpperCase(Locale.ENGLISH);
                return new Locale(string2, string3);
            }
            return new Locale(string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DocSetItem buildDocSetItem(DocSetItemProperties docSetItemProperties, String string, DocLanguage docLanguage) {
        SimpleDocumentationSet simpleDocumentationSet = new SimpleDocumentationSet(ContentFormat.DOC_CENTER_DOC, docLanguage);
        RelativeHelpLocation relativeHelpLocation = new RelativeHelpLocation(string);
        String string2 = docSetItemProperties.getShortName();
        String string3 = docSetItemProperties.getBaseProductShortName();
        if (string3.isEmpty()) {
            return new SimpleDocProduct((DocumentationSet)simpleDocumentationSet, string2, string2, (HelpLocation)relativeHelpLocation);
        }
        SimpleDocProduct simpleDocProduct = new SimpleDocProduct((DocumentationSet)simpleDocumentationSet, string3, string3, (HelpLocation)null);
        String string4 = docSetItemProperties.getDisplayName();
        String string5 = docSetItemProperties.getLegalName();
        DocSupportPackage docSupportPackage = new DocSupportPackage((DocumentationSet)simpleDocumentationSet, string2, string4, string5, (HelpLocation)relativeHelpLocation, (DocProduct)simpleDocProduct);
        simpleDocProduct.addDocAddOn((DocAddOn)docSupportPackage);
        return docSupportPackage;
    }

    private static Map<String, String> parseInputs(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length != 2) continue;
            String string2 = stringArray2[0];
            if (string2.startsWith("-")) {
                string2 = string2.substring(1);
            }
            hashMap.put(string2.toLowerCase(Locale.ENGLISH), stringArray2[1]);
        }
        return hashMap;
    }

    private static void validateRequiredFields(String string, File file) {
        if (string == null || file == null || !file.exists()) {
            StringBuilder stringBuilder = new StringBuilder("Usage:\n");
            stringBuilder.append("\tjava com.mathworks.help.helpui.search.index.DocCenterProductIndexer docroot=<docroot> helploc=<helploc> [language=<language>] [webdoc=<boolean>]\n");
            stringBuilder.append("\tThe docroot argument must be a valid directory, and the help location must be a relative path to a directory under docroot.\n");
            stringBuilder.append("\tThe help location directory should contain a doccenter.properties file.\n");
            stringBuilder.append("\tExamples of valid language arguments include ENGLISH, JAPANESE, EN, JA, en, ja, en_US, ja_JP, etc.");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    private static String validateHelpLocation(File file, String string) {
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " appears to be an invalid doc root");
        }
        File file2 = new File(string);
        if (!file2.exists() || !file2.isDirectory()) {
            file2 = new File(file, string);
        }
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IllegalArgumentException(string + " appears to be an invalid help location");
        }
        return DocCenterProductIndexer.getRelativeHelpLoc(file, file2);
    }

    private static String getRelativeHelpLoc(File file, File file2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, file3.getName());
        }
        return stringBuilder.toString();
    }

    public DocCenterProductIndexer(File file, DocSetItem docSetItem, boolean bl) {
        super(file, docSetItem, bl);
    }

    @Override
    protected Indexer getIndexer(IndexerConfig indexerConfig) throws IOException {
        SearchLanguage searchLanguage = this.getProduct().getDocSet().getLanguage().getSearchLanguage();
        return IndexUtils.createDocCenterIndexer((SearchLanguage)searchLanguage, (IndexerConfig)indexerConfig, (boolean)true);
    }

    @Override
    protected void afterIteratorCreated(DocSearchIndexDocumentIterator<DocumentationSearchField> docSearchIndexDocumentIterator) {
        docSearchIndexDocumentIterator.addObserver((IndexerObserver)new LoggingIndexObserver());
    }
}

