/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.suggestions.FullSuggestionRequest;
import com.mathworks.help.helpui.suggestions.PageSuggestionRequest;
import com.mathworks.help.helpui.suggestions.SuggestionRequest;
import com.mathworks.help.helpui.suggestions.WordSuggestionRequest;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.product.DocCenterItemResolver;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.SearchEngineSuggestionProvider;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchField;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocSuggestionProtocolHandler
extends CustomProtocolRequestHandler {
    private static final int INITIAL_SUGGESTIONS = 5;
    private static final Map<String, InformationType> TYPES_BY_QUERY_STRING;
    private static final Pattern SUGGESTION_COMMAND_PATTERN;
    private final HtmlComponent fHtmlComponent;
    private final DocConfig<FileUrl> fDocConfig;
    private boolean fWaitForCompletion = false;

    public DocSuggestionProtocolHandler(HtmlComponent htmlComponent, DocConfig<FileUrl> docConfig) {
        super("docsuggestion", new String[0]);
        this.fHtmlComponent = htmlComponent;
        this.fDocConfig = docConfig;
    }

    public void setWaitForCompletion(boolean bl) {
        this.fWaitForCompletion = bl;
    }

    protected void handleMatchedRequest(BrowserRequest browserRequest, final CustomProtocolUrl customProtocolUrl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SuggestionRequest suggestionRequest = DocSuggestionProtocolHandler.this.getRequest(customProtocolUrl.getCommand());
                    if (suggestionRequest != null) {
                        DocSuggestionProtocolHandler.this.fHtmlComponent.executeScript(suggestionRequest.getJavaScriptCallback());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        if (this.fWaitForCompletion) {
            try {
                thread.join(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SuggestionRequest getRequest(String string) throws IOException {
        Matcher matcher = SUGGESTION_COMMAND_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = URLDecoder.decode(matcher.group(2), "UTF8");
            return this.getRequest(this.getSuggestionProvider(), string2, string3);
        }
        return null;
    }

    private SuggestionRequest getRequest(DocumentationSuggestionProvider documentationSuggestionProvider, String string, String string2) throws IOException {
        if (string != null) {
            InformationType informationType = TYPES_BY_QUERY_STRING.get(string = string.substring(0, string.length() - 1));
            if (informationType != null) {
                return new PageSuggestionRequest(documentationSuggestionProvider, informationType, string2, 5, this.fDocConfig.getDocRoot());
            }
            if (string.equals("word")) {
                return new WordSuggestionRequest(documentationSuggestionProvider, string2, 5);
            }
        }
        return new FullSuggestionRequest(this.fDocConfig.getDocRoot(), documentationSuggestionProvider, this.getTypesToSuggest(), string2, 5);
    }

    public DocumentationSuggestionProvider getSuggestionProvider() throws IOException {
        SearchConfig searchConfig = this.fDocConfig.getSearchConfig();
        DocumentationSet documentationSet = this.fDocConfig.getDocumentationSet();
        ProductFilter productFilter = this.fDocConfig.getProductFilter();
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)searchConfig, (DocumentationSet)documentationSet);
        DocCenterItemResolver docCenterItemResolver = new DocCenterItemResolver(documentationSet);
        return new SearchEngineSuggestionProvider(searchEngine, (SearchField)DocumentationSearchField.BODY, (DocSetItemResolver)docCenterItemResolver, (SearchExpressionFilter)productFilter);
    }

    public Collection<InformationType> getTypesToSuggest() {
        DocumentationSet documentationSet = this.fDocConfig.getDocumentationSet();
        switch (documentationSet.getFormat()) {
            case DOC_CENTER_DOC: {
                return EnumSet.of(InformationType.FUNCTIONS, InformationType.BLOCKS, InformationType.SYSTEM_OBJECTS, InformationType.CATEGORY_PAGE);
            }
        }
        return EnumSet.of(InformationType.FUNCTIONS, InformationType.BLOCKS);
    }

    static {
        SUGGESTION_COMMAND_PATTERN = Pattern.compile("^(\\w+\\|)?(.*)");
        TYPES_BY_QUERY_STRING = new HashMap<String, InformationType>();
        for (InformationType informationType : InformationType.values()) {
            TYPES_BY_QUERY_STRING.put(informationType.getFacetId(), informationType);
        }
    }
}

