/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.search.SearchHighlight;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuggestionUtils {
    private static final String TITLE_SUMMARY_SEPARATOR = " - ";
    private static final int TITLE_PLUS_SUMMARY_CHARS = 83 - " - ".length();

    public static JsonArray createWordSuggestionArray(Iterable<SearchHighlight> iterable) {
        JsonArray jsonArray = new JsonArray();
        for (SearchHighlight searchHighlight : iterable) {
            jsonArray.addString(searchHighlight.getOriginalText());
        }
        return jsonArray;
    }

    public static JsonArray createPageSuggestionArray(DocRoot<FileUrl> docRoot, InformationType informationType, Iterable<PageSuggestion> iterable) {
        JsonArray jsonArray = new JsonArray();
        String string = informationType.getFacetId();
        for (PageSuggestion pageSuggestion : iterable) {
            jsonArray.addEntity(SuggestionUtils.getSuggestionJson(docRoot, string, pageSuggestion));
        }
        return jsonArray;
    }

    public static JsonObject getSuggestionJson(DocRoot<FileUrl> docRoot, String string, PageSuggestion pageSuggestion) {
        JsonObject jsonObject = new JsonObject();
        String string2 = pageSuggestion.getTitle();
        jsonObject.addStringProperty("title", string2);
        String string3 = SuggestionUtils.trimSummary(string2, pageSuggestion.getSummary(), TITLE_PLUS_SUMMARY_CHARS);
        jsonObject.addStringProperty("summary", string3 != null && string3.length() > 0 ? TITLE_SUMMARY_SEPARATOR + string3 : "");
        jsonObject.addStringProperty("product", pageSuggestion.getDocSetItem().getDisplayName());
        FileUrl fileUrl = docRoot.buildDocSetItemUrl(pageSuggestion.getDocSetItem(), pageSuggestion.getPath());
        String string4 = fileUrl.toString();
        string4 = SuggestionUtils.correctUrl(string4);
        jsonObject.addStringProperty("path", string4);
        jsonObject.addStringProperty("type", string);
        return jsonObject;
    }

    private static String correctUrl(String string) {
        try {
            return Url.parse((String)string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static String trimSummary(String string, String string2, int n) {
        if (string2 != null && string2.length() > 0) {
            int n2 = n - string.length();
            return SuggestionUtils.trimStringToWordBreak(string2, n2, "...");
        }
        return string2;
    }

    public static String trimStringToWordBreak(String string, int n, String string2) {
        if (string.length() > n) {
            Pattern pattern;
            Matcher matcher;
            int n2 = n - string2.length() - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((matcher = (pattern = Pattern.compile("^.{0," + String.valueOf(n2) + "}\\w\\b")).matcher(string)).find()) {
                return matcher.group() + string2;
            }
            return "";
        }
        return string;
    }

    public static String[] getSearchWords(String string) {
        return string.split("\\W+");
    }
}

