/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg12.SVG12DOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    public static final Object LOCK = new Object();
    public static final String KEY_PUBLIC_IDS = "publicIds";
    public static final String KEY_SKIPPABLE_PUBLIC_IDS = "skippablePublicIds";
    public static final String KEY_SKIP_DTD = "skipDTD";
    public static final String KEY_SYSTEM_ID = "systemId.";
    protected static final String DTDIDS = "org.apache.batik.dom.svg.resources.dtdids";
    protected static final String HTTP_CHARSET = "charset";
    protected static String dtdids;
    protected static String skippable_dtdids;
    protected static String skip_dtd;
    protected static Properties dtdProps;

    public SAXSVGDocumentFactory(String string) {
        super(SVGDOMImplementation.getDOMImplementation(), string);
    }

    public SAXSVGDocumentFactory(String string, boolean bl) {
        super(SVGDOMImplementation.getDOMImplementation(), string, bl);
    }

    @Override
    public SVGDocument createSVGDocument(String string) throws IOException {
        return (SVGDocument)this.createDocument(string);
    }

    @Override
    public SVGDocument createSVGDocument(String string, InputStream inputStream) throws IOException {
        return (SVGDocument)this.createDocument(string, inputStream);
    }

    @Override
    public SVGDocument createSVGDocument(String string, Reader reader) throws IOException {
        return (SVGDocument)this.createDocument(string, reader);
    }

    public Document createDocument(String string) throws IOException {
        int n;
        int n2;
        ParsedURL parsedURL = new ParsedURL(string);
        InputStream inputStream = parsedURL.openStream(MimeTypeConstants.MIME_TYPES_SVG_LIST.iterator());
        string = parsedURL.getPostConnectionURL();
        InputSource inputSource = new InputSource(inputStream);
        String string2 = parsedURL.getContentType();
        int n3 = -1;
        if (string2 != null) {
            string2 = string2.toLowerCase();
            n3 = string2.indexOf(HTTP_CHARSET);
        }
        String string3 = null;
        if (n3 != -1 && (n2 = string2.indexOf(61, n = n3 + HTTP_CHARSET.length())) != -1) {
            int n4 = string2.indexOf(44, ++n2);
            int n5 = string2.indexOf(59, n2);
            if (n5 != -1 && (n5 < n4 || n4 == -1)) {
                n4 = n5;
            }
            string3 = n4 != -1 ? string2.substring(n2, n4) : string2.substring(n2);
            string3 = string3.trim();
            inputSource.setEncoding(string3);
        }
        inputSource.setSystemId(string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource));
        sVGOMDocument.setParsedURL(new ParsedURL(string));
        sVGOMDocument.setDocumentInputEncoding(string3);
        sVGOMDocument.setXmlStandalone(this.isStandalone);
        sVGOMDocument.setXmlVersion(this.xmlVersion);
        return sVGOMDocument;
    }

    public Document createDocument(String string, InputStream inputStream) throws IOException {
        Document document;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        try {
            document = super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                ((SVGOMDocument)((Object)document)).setParsedURL(new ParsedURL(string));
            }
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.setDocumentURI(string);
            abstractDocument.setXmlStandalone(this.isStandalone);
            abstractDocument.setXmlVersion(this.xmlVersion);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return document;
    }

    public Document createDocument(String string, Reader reader) throws IOException {
        Document document;
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        try {
            document = super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource);
            if (string != null) {
                ((SVGOMDocument)((Object)document)).setParsedURL(new ParsedURL(string));
            }
            AbstractDocument abstractDocument = (AbstractDocument)document;
            abstractDocument.setDocumentURI(string);
            abstractDocument.setXmlStandalone(this.isStandalone);
            abstractDocument.setXmlVersion(this.xmlVersion);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return document;
    }

    public Document createDocument(String string, String string2, String string3) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3);
    }

    public Document createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, inputStream);
    }

    public Document createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new RuntimeException("Bad root element");
        }
        return this.createDocument(string3, reader);
    }

    public DOMImplementation getDOMImplementation(String string) {
        if (string == null || string.length() == 0 || string.equals("1.0") || string.equals("1.1")) {
            return SVGDOMImplementation.getDOMImplementation();
        }
        if (string.equals("1.2")) {
            return SVG12DOMImplementation.getDOMImplementation();
        }
        throw new RuntimeException("Unsupport SVG version '" + string + "'");
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            Object object = LOCK;
            synchronized (object) {
                if (dtdProps == null) {
                    dtdProps = new Properties();
                    try {
                        Class<SAXSVGDocumentFactory> clazz = SAXSVGDocumentFactory.class;
                        InputStream inputStream = clazz.getResourceAsStream("resources/dtdids.properties");
                        dtdProps.load(inputStream);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                }
                if (dtdids == null) {
                    dtdids = dtdProps.getProperty(KEY_PUBLIC_IDS);
                }
                if (skippable_dtdids == null) {
                    skippable_dtdids = dtdProps.getProperty(KEY_SKIPPABLE_PUBLIC_IDS);
                }
                if (skip_dtd == null) {
                    skip_dtd = dtdProps.getProperty(KEY_SKIP_DTD);
                }
            }
            if (string == null) {
                return null;
            }
            if (!this.isValidating && skippable_dtdids.indexOf(string) != -1) {
                return new InputSource(new StringReader(skip_dtd));
            }
            if (dtdids.indexOf(string) != -1 && (object = dtdProps.getProperty(KEY_SYSTEM_ID + string.replace(' ', '_'))) != null && !"".equals(object)) {
                return new InputSource(this.getClass().getResource((String)object).toString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            throw new SAXException(missingResourceException);
        }
        return null;
    }
}

