/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.fatalexit;

import com.mathworks.fatalexit.ComponentName;
import com.mathworks.fatalexit.ReportSegvIntf;
import com.mathworks.fatalexit.ResourceBundleIntf;
import com.mathworks.mlwebservices.segv.V1.ws.ReportSegvListener;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SendReportPanel {
    private static final String INTERNET_E_MAIL_PREF = "InternetE_mail";
    private static final Object[] OPTIONS = new Object[0];
    private final JTextField emailAddressField;
    private final JTextArea reproStepsArea;
    private final JOptionPane sendPane;
    private final ResourceBundleIntf bundle;
    private final String filename;
    private final String serviceUrl;
    private final Component parent;
    private final ReportSegvIntf segv;
    private final ReportSegvListener listener;

    public SendReportPanel(Component component, ReportSegvListener reportSegvListener, ResourceBundleIntf resourceBundleIntf, ReportSegvIntf reportSegvIntf, String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.bundle = resourceBundleIntf;
        this.filename = string;
        this.serviceUrl = string2;
        this.parent = component;
        this.segv = reportSegvIntf;
        this.listener = reportSegvListener;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setPreferredSize(new Dimension(600, 400));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addMultilineLabelToPanel(jPanel, gridBagConstraints, this.bundle.getString("prompt.EmailAddress"), ComponentName.PROMPT_EMAIL_ADDRESS);
        String string3 = Prefs.getStringPref((String)INTERNET_E_MAIL_PREF, (String)"");
        gridBagConstraints.gridy = 1;
        this.emailAddressField = new JTextField(string3);
        this.emailAddressField.setName(ComponentName.EMAIL_ADDRESS_TEXT_FIELD.toString());
        jPanel.add((Component)this.emailAddressField, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.addMultilineLabelToPanel(jPanel, gridBagConstraints, this.bundle.getString("label.enterReproductionSteps"), ComponentName.REPRO_STEPS);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.reproStepsArea = new JTextArea();
        this.reproStepsArea.setName(ComponentName.REPRO_STEPS_TEXT_AREA.toString());
        jPanel.add((Component)new JScrollPane(this.reproStepsArea), gridBagConstraints);
        if (null == string3 || string3.length() == 0) {
            this.emailAddressField.requestFocusInWindow();
        } else {
            this.reproStepsArea.requestFocusInWindow();
        }
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.sendPane = new JOptionPane(jPanel, -1, 2, null, new Object[]{jButton, jButton2}, jButton);
        jButton2.setName(ComponentName.SEND_EMAIL_CANCEL.toString());
        jButton2.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendReportPanel.this.sendPane.setValue(2);
            }
        });
        jButton2.setText("Cancel");
        jButton.setName(ComponentName.SEND_EMAIL_OK.toString());
        jButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendReportPanel.this.sendPane.setValue(0);
            }
        });
        jButton.setText("OK");
    }

    public void show() {
        Object object;
        Integer n;
        do {
            object = this.sendPane.createDialog(this.parent, this.bundle.getString("label.EmailAddress"));
            ((Dialog)object).setVisible(true);
            n = (Integer)this.sendPane.getValue();
        } while (Integer.valueOf(0).equals(n) && !this.validateUserEmailAddress(this.getEmailAddress()));
        if (Integer.valueOf(0).equals(n)) {
            object = this.getEmailAddress();
            String string = this.getReproSteps();
            Prefs.setStringPref((String)INTERNET_E_MAIL_PREF, (String)object);
            this.segv.reportFile(this.listener, this.filename, (String)object, string, this.serviceUrl);
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            JOptionPane.showOptionDialog(this.parent, jProgressBar, this.bundle.getString("progressDialog.title"), -1, -1, null, OPTIONS, null);
        }
    }

    boolean validateUserEmailAddress(String string) {
        boolean bl = false;
        if (null == string || string.length() == 0) {
            JOptionPane.showMessageDialog(null, this.bundle.getString("error.EmptyEmailAddress"), "Empty Email Address", 0);
        } else {
            Pattern pattern = Pattern.compile(".+@.+\\.[a-z]+");
            bl = pattern.matcher(string).matches();
            if (!bl) {
                String string2 = MessageFormat.format(this.bundle.getString("error.InvalidEmailAddress"), string);
                JOptionPane.showMessageDialog(null, string2, "Invalid Email Address", 0);
            }
        }
        return bl;
    }

    String getEmailAddress() {
        return this.emailAddressField.getText();
    }

    String getReproSteps() {
        return this.reproStepsArea.getText();
    }

    void addMultilineLabelToPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, String string, ComponentName componentName) {
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
        mJMultilineLabel.setName(componentName.toString());
        mJMultilineLabel.setFont(mJMultilineLabel.getFont().deriveFont(0));
        jPanel.add((Component)mJMultilineLabel, gridBagConstraints);
    }

    public JOptionPane getSendPane() {
        return this.sendPane;
    }
}

