/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class JoinManager {
    private static final String COMPONENT_NAME = "net.jini.lookup.JoinManager";
    private static final Logger logger = Logger.getLogger("net.jini.lookup.JoinManager");
    private static final int MAX_N_TASKS = 15;
    private int taskSeqN = 0;
    private TaskManager taskMgr;
    private int maxNRetries = 6;
    private WakeupManager wakeupMgr;
    private ServiceItem serviceItem;
    private Entry[] lookupAttr = null;
    private ServiceIDListener callback;
    private final ArrayList joinSet = new ArrayList(1);
    private DiscoveryManagement discMgr = null;
    private DiscMgrListener discMgrListener = new DiscMgrListener();
    private boolean bCreateDiscMgr = false;
    private LeaseRenewalManager leaseRenewalMgr = null;
    private boolean bTerminated = false;
    private ProxyPreparer registrarPreparer;
    private ProxyPreparer registrationPreparer;
    private ProxyPreparer serviceLeasePreparer;

    public JoinManager(Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        try {
            this.createJoinManager(null, object, entryArray, serviceIDListener, leaseRenewalManager, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public JoinManager(Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager, Configuration configuration) throws IOException, ConfigurationException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(null, object, entryArray, serviceIDListener, leaseRenewalManager, configuration);
    }

    public JoinManager(Object object, Entry[] entryArray, ServiceID serviceID, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager) throws IOException {
        this.discMgr = discoveryManagement;
        try {
            this.createJoinManager(serviceID, object, entryArray, this.callback, leaseRenewalManager, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public JoinManager(Object object, Entry[] entryArray, ServiceID serviceID, DiscoveryManagement discoveryManagement, LeaseRenewalManager leaseRenewalManager, Configuration configuration) throws IOException, ConfigurationException {
        this.discMgr = discoveryManagement;
        this.createJoinManager(serviceID, object, entryArray, this.callback, leaseRenewalManager, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryManagement getDiscoveryManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.discMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaseRenewalManager getLeaseRenewalManager() {
        JoinManager joinManager = this;
        synchronized (joinManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        return this.leaseRenewalMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar[] getJoinSet() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            ArrayList<ServiceRegistrar> arrayList = new ArrayList<ServiceRegistrar>(this.joinSet.size());
            boolean bl = false;
            Iterator iterator = this.joinSet.iterator();
            while (iterator.hasNext()) {
                ProxyReg proxyReg = (ProxyReg)iterator.next();
                if (proxyReg.srvcRegistration == null) continue;
                arrayList.add(proxyReg.proxy);
            }
            return arrayList.toArray(new ServiceRegistrar[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getAttributes() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            return (Entry[])this.lookupAttr.clone();
        }
    }

    public void addAttributes(Entry[] entryArray) {
        this.addAttributes(entryArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Entry[] entryArray, boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.add(this.lookupAttr, entryArray, bl);
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new AddAttributesTask(proxyReg, entryArray));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Entry[] entryArray) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        this.testForNullElement(entryArray);
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = (Entry[])entryArray.clone();
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new SetAttributesTask(proxyReg, entryArray));
            }
        }
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) {
        this.modifyAttributes(entryArray, entryArray2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2, boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                throw new IllegalStateException("join manager was terminated");
            }
        }
        object = this.joinSet;
        synchronized (object) {
            this.lookupAttr = LookupAttributes.modify(this.lookupAttr, entryArray, entryArray2, bl);
            this.serviceItem.attributeSets = this.lookupAttr;
            for (int i = 0; i < this.joinSet.size(); ++i) {
                ProxyReg proxyReg = (ProxyReg)this.joinSet.get(i);
                proxyReg.addTask(new ModifyAttributesTask(proxyReg, entryArray, entryArray2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this;
        synchronized (object) {
            if (this.bTerminated) {
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.bCreateDiscMgr) {
                this.discMgr.terminate();
            }
        }
        this.terminateTaskMgr();
        object = null;
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            object = new ArrayList(this.joinSet.size());
            Iterator iterator = this.joinSet.iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(((ProxyReg)iterator.next()).serviceLease);
            }
            this.joinSet.clear();
        }
        if (object == null) {
            return;
        }
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            try {
                this.leaseRenewalMgr.cancel((Lease)((ArrayList)object).get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createJoinManager(ServiceID serviceID, Object object, Entry[] entryArray, ServiceIDListener serviceIDListener, LeaseRenewalManager leaseRenewalManager, Configuration configuration) throws IOException, ConfigurationException {
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("obj must be Serializable");
        }
        if (configuration == null) {
            throw new NullPointerException("config is null");
        }
        this.registrarPreparer = (ProxyPreparer)configuration.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.registrationPreparer = (ProxyPreparer)configuration.getEntry(COMPONENT_NAME, "registrationPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.serviceLeasePreparer = (ProxyPreparer)configuration.getEntry(COMPONENT_NAME, "serviceLeasePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.taskMgr = new TaskManager(15, 15000L, 1.0f);
        try {
            this.taskMgr = (TaskManager)configuration.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class, (Object)this.taskMgr);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        try {
            this.wakeupMgr = (WakeupManager)configuration.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class, (Object)this.wakeupMgr);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.maxNRetries = (Integer)configuration.getEntry(COMPONENT_NAME, "wakeupRetries", Integer.TYPE, (Object)new Integer(this.maxNRetries));
        if (entryArray == null) {
            this.lookupAttr = new Entry[0];
        } else {
            LookupAttributes.check(entryArray, false);
            this.lookupAttr = (Entry[])entryArray.clone();
        }
        this.serviceItem = new ServiceItem(serviceID, object, this.lookupAttr);
        this.leaseRenewalMgr = leaseRenewalManager;
        if (this.leaseRenewalMgr == null) {
            this.leaseRenewalMgr = new LeaseRenewalManager(configuration);
            try {
                this.leaseRenewalMgr = (LeaseRenewalManager)configuration.getEntry(COMPONENT_NAME, "leaseManager", LeaseRenewalManager.class, (Object)this.leaseRenewalMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this.callback = serviceIDListener;
        if (this.discMgr == null) {
            this.bCreateDiscMgr = true;
            this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null, configuration);
            try {
                this.discMgr = (DiscoveryManagement)configuration.getEntry(COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class, (Object)this.discMgr);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJoinSet(ProxyReg proxyReg) {
        if (proxyReg.proxy == null) {
            throw new IllegalArgumentException("bad proxy");
        }
        Lease lease = null;
        ArrayList arrayList = this.joinSet;
        synchronized (arrayList) {
            this.joinSet.remove(proxyReg);
            if (proxyReg.srvcRegistration != null) {
                lease = proxyReg.serviceLease;
            }
        }
        if (lease == null) {
            return;
        }
        try {
            this.leaseRenewalMgr.cancel(lease);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ProxyReg findReg(ServiceRegistrar serviceRegistrar) {
        Iterator iterator = this.joinSet.iterator();
        while (iterator.hasNext()) {
            ProxyReg proxyReg = (ProxyReg)iterator.next();
            if (!proxyReg.proxy.equals(serviceRegistrar)) continue;
            return proxyReg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTasks(ProxyReg proxyReg) {
        if (proxyReg == null) {
            return;
        }
        if (this.taskMgr == null) {
            return;
        }
        List list = proxyReg.taskList;
        synchronized (list) {
            if (proxyReg.proxyRegTask != null) {
                TaskManager taskManager = this.taskMgr;
                synchronized (taskManager) {
                    this.taskMgr.remove(proxyReg.proxyRegTask);
                }
                proxyReg.proxyRegTask.cancel();
                proxyReg.proxyRegTask = null;
            }
            proxyReg.taskList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateTaskMgr() {
        WakeupManager wakeupManager = this.wakeupMgr;
        synchronized (wakeupManager) {
            this.wakeupMgr.cancelAll();
            this.wakeupMgr.stop();
            TaskManager taskManager = this.taskMgr;
            synchronized (taskManager) {
                ArrayList arrayList = this.taskMgr.getPending();
                for (int i = 0; i < arrayList.size(); ++i) {
                    RetryTask retryTask = (RetryTask)arrayList.get(i);
                    retryTask.cancel();
                    this.taskMgr.remove(retryTask);
                }
                this.taskMgr.terminate();
                this.taskMgr = null;
            }
            this.wakeupMgr = null;
        }
    }

    private void testForNullElement(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new NullPointerException("input array contains at least one null element");
        }
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        private DiscMgrListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discovered(DiscoveryEvent discoveryEvent) {
            Object var2_2 = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                    try {
                        serviceRegistrarArray[i] = (ServiceRegistrar)JoinManager.this.registrarPreparer.prepareProxy((Object)serviceRegistrarArray[i]);
                        logger.log(Level.FINEST, "JoinManager - discovered lookup service proxy prepared: {0}", serviceRegistrarArray[i]);
                    }
                    catch (Exception exception) {
                        logger.log(Level.INFO, "failure preparing discovered ServiceRegistrar proxy", exception);
                        JoinManager.this.discMgr.discard(serviceRegistrarArray[i]);
                        continue;
                    }
                    if (serviceRegistrarArray[i].equals(((JoinManager)JoinManager.this).serviceItem.service)) continue;
                    ProxyReg proxyReg = new ProxyReg(serviceRegistrarArray[i]);
                    if (JoinManager.this.joinSet.contains(proxyReg)) continue;
                    JoinManager.this.joinSet.add(proxyReg);
                    proxyReg.addTask(new RegisterTask(proxyReg, (Entry[])JoinManager.this.lookupAttr.clone()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discarded(DiscoveryEvent discoveryEvent) {
            Object var2_2 = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
                for (int i = 0; i < serviceRegistrarArray.length; ++i) {
                    ProxyReg proxyReg = JoinManager.this.findReg(serviceRegistrarArray[i]);
                    if (proxyReg == null) continue;
                    JoinManager.this.removeTasks(proxyReg);
                    proxyReg.addTask(new DiscardProxyTask(proxyReg));
                }
            }
        }
    }

    private class ProxyReg {
        public ProxyRegTask proxyRegTask;
        public ServiceRegistrar proxy;
        public ServiceRegistration srvcRegistration = null;
        public Lease serviceLease = null;
        public List taskList = new ArrayList(1);
        private DiscLeaseListener dListener = new DiscLeaseListener();

        public ProxyReg(ServiceRegistrar serviceRegistrar) {
            if (serviceRegistrar == null) {
                throw new IllegalArgumentException("proxy can't be null");
            }
            this.proxy = serviceRegistrar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTask(JoinTask joinTask) {
            Object object = JoinManager.this;
            synchronized (object) {
                if (JoinManager.this.bTerminated) {
                    return;
                }
            }
            object = this.taskList;
            synchronized (object) {
                this.taskList.add(joinTask);
                if (this.proxyRegTask == null) {
                    this.proxyRegTask = new ProxyRegTask(this, JoinManager.this.taskSeqN++);
                    TaskManager taskManager = JoinManager.this.taskMgr;
                    synchronized (taskManager) {
                        JoinManager.this.taskMgr.add(this.proxyRegTask);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(Entry[] entryArray) throws Exception {
            if (this.proxy == null) {
                throw new RuntimeException("proxy is null");
            }
            ServiceItem serviceItem = null;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                this.srvcRegistration = null;
                serviceItem = new ServiceItem(((JoinManager)JoinManager.this).serviceItem.serviceID, ((JoinManager)JoinManager.this).serviceItem.service, entryArray);
            }
            arrayList = this.proxy.register(serviceItem, Long.MAX_VALUE);
            try {
                arrayList = (ServiceRegistration)JoinManager.this.registrationPreparer.prepareProxy((Object)arrayList);
                logger.finest("JoinManager - ServiceRegistration proxy prepared");
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "failure during preparation of ServiceRegistration proxy", exception);
                throw exception;
            }
            this.serviceLease = arrayList.getLease();
            try {
                this.serviceLease = (Lease)JoinManager.this.serviceLeasePreparer.prepareProxy((Object)this.serviceLease);
                logger.finest("JoinManager - service lease proxy prepared");
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "failure during preparation of service lease proxy", exception);
                throw exception;
            }
            JoinManager.this.leaseRenewalMgr.renewUntil(this.serviceLease, Long.MAX_VALUE, this.dListener);
            ArrayList arrayList2 = JoinManager.this.joinSet;
            synchronized (arrayList2) {
                this.srvcRegistration = arrayList;
            }
            arrayList2 = null;
            ServiceItem serviceItem2 = JoinManager.this.serviceItem;
            synchronized (serviceItem2) {
                if (((JoinManager)JoinManager.this).serviceItem.serviceID == null) {
                    ((JoinManager)JoinManager.this).serviceItem.serviceID = this.srvcRegistration.getServiceID();
                    arrayList2 = ((JoinManager)JoinManager.this).serviceItem.serviceID;
                }
            }
            if (arrayList2 != null && JoinManager.this.callback != null) {
                JoinManager.this.callback.serviceIDNotify((ServiceID)arrayList2);
            }
        }

        public void addAttributes(Entry[] entryArray) throws Exception {
            this.srvcRegistration.addAttributes(entryArray);
        }

        public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) throws Exception {
            this.srvcRegistration.modifyAttributes(entryArray, entryArray2);
        }

        public void setAttributes(Entry[] entryArray) throws Exception {
            this.srvcRegistration.setAttributes(entryArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fail(Throwable throwable) {
            ProxyReg proxyReg = this;
            synchronized (proxyReg) {
                if (JoinManager.this.bTerminated) {
                    return;
                }
                logger.log(Level.INFO, "JoinManager - failure", throwable);
                try {
                    JoinManager.this.discMgr.discard(this.proxy);
                }
                catch (IllegalStateException illegalStateException) {
                    logger.log(Level.FINEST, "JoinManager - cannot discard lookup, discovery manager already terminated", illegalStateException);
                }
            }
        }

        public boolean equals(Object object) {
            if (object instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)object).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        private class DiscLeaseListener
        implements LeaseListener {
            private DiscLeaseListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(LeaseRenewalEvent leaseRenewalEvent) {
                Throwable throwable = leaseRenewalEvent.getException();
                if (throwable == null || throwable instanceof UnknownLeaseException) {
                    ArrayList arrayList = JoinManager.this.joinSet;
                    synchronized (arrayList) {
                        JoinManager.this.removeTasks(ProxyReg.this);
                        ProxyReg.this.addTask(new LeaseExpireNotifyTask(ProxyReg.this, (Entry[])JoinManager.this.lookupAttr.clone()));
                    }
                } else {
                    ProxyReg.this.fail(throwable);
                }
            }
        }
    }

    private final class ModifyAttributesTask
    extends AddAttributesTask {
        private Entry[] attrSetTemplates;

        ModifyAttributesTask(ProxyReg proxyReg, Entry[] entryArray, Entry[] entryArray2) {
            super(proxyReg, entryArray2);
            this.attrSetTemplates = (Entry[])entryArray.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - ModifyAttributesTask started");
            proxyReg.modifyAttributes(this.attrSetTemplates, this.attrSets);
            logger.finest("JoinManager - ModifyAttributesTask completed");
        }
    }

    private final class SetAttributesTask
    extends AddAttributesTask {
        SetAttributesTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg, entryArray);
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - SetAttributesTask started");
            proxyReg.setAttributes(this.attrSets);
            logger.finest("JoinManager - SetAttributesTask completed");
        }
    }

    private class AddAttributesTask
    extends JoinTask {
        protected Entry[] attrSets;

        AddAttributesTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.attrSets = (Entry[])entryArray.clone();
        }

        protected void doAttributes(ProxyReg proxyReg) throws Exception {
            logger.finest("JoinManager - AddAttributesTask started");
            proxyReg.addAttributes(this.attrSets);
            logger.finest("JoinManager - AddAttributesTask completed");
        }

        public void run() throws Exception {
            this.doAttributes(this.proxyReg);
        }
    }

    private class DiscardProxyTask
    extends JoinTask {
        DiscardProxyTask(ProxyReg proxyReg) {
            super(proxyReg);
        }

        public void run() {
            logger.finest("JoinManager - DiscardProxyTask started");
            JoinManager.this.removeJoinSet(this.proxyReg);
            logger.finest("JoinManager - DiscardProxyTask completed");
        }
    }

    private class LeaseExpireNotifyTask
    extends JoinTask {
        Entry[] regAttrs;

        LeaseExpireNotifyTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.regAttrs = entryArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            logger.finest("JoinManager - LeaseExpireNotifyTask started");
            boolean bl = false;
            ArrayList arrayList = JoinManager.this.joinSet;
            synchronized (arrayList) {
                bl = JoinManager.this.joinSet.contains(this.proxyReg);
            }
            if (bl) {
                this.proxyReg.register(this.regAttrs);
            }
            logger.finest("JoinManager - LeaseExpireNotifyTask completed");
        }
    }

    private class RegisterTask
    extends JoinTask {
        Entry[] regAttrs;

        RegisterTask(ProxyReg proxyReg, Entry[] entryArray) {
            super(proxyReg);
            this.regAttrs = entryArray;
        }

        public void run() throws Exception {
            logger.finest("JoinManager - RegisterTask started");
            this.proxyReg.register(this.regAttrs);
            logger.finest("JoinManager - RegisterTask completed");
        }
    }

    private abstract class JoinTask {
        protected ProxyReg proxyReg;

        JoinTask(ProxyReg proxyReg) {
            this.proxyReg = proxyReg;
        }

        public abstract void run() throws Exception;
    }

    private class ProxyRegTask
    extends RetryTask {
        private final long[] sleepTime;
        protected int tryIndx;
        protected int nRetries;
        protected ProxyReg proxyReg;
        protected int seqN;

        ProxyRegTask(ProxyReg proxyReg, int n) {
            super(JoinManager.this.taskMgr, JoinManager.this.wakeupMgr);
            this.sleepTime = new long[]{5000L, 10000L, 15000L, 20000L, 25000L, 30000L};
            this.tryIndx = 0;
            this.nRetries = 0;
            this.proxyReg = proxyReg;
            this.seqN = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryOnce() {
            while (true) {
                JoinTask joinTask = null;
                List list = this.proxyReg.taskList;
                synchronized (list) {
                    if (this.proxyReg.taskList.isEmpty()) {
                        this.proxyReg.proxyRegTask = null;
                        return true;
                    }
                    joinTask = (JoinTask)this.proxyReg.taskList.get(0);
                }
                try {
                    joinTask.run();
                    list = this.proxyReg.taskList;
                    synchronized (list) {
                        if (!this.proxyReg.taskList.isEmpty()) {
                            this.proxyReg.taskList.remove(0);
                        }
                    }
                    this.tryIndx = 0;
                    this.nRetries = 0;
                }
                catch (Exception exception) {
                    return this.stopTrying(exception);
                }
            }
        }

        public long retryTime() {
            long l = System.currentTimeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
            ++this.nRetries;
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runAfter(List list, int n) {
            ServiceItem serviceItem = JoinManager.this.serviceItem;
            synchronized (serviceItem) {
                if (((JoinManager)JoinManager.this).serviceItem.serviceID != null) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    TaskManager.Task task = (TaskManager.Task)list.get(i);
                    int n2 = ((ProxyRegTask)task).getSeqN();
                    if (this.seqN <= n2) continue;
                    return true;
                }
                return false;
            }
        }

        public ProxyReg getProxyReg() {
            return this.proxyReg;
        }

        public int getSeqN() {
            return this.seqN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean stopTrying(Exception exception) {
            int n = ThrowableConstants.retryable(exception);
            if (n != 0 || this.nRetries >= JoinManager.this.maxNRetries) {
                ArrayList arrayList = JoinManager.this.joinSet;
                synchronized (arrayList) {
                    JoinManager.this.removeTasks(this.proxyReg);
                }
                this.proxyReg.fail(exception);
                return true;
            }
            logger.log(Level.FINER, "JoinManager - failure, will retry later", exception);
            return false;
        }
    }
}

