/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.search.SimpleResultAdapter;
import java.io.IOException;

public class SearchResultsEngine<T> {
    private final SearchEngine fSearchEngine;
    private final SearchResultAdapter<T> fAdapter;

    private SearchResultsEngine(SearchEngine engine, SearchResultAdapter<T> adapter) {
        this.fSearchEngine = engine;
        this.fAdapter = adapter;
    }

    public static SearchResultsEngine<SearchResult> createResultsEngine(SearchEngine engine) {
        return new SearchResultsEngine<SearchResult>(engine, new SimpleResultAdapter());
    }

    public static <T> SearchResultsEngine<T> createResultsEngine(SearchEngine engine, SearchResultAdapter<T> adapter) {
        return new SearchResultsEngine<T>(engine, adapter);
    }

    public void openIndex() throws IOException {
        this.fSearchEngine.openIndex();
    }

    public SearchResults<T> search(SearchCriteria criteria) throws SearchException {
        return this.search(criteria, 0, 0);
    }

    public SearchResults<T> search(SearchCriteria criteria, int start, int numResults) throws SearchException {
        ListSearchResultCollector<T> listCollector = SearchResultsEngine.createCollector(this.fAdapter);
        this.fSearchEngine.search(criteria, listCollector);
        return listCollector.getResults(start, numResults);
    }

    static <T> ListSearchResultCollector<T> createCollector(SearchResultAdapter<T> adapter) {
        return ListSearchResultCollector.createCollector(adapter);
    }

    public SearchSuggestions suggest(SearchField field, String partialText, int maxSuggestions) throws SearchException {
        return this.fSearchEngine.suggest(field, partialText, maxSuggestions);
    }

    public void closeIndex() throws IOException {
        this.fSearchEngine.closeIndex();
    }
}

