/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchField;
import com.mathworks.search.lucene.IndexLocation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public class LuceneIndexUtils {
    private LuceneIndexUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SearchField> Map<T, Boolean> validateSearchFields(IndexLocation location, Collection<T> fieldsToCheck) throws IOException {
        LinkedHashMap<SearchField, Boolean> results = new LinkedHashMap<SearchField, Boolean>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)location.getSearchDirectory());){
            for (SearchField field : fieldsToCheck) {
                results.put(field, LuceneIndexUtils.checkField((IndexReader)reader, field));
            }
            LinkedHashMap<SearchField, Boolean> linkedHashMap = results;
            return linkedHashMap;
        }
    }

    private static boolean checkField(IndexReader reader, SearchField field) throws IOException {
        String searchFieldName = field.getFieldName();
        FieldIndexOption fieldIndexOption = field.isIndexed() ? FieldIndexOption.INDEXED : FieldIndexOption.UNINDEXED;
        Collection<String> all = LuceneIndexUtils.getFieldNames(reader, FieldIndexOption.ALL_FIELD);
        Collection<String> byStatus = LuceneIndexUtils.getFieldNames(reader, fieldIndexOption);
        return all.contains(searchFieldName) && byStatus.contains(searchFieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getSearchFieldStatistics(IndexLocation location, SearchField field) throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)location.getSearchDirectory());){
            Map<String, Integer> map = LuceneIndexUtils.getSearchFieldStatistics((IndexReader)reader, field);
            return map;
        }
    }

    private static Map<String, Integer> getSearchFieldStatistics(IndexReader reader, SearchField field) throws IOException {
        LinkedHashMap<String, Integer> stats = new LinkedHashMap<String, Integer>();
        String fieldName = field.getFieldName();
        Fields fields = MultiFields.getFields((IndexReader)reader);
        if (fields != null) {
            BytesRef text;
            Terms terms = fields.terms(fieldName);
            TermsEnum termsEnum = terms.iterator(null);
            while ((text = termsEnum.next()) != null) {
                String value = text.utf8ToString();
                int numDocs = termsEnum.docFreq();
                stats.put(value, numDocs);
            }
        }
        return stats;
    }

    public static Collection<String> getFieldNames(IndexReader reader, FieldIndexOption fieldIndexTripleState) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (AtomicReaderContext rc : reader.leaves()) {
            AtomicReader ar = rc.reader();
            FieldInfos fieldInfos = ar.getFieldInfos();
            for (FieldInfo item : fieldInfos) {
                String fieldName = item.name;
                if (!fieldIndexTripleState.includeField(item)) continue;
                fieldNames.add(fieldName);
            }
        }
        return fieldNames;
    }

    public static enum FieldIndexOption {
        INDEXED{

            @Override
            protected boolean includeField(FieldInfo info) {
                return info.isIndexed();
            }
        }
        ,
        UNINDEXED{

            @Override
            protected boolean includeField(FieldInfo info) {
                return !info.isIndexed();
            }
        }
        ,
        ALL_FIELD{

            @Override
            protected boolean includeField(FieldInfo info) {
                return true;
            }
        };


        protected abstract boolean includeField(FieldInfo var1);
    }
}

