/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchIndexException;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchIndexException;
import com.mathworks.search.lucene.LuceneVersion;
import com.mathworks.search.lucene.MWAnalyzer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneIndexer
implements Indexer {
    private final IndexLocation fLocation;
    private final SearchLanguage fLanguage;
    private final Analyzer fAnalyzer;
    private final boolean fOverwrite;
    private IndexWriter fWriter;

    public LuceneIndexer(IndexLocation location, SearchLanguage language) throws IOException {
        this(location, language, LuceneIndexer.getDefaultIndexAnalyzer(language));
    }

    public LuceneIndexer(IndexLocation location, SearchLanguage language, Analyzer analyzer) throws IOException {
        this(location, language, analyzer, true);
    }

    public LuceneIndexer(IndexLocation location, SearchLanguage language, Analyzer analyzer, boolean overwrite) throws IOException {
        this.fLocation = location;
        this.fLanguage = language;
        this.fAnalyzer = analyzer;
        this.fOverwrite = overwrite;
    }

    static Analyzer getDefaultIndexAnalyzer(SearchLanguage language) {
        return new MWAnalyzer(language).getIndexAnalyzer();
    }

    Directory getLuceneDirectory() {
        return this.fLocation.getSearchDirectory();
    }

    @Override
    public void openIndex() throws SearchIndexException {
        Directory dir = this.getLuceneDirectory();
        IndexWriterConfig conf = new IndexWriterConfig(LuceneVersion.CURRENT_VERSION, this.fAnalyzer);
        try {
            boolean createIndex = !DirectoryReader.indexExists((Directory)dir) || this.fOverwrite;
            IndexWriterConfig.OpenMode openMode = createIndex ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
            conf.setOpenMode(openMode).setUseCompoundFile(true);
            CheckIndex check = new CheckIndex(dir);
            boolean isSearchIndexCorrupt = check.checkIndex().missingSegments;
            if (createIndex && isSearchIndexCorrupt) {
                LuceneIndexer.cleanDirectory(dir);
            }
            this.createIndexWriter(dir, conf);
        }
        catch (IOException ioe) {
            throw new LuceneSearchIndexException(ioe);
        }
    }

    private void createIndexWriter(Directory dir, IndexWriterConfig conf) throws IOException {
        try {
            this.fWriter = new IndexWriter(dir, conf);
        }
        catch (IndexFormatTooOldException ioe) {
            LuceneIndexer.cleanDirectory(dir);
            this.fWriter = new IndexWriter(dir, conf);
        }
    }

    @Override
    public synchronized void addDocument(IndexDocument<? extends SearchField> document) throws IOException {
        Document luceneDoc = LuceneIndexer.createDocument(document);
        this.fWriter.addDocument((Iterable)luceneDoc, this.getAnalyzer());
    }

    void addDirectories(Directory ... directories) throws IOException {
        this.fWriter.addIndexes(directories);
    }

    static <T extends SearchField> Document createDocument(IndexDocument<T> indexDocument) {
        Document document = new Document();
        for (Map.Entry<T, String> entry : indexDocument.getIndexValues().entrySet()) {
            Field field = LuceneIndexer.createField((SearchField)entry.getKey(), entry.getValue() == null ? "" : entry.getValue());
            if (field.fieldType().indexed() && !field.fieldType().omitNorms()) {
                field.setBoost(indexDocument.getFieldBoost((SearchField)entry.getKey()) * indexDocument.getBoost());
            }
            document.add((IndexableField)field);
        }
        return document;
    }

    private static Field createField(SearchField field, String fieldText) {
        Field.Store store = field.isStored() ? Field.Store.YES : Field.Store.NO;
        Field.Index index = Field.Index.NO;
        if (field.isIndexed()) {
            if (field.isAnalyzed()) {
                return new TextField(field.getFieldName(), fieldText, store);
            }
            return new StringField(field.getFieldName(), fieldText, store);
        }
        return new Field(field.getFieldName(), fieldText, store, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeIndex() throws IOException {
        try {
            this.fWriter.forceMerge(1);
        }
        finally {
            this.fWriter.close();
        }
    }

    private Analyzer getAnalyzer() {
        return this.fAnalyzer;
    }

    SearchLanguage getLanguage() {
        return this.fLanguage;
    }

    private static void cleanDirectory(Directory dir) {
        if (dir instanceof FSDirectory) {
            File folder = ((FSDirectory)dir).getDirectory();
            if (!folder.exists()) {
                return;
            }
            LuceneIndexer.cleanDirectory(folder);
        }
    }

    private static void cleanDirectory(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    LuceneIndexer.cleanDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
    }
}

