/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPopupList;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.floater.DragForwarder;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;

public class MWChoice
extends MWCanvas
implements ItemSelectable,
FloaterOwner {
    private int fSelectedIndex = -1;
    private JPopupMenu fMenu;
    private PopupMenu fPopup;
    private MWPopupList fList;
    private MenuHandler fMenuHandler;
    private PopupHandler fPopupHandler;
    private ItemListener fItemListener;
    private boolean fHilited;
    private boolean fHasFocus;
    private boolean fHasRollover;

    public MWChoice() {
        this.setFont(Decorations.getFont(0));
        if (PlatformInfo.isWindows()) {
            this.fList = new MWPopupList(true);
            this.fList.setFloaterOwner(this);
            DragForwarder dragForwarder = new DragForwarder(this.fList);
            this.addMouseListener(dragForwarder);
            this.addMouseMotionListener(dragForwarder);
            this.fList.addItemListener(new ListItemHandler());
        } else if (PlatformInfo.isMacintosh()) {
            this.fPopup = new PopupMenu();
            this.add(this.fPopup);
            this.fPopupHandler = new PopupHandler();
        } else {
            this.fMenu = new JPopupMenu();
            this.fMenuHandler = new MenuHandler();
        }
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new MouseHandler());
    }

    @Override
    public boolean isFocusTraversable() {
        if (PlatformInfo.getAppearance() == 1) {
            return this.isEnabled();
        }
        return false;
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = focusEvent.getID() != 1005;
        if (bl != this.fHasFocus) {
            this.fHasFocus = bl;
            this.repaint();
        }
        super.processFocusEvent(focusEvent);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (this.fList != null) {
            this.fHilited = this.fList.isVisible();
        }
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension2.height);
        graphics.setFont(this.getFont());
        Decorations.drawPopupControl(graphics, rectangle, this.getSelectedItem(), this.fHilited, this.isEnabled(), this.fHasRollover, this.fHasFocus);
        if (dimension2.height < dimension.height) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, dimension2.height, dimension.width, dimension.height - dimension2.height);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        if (this.fMenu != null) {
            if (this.fSelectedIndex < 0) {
                this.fSelectedIndex = 0;
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem.addActionListener(this.fMenuHandler);
            this.fMenu.add(jCheckBoxMenuItem);
        } else if (this.fPopup != null) {
            if (this.fSelectedIndex < 0) {
                this.fSelectedIndex = 0;
            }
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
            checkboxMenuItem.addItemListener(this.fPopupHandler);
            this.fPopup.add(checkboxMenuItem);
        } else if (this.fList != null) {
            this.fList.addItem(string);
        }
        this.invalidate();
    }

    public void insert(String string, int n) {
        if (this.fMenu != null) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem.addActionListener(this.fMenuHandler);
            this.fMenu.insert(jCheckBoxMenuItem, n);
            if (this.fSelectedIndex >= n) {
                ++this.fSelectedIndex;
            }
        } else if (this.fPopup != null) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
            checkboxMenuItem.addItemListener(this.fPopupHandler);
            this.fPopup.insert(checkboxMenuItem, n);
            if (this.fSelectedIndex >= n) {
                ++this.fSelectedIndex;
            }
        } else if (this.fList != null) {
            this.fList.insertItem(string, n);
        }
    }

    public void remove(String string) {
        if (this.fMenu != null) {
            int n = -1;
            for (int i = 0; i < this.fMenu.getComponentCount(); ++i) {
                if (!((JCheckBoxMenuItem)this.fMenu.getComponent(i)).getText().equals(string)) continue;
                n = i;
            }
            if (n > -1) {
                this.remove(n);
            }
        } else if (this.fPopup != null) {
            int n = -1;
            for (int i = 0; i < this.fPopup.getItemCount(); ++i) {
                if (!this.fPopup.getItem(i).getLabel().equals(string)) continue;
                n = i;
            }
            if (n > -1) {
                this.remove(n);
            }
        } else if (this.fList != null) {
            this.fList.removeItem(string);
        }
    }

    public void remove(int n) {
        if (this.fList != null) {
            this.fList.removeItem(n);
        } else {
            int n2 = 0;
            if (this.fMenu != null) {
                this.fMenu.remove(n);
                n2 = this.fMenu.getComponentCount();
            } else if (this.fPopup != null) {
                this.fPopup.remove(n);
                n2 = this.fPopup.getItemCount();
            }
            if (n2 == 0) {
                this.fSelectedIndex = -1;
            } else if (this.fSelectedIndex == n) {
                this.fSelectedIndex = 0;
            } else if (this.fSelectedIndex > n) {
                --this.fSelectedIndex;
            }
        }
    }

    public void removeAll() {
        if (this.fMenu != null) {
            this.fMenu.removeAll();
            this.fSelectedIndex = -1;
        } else if (this.fPopup != null) {
            this.fPopup.removeAll();
            this.fSelectedIndex = -1;
        } else if (this.fList != null) {
            this.fList.removeAllItems();
        }
    }

    public void select(int n) {
        if (this.fList != null) {
            this.fList.setSelectedIndex(n);
            this.repaint();
        } else {
            int n2 = 0;
            if (this.fMenu != null) {
                n2 = this.fMenu.getComponentCount();
            } else if (this.fPopup != null) {
                n2 = this.fPopup.getItemCount();
            }
            if (n >= 0 && n < n2 && n != this.fSelectedIndex) {
                this.fSelectedIndex = n;
                this.repaint();
            }
        }
    }

    public void select(String string) {
        int n = -1;
        for (int i = 0; i < this.getItemCount(); ++i) {
            String string2 = this.getItem(i);
            if (!string2.equals(string)) continue;
            n = i;
        }
        this.select(n);
    }

    public Object getPopupForQE() {
        if (this.fList != null) {
            return this.fList;
        }
        if (this.fMenu != null) {
            return this.fMenu;
        }
        return this.fPopup;
    }

    public String getSelectedItem() {
        return this.getItem(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        int n = -1;
        if (this.fMenu != null || this.fPopup != null) {
            n = this.fSelectedIndex;
        } else if (this.fList != null) {
            n = this.fList.getSelectedIndex();
        }
        return n;
    }

    public int getItemCount() {
        int n = 0;
        if (this.fMenu != null) {
            n = this.fMenu.getComponentCount();
        } else if (this.fPopup != null) {
            n = this.fPopup.getItemCount();
        } else if (this.fList != null) {
            n = this.fList.getItemCount();
        }
        return n;
    }

    public String getItem(int n) {
        String string = null;
        if (this.fMenu != null) {
            if (n >= 0 && n < this.getItemCount()) {
                string = ((JCheckBoxMenuItem)this.fMenu.getComponent(n)).getText();
            }
        } else if (this.fPopup != null) {
            if (n >= 0 && n < this.getItemCount()) {
                string = this.fPopup.getItem(n).getLabel();
            }
        } else if (this.fList != null) {
            string = this.fList.getItem(n);
        }
        return string;
    }

    public void setItem(String string, int n) {
        if (this.fMenu != null) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.fMenu.getComponent(n);
            if (jCheckBoxMenuItem != null) {
                jCheckBoxMenuItem.setText(string);
            }
        } else if (this.fPopup != null) {
            MenuItem menuItem = this.fPopup.getItem(n);
            if (menuItem != null) {
                menuItem.setLabel(string);
            }
        } else if (this.fList != null) {
            this.fList.setItem(string, n);
        }
        this.invalidate();
    }

    public void setRestrictWidth(boolean bl) {
        if (this.fList != null) {
            this.fList.setUseOwnersWidth(bl);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(70, 20);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = 0;
            if (PlatformInfo.isMacintosh() && fontMetrics.getLeading() > fontMetrics.getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE))) {
                n = (fontMetrics.getMaxAscent() >> 3) - fontMetrics.getLeading();
            }
            dimension.width = 40;
            for (int i = 0; i < this.getItemCount(); ++i) {
                dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(this.getItem(i)));
            }
            dimension.height = fontMetrics.getHeight() + 7 + n;
            dimension.width += dimension.height + 10;
        }
        if (PlatformInfo.useWindowsXPAppearance()) {
            dimension.height -= 2;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.fSelectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getSelectedItem()};
            return objectArray;
        }
        return null;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    @Override
    public void floaterAutoCollapsed(Floater floater) {
        this.fHilited = false;
        this.repaint();
    }

    private void fireItemEvent() {
        if (this.fItemListener != null) {
            this.fItemListener.itemStateChanged(new ItemEvent(this, 701, this.getSelectedItem(), 1));
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (MWChoice.this.isEnabled()) {
                MWChoice.this.fHilited = true;
                MWChoice.this.repaint();
            }
            if (MWChoice.this.isEnabled() && PlatformInfo.getAppearance() == 1) {
                MWChoice.this.requestFocus();
            }
            if (MWChoice.this.isEnabled() && MWChoice.this.getItemCount() > 0) {
                if (MWChoice.this.fMenu != null) {
                    Serializable serializable;
                    for (int i = 0; i < MWChoice.this.fMenu.getComponentCount(); ++i) {
                        serializable = (JCheckBoxMenuItem)MWChoice.this.fMenu.getComponent(i);
                        if (i == MWChoice.this.fSelectedIndex) {
                            ((JCheckBoxMenuItem)serializable).setState(true);
                            continue;
                        }
                        ((JCheckBoxMenuItem)serializable).setState(false);
                    }
                    MWChoice.this.requestFocus();
                    Window window = MWUtils.getTopLevelWindow(MWChoice.this);
                    serializable = MWUtils.boundsInTopLevelWindow(MWChoice.this);
                    MWFrame mWFrame = null;
                    if (window instanceof Dialog) {
                        Container container;
                        for (container = window.getParent(); container != null && !(container instanceof MWFrame); container = container.getParent()) {
                        }
                        mWFrame = (MWFrame)container;
                        if (mWFrame != null) {
                            mWFrame.falsifyBounds(new Rectangle(0, 0, 0, 0));
                        }
                    }
                    MWChoice.this.fMenu.show(window, ((Rectangle)serializable).x, ((Rectangle)serializable).y + MWChoice.this.getPreferredSize().height);
                    if (mWFrame != null) {
                        mWFrame.falsifyBounds(null);
                    }
                    MWChoice.this.fHilited = false;
                } else if (MWChoice.this.fPopup != null) {
                    for (int i = 0; i < MWChoice.this.fPopup.getItemCount(); ++i) {
                        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)MWChoice.this.fPopup.getItem(i);
                        if (i == MWChoice.this.fSelectedIndex) {
                            checkboxMenuItem.setState(true);
                            continue;
                        }
                        checkboxMenuItem.setState(false);
                    }
                    MWChoice.this.fPopup.show(MWChoice.this, 0, MWChoice.this.getPreferredSize().height);
                    MWChoice.this.fHilited = false;
                } else if (MWChoice.this.fList != null) {
                    if (MWChoice.this.fList.isVisible()) {
                        MWChoice.this.fList.collapse();
                        MWChoice.this.fHilited = false;
                    } else {
                        MWChoice.this.fList.setFont(MWChoice.this.getFont());
                        MWChoice.this.fList.show(MWChoice.this, 0, 0, MWChoice.this.getSize().width, MWChoice.this.getPreferredSize().height);
                        MWChoice.this.fHilited = true;
                    }
                    MWChoice.this.repaint();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (MWChoice.this.fMenu != null && MWChoice.this.fMenu.isVisible()) {
                Point point = MWUtils.mapFromComponentToComponent(mouseEvent.getPoint(), (Component)MWChoice.this, (Component)MWChoice.this.fMenu.getParent());
                if (!MWChoice.this.fMenu.getBounds().contains(point)) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MWChoice.this.fHasRollover = true;
            if (PlatformInfo.useWindowsXPAppearance() && MWChoice.this.isEnabled()) {
                Dimension dimension = MWChoice.this.getSize();
                MWChoice.this.repaint(dimension.width - dimension.height, 0, dimension.height, dimension.height);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MWChoice.this.fHasRollover) {
                MWChoice.this.fHasRollover = false;
                if (PlatformInfo.useWindowsXPAppearance() && MWChoice.this.isEnabled()) {
                    Dimension dimension = MWChoice.this.getSize();
                    MWChoice.this.repaint(dimension.width - dimension.height, 0, dimension.height, dimension.height);
                }
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (MWChoice.this.fMenu != null && keyEvent.getKeyCode() == 27) {
                if (MWChoice.this.fMenu.isVisible()) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            } else if (PlatformInfo.getAppearance() == 1 && MWChoice.this.getItemCount() > 0 && MWChoice.this.isEnabled()) {
                if (keyEvent.getModifiers() == 0) {
                    switch (keyEvent.getKeyCode()) {
                        case 37: 
                        case 38: {
                            if (MWChoice.this.getSelectedIndex() <= 0) break;
                            MWChoice.this.select(MWChoice.this.getSelectedIndex() - 1);
                            MWChoice.this.repaint();
                            MWChoice.this.fireItemEvent();
                            break;
                        }
                        case 39: 
                        case 40: {
                            if (MWChoice.this.getSelectedIndex() >= MWChoice.this.getItemCount() - 1) break;
                            MWChoice.this.select(MWChoice.this.getSelectedIndex() + 1);
                            MWChoice.this.repaint();
                            MWChoice.this.fireItemEvent();
                        }
                    }
                } else if (keyEvent.getModifiers() == 8 && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) && MWChoice.this.fList != null) {
                    if (MWChoice.this.fList.isVisible()) {
                        MWChoice.this.fList.collapse();
                        MWChoice.this.fHilited = false;
                    } else {
                        MWChoice.this.fList.setFont(MWChoice.this.getFont());
                        MWChoice.this.fList.show(MWChoice.this, 0, 0, MWChoice.this.getSize().width, MWChoice.this.getPreferredSize().height);
                        MWChoice.this.fHilited = true;
                    }
                    MWChoice.this.repaint();
                }
            }
        }
    }

    private class ListItemHandler
    implements ItemListener {
        private ListItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MWChoice.this.fireItemEvent();
            MWChoice.this.fHilited = MWChoice.this.fList.isVisible();
            MWChoice.this.repaint();
        }
    }

    private class PopupHandler
    implements ItemListener {
        private PopupHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getItemSelectable();
            int n = -1;
            for (int i = 0; i < MWChoice.this.fPopup.getItemCount(); ++i) {
                if (MWChoice.this.fPopup.getItem(i) != checkboxMenuItem) continue;
                n = i;
            }
            if (n != MWChoice.this.fSelectedIndex) {
                MWChoice.this.fSelectedIndex = n;
                MWChoice.this.fireItemEvent();
            }
            MWChoice.this.fHilited = false;
            MWChoice.this.repaint();
        }
    }

    private class MenuHandler
    implements ActionListener {
        private MenuHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            int n = -1;
            for (int i = 0; i < MWChoice.this.fMenu.getComponentCount(); ++i) {
                if (MWChoice.this.fMenu.getComponent(i) != jCheckBoxMenuItem) continue;
                n = i;
            }
            if (n != MWChoice.this.fSelectedIndex) {
                MWChoice.this.fSelectedIndex = n;
                MWChoice.this.fireItemEvent();
            }
            MWChoice.this.fHilited = false;
            MWChoice.this.repaint();
        }
    }
}

