/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class MWTab
extends MWCanvas
implements MouseListener,
MouseMotionListener,
ItemSelectable {
    public static final int TAB_TOP = 1;
    public static final int TAB_LEFT = 2;
    public static final int TAB_BOTTOM = 3;
    public static final int TAB_RIGHT = 4;
    public static final int DIALOG = 0;
    public static final int DOCUMENT = 1;
    public static final int DOCUMENT_OVERLAP = 2;
    public static final int NO_ITEM = -1;
    private static final int NO_PART = -1;
    private static final int DECREMENT_PART = 0;
    private static final int INCREMENT_PART = 1;
    private static final int TABS_PART = 2;
    private static final int PART_COUNT = 3;
    private static int sAppearance = -1;
    private static Color sControl;
    private static Color sHilite;
    private static Color sLtHilite;
    private static Color sShadow;
    private static Color sDkShadow;
    private Vector fItems;
    private int fSelectedIndex;
    private boolean fScrollable;
    private int fScrollPosition;
    private int fTrackingPart;
    private Point fMousePoint;
    private boolean fMouseDown;
    private Rectangle[] fPartRects;
    private Rectangle[] fRolloverRects;
    private int fRolloverIndex;
    private int fRolloverPart;
    private int fStyle;
    private int fOrientation;
    private boolean fHorizontal;
    private int fSelectedTabColor;
    private int fTabColor;
    private int fPendingAutoScroll;
    transient ItemListener fItemListener;

    public MWTab(int n, int n2) {
        this.fOrientation = n;
        this.fStyle = n2;
        this.fScrollable = false;
        this.fScrollPosition = 0;
        this.fTrackingPart = -1;
        this.fPartRects = new Rectangle[3];
        this.fRolloverIndex = -1;
        this.fRolloverPart = -1;
        this.fSelectedTabColor = 0;
        this.fTabColor = 6;
        this.fHorizontal = this.fOrientation == 1 || this.fOrientation == 3;
        this.fItems = new Vector();
        this.fSelectedIndex = -1;
        this.fPendingAutoScroll = -1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFont(Decorations.getFont(0));
    }

    public MWTab(int n) {
        this(n, 0);
    }

    public MWTab() {
        this(1, 0);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    public int getSelectedTabColor() {
        return this.fSelectedTabColor;
    }

    public void setSelectedTabColor(int n) {
        this.fSelectedTabColor = n;
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (n == this.fOrientation) break;
                this.fOrientation = n;
                this.fHorizontal = this.fOrientation == 1 || this.fOrientation == 3;
            }
        }
    }

    public boolean isScrollable() {
        return this.fScrollable;
    }

    public void setScrollable(boolean bl) {
        this.fScrollPosition = 0;
        this.fScrollable = bl;
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                if (n == this.fStyle) break;
                this.fStyle = n;
            }
        }
    }

    public void add(String string) {
        this.addItem(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(String string) {
        Vector vector = this.fItems;
        synchronized (vector) {
            this.fItems.addElement(string);
            if (this.fSelectedIndex == -1) {
                this.fSelectedIndex = 0;
            }
            if (this.fScrollable) {
                int n;
                Rectangle[] rectangleArray = this.calcRects();
                Rectangle rectangle = this.fPartRects[2];
                Rectangle rectangle2 = rectangleArray[rectangleArray.length - 1];
                if (this.fHorizontal) {
                    for (n = rectangleArray.length - 1; n >= 0 && rectangle.width > rectangle2.x - rectangleArray[n].x + rectangle2.width; --n) {
                    }
                } else {
                    while (n >= 0 && rectangle.height > rectangle2.y - rectangleArray[n].y + rectangle2.height) {
                        --n;
                    }
                }
                this.setScrollPosition(n + 1);
            }
        }
        this.repaint(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Vector vector = this.fItems;
        synchronized (vector) {
            int n;
            for (n = 0; n < this.fItems.size() && !string.equals(this.getItem(n)); ++n) {
            }
            if (n < this.fItems.size()) {
                this.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Vector vector = this.fItems;
        synchronized (vector) {
            this.fItems.removeElementAt(n);
            if (n == this.fSelectedIndex) {
                if (this.fItems.size() < 2) {
                    this.fScrollPosition = 0;
                } else if (this.fScrollPosition >= this.fItems.size()) {
                    this.fScrollPosition = this.fItems.size() - 1;
                }
                this.fSelectedIndex = this.fItems.size() > 0 ? 0 : -1;
            }
        }
    }

    public int getSelectedIndex() {
        return this.fSelectedIndex;
    }

    public String getSelectedItem() {
        String string = null;
        if (this.fSelectedIndex != -1) {
            string = this.getItem(this.fSelectedIndex);
        }
        return string;
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public synchronized void setItem(String string, int n) {
        if (n >= 0 && n < this.fItems.size()) {
            this.fItems.setElementAt(string, n);
        }
        this.repaint(5L);
    }

    public String getItem(int n) {
        String string = null;
        if (n != -1 && n < this.fItems.size()) {
            string = (String)this.fItems.elementAt(n);
        }
        return string;
    }

    public void select(String string) {
        int n;
        for (n = 0; n < this.fItems.size() && !string.equals(this.getItem(n)); ++n) {
        }
        if (n < this.fItems.size()) {
            this.select(n);
        }
    }

    public void select(int n) {
        this.select(n, true);
    }

    private void select(int n, boolean bl) {
        if (this.fItems.size() > 0) {
            this.fSelectedIndex = n < 0 ? 0 : (n >= this.fItems.size() ? this.fItems.size() - 1 : n);
            if (bl) {
                this.scrollToTab(this.fSelectedIndex);
            }
        } else {
            this.fScrollPosition = 0;
            this.fSelectedIndex = -1;
        }
        this.repaint(5L);
    }

    public void scrollToTab(int n) {
        Dimension dimension = this.getSize();
        if (!this.isShowing() || dimension.width == 0 && dimension.height == 0) {
            this.fPendingAutoScroll = n;
        } else if (this.isScrollable() && n != this.fScrollPosition) {
            this.fPendingAutoScroll = -1;
            if (n < this.fScrollPosition) {
                this.setScrollPosition(n);
            } else if (n >= 0 && n < this.fItems.size()) {
                Rectangle[] rectangleArray = this.calcRects();
                Rectangle rectangle = this.fPartRects[2];
                int n2 = n;
                if (this.fHorizontal) {
                    if (rectangleArray[n2].x + rectangleArray[n2].width > rectangle.x + rectangle.width) {
                        for (int i = n2; i >= 0; --i) {
                            int n3 = rectangleArray[n2].x - rectangleArray[i].x;
                            if (rectangleArray[n2].width + n3 <= rectangle.width) continue;
                            if (i == n2) {
                                this.setScrollPosition(i);
                            } else {
                                this.setScrollPosition(i + 1);
                            }
                            break;
                        }
                    }
                } else if (rectangleArray[n2].y + rectangleArray[n2].height > rectangle.y + rectangle.height) {
                    for (int i = n2; i >= 0; --i) {
                        int n4 = rectangleArray[n2].y - rectangleArray[i].y;
                        if (rectangleArray[n2].height + n4 <= rectangle.height) continue;
                        if (i == n2) {
                            this.setScrollPosition(i);
                        } else {
                            this.setScrollPosition(i + 1);
                        }
                        break;
                    }
                }
            }
        } else {
            this.fPendingAutoScroll = -1;
        }
    }

    public int getScrollPosition() {
        return this.fScrollPosition;
    }

    public void setScrollPosition(int n) {
        if (n != this.fScrollPosition && n >= 0 && n < this.fItems.size()) {
            this.fScrollPosition = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        Vector vector = this.fItems;
        synchronized (vector) {
            for (int i = 0; i < this.fItems.size(); ++i) {
                int n;
                Dimension dimension2 = this.tabSize(i);
                if (this.fHorizontal) {
                    int n2 = n = this.fStyle == 2 && i > 0 ? dimension2.height / 2 : 0;
                    if (dimension2.height > dimension.height) {
                        dimension.height = dimension2.height;
                    }
                    dimension.width += dimension2.width - n;
                    continue;
                }
                int n3 = n = this.fStyle == 2 && i > 0 ? dimension2.width / 2 : 0;
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
                dimension.height += dimension2.height - n;
            }
        }
        if (this.fStyle == 0) {
            dimension.width += 4;
            dimension.height += 4;
        }
        return dimension;
    }

    private Dimension tabSize(int n) {
        Dimension dimension = new Dimension(60, 20);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String string = (String)this.fItems.elementAt(n);
            dimension.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n2 = (dimension.height - 1) / 8 + 1;
            if (this.fStyle == 0) {
                dimension.height += 2 * n2;
                dimension.width = fontMetrics.stringWidth(string + "333") + 4;
            } else {
                dimension.height += 2 * n2;
                if (PlatformInfo.getPlatform() != 0) {
                    --dimension.height;
                }
                dimension.width = fontMetrics.stringWidth(string + "3") + dimension.height;
            }
        }
        if (!this.fHorizontal) {
            int n3 = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n3;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle[] calcRects() {
        int n;
        Rectangle[] rectangleArray = new Rectangle[]{};
        Dimension dimension = this.getSize();
        int n2 = 0;
        if (this.fScrollable) {
            int n3;
            int n4 = dimension.height;
            n = dimension.width;
            if (this.fHorizontal) {
                if (n4 > 16) {
                    n4 = 16;
                    n3 = dimension.height - n4;
                } else {
                    --n4;
                    n3 = 1;
                }
                if (this.fOrientation == 3) {
                    n3 = 0;
                }
                this.fPartRects[0] = new Rectangle(0, n3, n4, n4);
                this.fPartRects[1] = new Rectangle(n4, n3, n4, n4);
                this.fPartRects[2] = new Rectangle(n4 *= 2, 0, n - n4, dimension.height);
            } else {
                if (n > 16) {
                    n = 16;
                    n3 = dimension.width - n;
                } else {
                    --n;
                    n3 = 1;
                }
                if (this.fOrientation == 4) {
                    n3 = 0;
                }
                this.fPartRects[0] = new Rectangle(n3, 0, n, n);
                this.fPartRects[1] = new Rectangle(n3, n, n, n);
                this.fPartRects[2] = new Rectangle(0, n *= 2, dimension.width, n4 - n);
            }
        } else {
            this.fPartRects[0] = new Rectangle(0, 0, 0, 0);
            this.fPartRects[1] = new Rectangle(0, 0, 0, 0);
            this.fPartRects[2] = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        Cloneable cloneable = this.fItems;
        synchronized (cloneable) {
            rectangleArray = new Rectangle[this.fItems.size()];
            for (n = 0; n < this.fItems.size(); ++n) {
                int n5;
                int n6;
                Dimension dimension2 = this.tabSize(n);
                if (this.fHorizontal) {
                    int n7 = n6 = this.fStyle == 0 ? n2 + 2 : n2;
                    if (this.fOrientation == 1) {
                        n5 = dimension.height - dimension2.height;
                        if (this.fStyle == 0) {
                            n5 -= 2;
                        }
                    } else {
                        n5 = this.fStyle == 0 ? 2 : 0;
                    }
                    n2 += dimension2.width;
                    if (this.fStyle == 2) {
                        n2 -= dimension2.height / 2;
                    }
                } else {
                    int n8 = n5 = this.fStyle == 0 ? n2 + 2 : n2;
                    if (this.fOrientation == 2) {
                        n6 = dimension.width - dimension2.width;
                        if (this.fStyle == 0) {
                            n6 -= 2;
                        }
                    } else {
                        n6 = this.fStyle == 0 ? 2 : 0;
                    }
                    n2 += dimension2.height;
                    if (this.fStyle == 2) {
                        n2 -= dimension2.width / 2;
                    }
                }
                rectangleArray[n] = new Rectangle(n6, n5, dimension2.width, dimension2.height);
            }
        }
        if (rectangleArray.length > 0) {
            if (this.fScrollPosition >= rectangleArray.length) {
                this.fScrollPosition = rectangleArray.length - 1;
            }
            cloneable = new Rectangle(rectangleArray[this.fScrollPosition]);
            for (n = 0; n < rectangleArray.length; ++n) {
                if (this.fScrollPosition != 0) {
                    if (this.fHorizontal) {
                        rectangleArray[n].translate(-((Rectangle)cloneable).x, 0);
                    } else {
                        rectangleArray[n].translate(0, -((Rectangle)cloneable).y);
                    }
                }
                if (!this.fScrollable) continue;
                rectangleArray[n].translate(this.fPartRects[2].x, this.fPartRects[2].y);
            }
        }
        return rectangleArray;
    }

    private boolean partEnabled(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.isEnabled() && this.fScrollPosition > 0;
                break;
            }
            case 1: {
                Rectangle[] rectangleArray = this.calcRects();
                if (!this.isEnabled() || rectangleArray.length <= 0) break;
                Rectangle rectangle = rectangleArray[rectangleArray.length - 1];
                bl = this.fHorizontal ? rectangle.x + rectangle.width > this.getSize().width : rectangle.y + rectangle.height > this.getSize().height;
            }
        }
        return bl;
    }

    private int findPart(Point point) {
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            if (this.fPartRects[i] == null || !this.fPartRects[i].contains(point)) continue;
            n = i;
            break;
        }
        return n;
    }

    private int findTab(Point point) {
        int n = -1;
        Rectangle[] rectangleArray = this.calcRects();
        if (rectangleArray.length > 0) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (!rectangleArray[i].contains(point)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void initColors() {
        if (sAppearance != PlatformInfo.getAppearance()) {
            sControl = Decorations.getColor(6);
            sHilite = Decorations.getColor(8);
            sLtHilite = Decorations.getColor(7);
            sShadow = Decorations.getColor(9);
            sDkShadow = Decorations.getColor(10);
            sAppearance = PlatformInfo.getAppearance();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fPendingAutoScroll != -1) {
            this.scrollToTab(this.fPendingAutoScroll);
        }
        this.drawTabs(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.drawTabs(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTabs(Graphics graphics) {
        int n = 2;
        int n2 = 2;
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = this.isEnabled();
        graphics.setFont(this.getFont());
        Vector vector = this.fItems;
        synchronized (vector) {
            String string;
            Rectangle[] rectangleArray = this.calcRects();
            Rectangle rectangle2 = this.fPartRects[2];
            if (PlatformInfo.useWindowsXPAppearance() && this.fStyle == 0) {
                this.fRolloverRects = rectangleArray;
            }
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            if (rectangleArray.length > 0) {
                int n3;
                int n4 = this.fSelectedIndex < 0 ? 0 : (this.fSelectedIndex >= rectangleArray.length ? rectangleArray.length - 1 : this.fSelectedIndex);
                for (n3 = 0; n3 < n4; ++n3) {
                    string = (String)this.fItems.elementAt(n3);
                    if (this.fStyle == 0) {
                        Decorations.drawDialogTab(graphics, string, rectangleArray[n3], false, this.fOrientation, bl, this.fRolloverIndex == n3, this);
                        continue;
                    }
                    Decorations.drawDocumentTab(graphics, string, rectangleArray[n3], this.fTabColor, this.fOrientation, bl, this);
                }
                for (n3 = rectangleArray.length - 1; n3 > n4; --n3) {
                    string = (String)this.fItems.elementAt(n3);
                    if (this.fStyle == 0) {
                        Decorations.drawDialogTab(graphics, string, rectangleArray[n3], false, this.fOrientation, bl, this.fRolloverIndex == n3, this);
                        continue;
                    }
                    Decorations.drawDocumentTab(graphics, string, rectangleArray[n3], this.fTabColor, this.fOrientation, bl, this);
                }
                if (this.fHorizontal) {
                    n = rectangleArray[n4].x;
                    n2 = rectangleArray[n4].x + rectangleArray[n4].width;
                } else {
                    n = rectangleArray[n4].y;
                    n2 = rectangleArray[n4].y + rectangleArray[n4].height;
                }
            }
            rectangle2 = this.getBounds();
            rectangle2.translate(-rectangle2.x, -rectangle2.y);
            if (this.fStyle == 0) {
                Decorations.drawDialogTabEdge(graphics, rectangle2, n, n2, this.fOrientation);
            } else {
                Decorations.drawDocumentTabEdge(graphics, rectangle2, n, n2, this.fOrientation);
            }
            if (this.fSelectedIndex != -1) {
                string = (String)this.fItems.elementAt(this.fSelectedIndex);
                if (this.fStyle == 0) {
                    Decorations.drawDialogTab(graphics, string, rectangleArray[this.fSelectedIndex], true, this.fOrientation, bl, false, this);
                } else {
                    Decorations.drawDocumentTab(graphics, string, rectangleArray[this.fSelectedIndex], this.fSelectedTabColor, this.fOrientation, bl, this);
                }
            }
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.drawScrollButtons(graphics);
    }

    private void drawScrollButtons(Graphics graphics) {
        if (this.fScrollable) {
            int n = this.fHorizontal ? 1 : 0;
            graphics.setColor(this.getBackground());
            if (this.fHorizontal) {
                if (this.fOrientation == 1) {
                    graphics.fillRect(0, 0, this.fPartRects[2].x, this.fPartRects[0].y);
                } else {
                    graphics.fillRect(0, this.fPartRects[0].height, this.fPartRects[2].x, this.fPartRects[2].height - this.fPartRects[0].height);
                }
                if (this.fStyle == 0 && this.fScrollPosition > 0) {
                    int n2;
                    int n3;
                    int n4;
                    int n5 = this.fPartRects[2].x;
                    if (this.fOrientation == 1) {
                        n4 = 0;
                        n3 = n4 + 1;
                        n2 = this.fPartRects[0].y - 1;
                    } else {
                        n4 = this.fPartRects[2].height - 1;
                        n3 = n4 - 2;
                        n2 = this.fPartRects[0].height;
                    }
                    if (this.fSelectedIndex == this.fScrollPosition) {
                        graphics.drawLine(n5, n4, n5, n4);
                        graphics.setColor(Decorations.getColor(7));
                        if (this.fPartRects[2].height > this.fPartRects[0].height + 2) {
                            graphics.drawLine(n5 - 1, n3, n5 - 1, n2);
                            if (this.fOrientation == 1) {
                                graphics.drawLine(n5, n4, n5, n4);
                            }
                        }
                    } else {
                        if (this.fOrientation == 1) {
                            graphics.drawLine(n5 + 1, n4, n5 + 1, ++n3);
                            ++n3;
                        }
                        graphics.drawLine(n5, n4, n5, n3);
                    }
                }
            } else {
                if (this.fOrientation == 2) {
                    graphics.fillRect(0, 0, this.fPartRects[0].x, this.fPartRects[2].y);
                } else {
                    graphics.fillRect(this.fPartRects[0].width, 0, this.fPartRects[2].width - this.fPartRects[0].width, this.fPartRects[2].y);
                }
                if (this.fStyle == 0 && this.fScrollPosition > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9 = this.fPartRects[2].y;
                    if (this.fOrientation == 2) {
                        n8 = 0;
                        n7 = n8 + 1;
                        n6 = this.fPartRects[0].x - 1;
                    } else {
                        n8 = this.fPartRects[2].width - 1;
                        n7 = n8 - 2;
                        n6 = this.fPartRects[0].width;
                    }
                    if (this.fSelectedIndex == this.fScrollPosition) {
                        graphics.drawLine(n8, n9, n8, n9);
                        graphics.setColor(Decorations.getColor(7));
                        if (this.fPartRects[2].width > this.fPartRects[0].width + 2) {
                            graphics.drawLine(n7, n9 - 1, n6, n9 - 1);
                            if (this.fOrientation == 2) {
                                graphics.drawLine(n8, n9, n8, n9);
                            }
                        }
                    } else {
                        if (this.fOrientation == 2) {
                            graphics.drawLine(n8, n9 + 1, ++n7, n9 + 1);
                            ++n7;
                        }
                        graphics.drawLine(n8, n9, n7, n9);
                    }
                }
            }
            boolean bl = this.fTrackingPart == 0 && this.fPartRects[this.fTrackingPart].contains(this.fMousePoint);
            Decorations.drawScrollArrowButton(graphics, this.fPartRects[0], bl, this.partEnabled(0), this.fRolloverPart == 0, n, 0);
            bl = this.fTrackingPart == 1 && this.fPartRects[this.fTrackingPart].contains(this.fMousePoint);
            Decorations.drawScrollArrowButton(graphics, this.fPartRects[1], bl, this.partEnabled(1), this.fRolloverPart == 1, n, 4);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.fSelectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.fSelectedIndex)};
            return objectArray;
        }
        return null;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.findPart(mouseEvent.getPoint());
        switch (n) {
            case 0: 
            case 1: {
                if (!this.partEnabled(n)) break;
                this.fTrackingPart = n;
                this.fMousePoint = mouseEvent.getPoint();
                this.fMouseDown = true;
                Rectangle rectangle = this.fPartRects[n];
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            case 2: {
                int n2 = this.findTab(mouseEvent.getPoint());
                if (n2 == -1 || n2 == this.fSelectedIndex) break;
                this.select(n2, false);
                if (this.fItemListener == null) break;
                ItemEvent itemEvent = new ItemEvent(this, 701, this.getItem(this.fSelectedIndex), 1);
                this.fItemListener.itemStateChanged(itemEvent);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        switch (this.fTrackingPart) {
            case 0: 
            case 1: {
                if (this.fPartRects[this.fTrackingPart].contains(point)) {
                    if (this.fTrackingPart == 0) {
                        this.setScrollPosition(this.fScrollPosition - 1);
                    } else {
                        this.setScrollPosition(this.fScrollPosition + 1);
                    }
                }
                this.fTrackingPart = -1;
                this.fMouseDown = false;
                this.repaint(5L);
                break;
            }
            default: {
                this.fTrackingPart = -1;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (PlatformInfo.useWindowsXPAppearance() && this.fStyle == 0 && this.fRolloverRects != null) {
            if (this.fPartRects[0].contains(mouseEvent.getPoint())) {
                this.fRolloverPart = 0;
                if (this.isEnabled()) {
                    this.repaint(this.fPartRects[0].x, this.fPartRects[0].y, this.fPartRects[0].width, this.fPartRects[0].height);
                }
            } else if (this.fPartRects[1].contains(mouseEvent.getPoint())) {
                this.fRolloverPart = 1;
                if (this.isEnabled()) {
                    this.repaint(this.fPartRects[1].x, this.fPartRects[1].y, this.fPartRects[1].width, this.fPartRects[1].height);
                }
            } else {
                int n;
                for (n = 0; n < this.fRolloverRects.length && !this.fRolloverRects[n].contains(mouseEvent.getPoint()); ++n) {
                }
                if (n < this.fRolloverRects.length) {
                    this.fRolloverIndex = n;
                    this.fRolloverPart = 2;
                    if (n != this.fSelectedIndex && this.isEnabled()) {
                        this.repaint(this.fRolloverRects[n].x, this.fRolloverRects[n].y, this.fRolloverRects[n].width, this.fRolloverRects[n].height);
                    }
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (PlatformInfo.useWindowsXPAppearance() && this.fStyle == 0) {
            if (this.fRolloverIndex != -1) {
                int n = this.fRolloverIndex;
                if (n != this.fSelectedIndex && this.isEnabled()) {
                    this.repaint(this.fRolloverRects[n].x, this.fRolloverRects[n].y, this.fRolloverRects[n].width, this.fRolloverRects[n].height);
                }
            } else if (this.fRolloverPart == 0 && this.isEnabled()) {
                this.repaint(this.fPartRects[0].x, this.fPartRects[0].y, this.fPartRects[0].width, this.fPartRects[0].height);
            } else if (this.fRolloverPart == 1 && this.isEnabled()) {
                this.repaint(this.fPartRects[1].x, this.fPartRects[1].y, this.fPartRects[1].width, this.fPartRects[1].height);
            }
            this.fRolloverIndex = -1;
            this.fRolloverPart = -1;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (PlatformInfo.useWindowsXPAppearance() && this.fStyle == 0) {
            int n = this.fRolloverIndex;
            if (this.fRolloverIndex != -1) {
                if (!this.fRolloverRects[n].contains(mouseEvent.getPoint())) {
                    this.fRolloverPart = -1;
                    this.fRolloverIndex = -1;
                    if (n != this.fSelectedIndex && this.isEnabled()) {
                        this.repaint(this.fRolloverRects[n].x, this.fRolloverRects[n].y, this.fRolloverRects[n].width, this.fRolloverRects[n].height);
                    }
                }
            } else if (this.fRolloverPart == 0) {
                if (!this.fPartRects[0].contains(mouseEvent.getPoint())) {
                    this.fRolloverPart = -1;
                    if (this.isEnabled()) {
                        this.repaint(this.fPartRects[0].x, this.fPartRects[0].y, this.fPartRects[0].width, this.fPartRects[0].height);
                    }
                }
            } else if (this.fRolloverPart == 1 && !this.fPartRects[1].contains(mouseEvent.getPoint())) {
                this.fRolloverPart = -1;
                if (this.isEnabled()) {
                    this.repaint(this.fPartRects[1].x, this.fPartRects[1].y, this.fPartRects[1].width, this.fPartRects[1].height);
                }
            }
            if (this.fRolloverPart == -1) {
                this.mouseEntered(mouseEvent);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        switch (this.fTrackingPart) {
            case 0: 
            case 1: {
                boolean bl = this.fPartRects[this.fTrackingPart].contains(this.fMousePoint);
                boolean bl2 = this.fPartRects[this.fTrackingPart].contains(point);
                this.fMousePoint = point;
                if (bl2 == bl) break;
                Rectangle rectangle = this.fPartRects[this.fTrackingPart];
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

