/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWTextComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MWTextArea
extends MWTextComponent {
    private int fColumns;
    private int fRows;
    private int fWidth;
    private int fHeight;

    public MWTextArea() {
        this("", 5, 20);
    }

    public MWTextArea(String string) {
        this(string, 5, Math.max(string.length(), 20));
    }

    public MWTextArea(int n, int n2) {
        this("", n, n2);
    }

    public MWTextArea(String string, int n, int n2) {
        super(string);
        this.setFont(Decorations.getFont(0));
        this.setVScrollStyle(2);
        this.setHScrollStyle(2);
        this.setRows(n);
        this.setColumns(n2);
        this.getView().surrogateSetFocusTraversalKeysEnabled(false);
    }

    public void append(String string) {
        int n = this.getModel().length();
        this.getModel().replace(n, n, string);
    }

    public void insert(String string, int n) {
        this.getModel().replace(n, n, string);
    }

    public void replaceRange(String string, int n, int n2) {
        this.getModel().replace(n, n2, string);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.getView().surrogateSetFocusTraversalKeysEnabled(!bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.cacheDimensions();
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MWTextField.setColumns: Negative number of columns not allowed.");
        }
        this.fColumns = n;
        this.cacheDimensions();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    public void setRows(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MWTextField.setRows: Negative number of columns not allowed.");
        }
        this.fRows = n;
        this.cacheDimensions();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void setVScrollStyle(int n) {
        super.setVScrollStyle(n);
        this.cacheDimensions();
    }

    @Override
    public void setHScrollStyle(int n) {
        super.setHScrollStyle(n);
        this.cacheDimensions();
    }

    private void cacheDimensions() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        this.fWidth = this.fColumns * fontMetrics.charWidth('M') + insets.left + insets.right + (this.getVScrollStyle() == 2 ? 16 : 0);
        this.fHeight = this.fRows * fontMetrics.getHeight() + insets.top + insets.bottom + (this.getHScrollStyle() == 2 ? 16 : 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fWidth, this.fHeight);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    private static class Test
    extends Frame {
        private Panel fPanel = new TestPanel();
        private Component fComponent;

        public Test() {
            super("Text Example");
            this.add((Component)this.fPanel, "Center");
            this.fPanel.setLayout(new FlowLayout());
            this.fPanel.add(new MWTextArea());
            this.fPanel.add(new MWTextArea("hi there"));
            this.fPanel.add(new MWTextArea(3, 6));
            this.fPanel.add(new MWTextArea(6, 3));
            this.fPanel.add(new MWTextArea("polish the blemish", 7, 20));
            this.addWindowListener(new TestWindowEventHandler());
            this.pack();
            this.setVisible(true);
        }

        class TestPanel
        extends Panel {
            TestPanel() {
                this.setBackground(Decorations.getColor(1));
            }

            @Override
            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        }

        class TestWindowEventHandler
        extends WindowAdapter {
            TestWindowEventHandler() {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Test.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        }
    }
}

