/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CellCharacter
extends CellText {
    public CellCharacter(Table table) {
        super(table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof Character) {
            String string = ((Character)object).toString();
            super.render(graphics, n, n2, rectangle, string, style, bl);
        }
    }

    @Override
    protected String getInitialValue(int n, int n2) {
        String string = "";
        Object object = this.getTable().getData().getData(n, n2);
        if (object instanceof Character) {
            string = ((Character)object).toString();
        }
        return string;
    }

    @Override
    public void commitEdit(int n, int n2) {
        MWTextField mWTextField = this.getField();
        if (mWTextField != null) {
            Object object = mWTextField.getText().length() == 1 ? new Character(mWTextField.getText().charAt(0)) : mWTextField.getText();
            this.commitEdit(n, n2, object);
        } else {
            super.commitEdit(n, n2);
        }
    }

    @Override
    protected void getPreferredCellSize(int n, int n2, Dimension dimension) {
        if (dimension != null) {
            super.getPreferredCellSize(n, n2, dimension);
            Font font = this.getTable().getCellStyle(n, n2).getFont();
            Object object = this.getTable().getCellData(n, n2);
            if (font != null && object instanceof Character) {
                String string = ((Character)object).toString();
                FontMetrics fontMetrics = this.getTable().getFontMetrics(font);
                dimension.height += fontMetrics.getHeight();
                dimension.width += fontMetrics.stringWidth(CellCharacter.displayString(string));
            }
        }
    }
}

