/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableUtils;
import com.mathworks.mwt.table.TreeData;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

class KeyTracker
extends KeyAdapter {
    KeyTracker() {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof Table) {
            Table table = (Table)keyEvent.getSource();
            int n = table.getSelectionOptions().getMode();
            int n2 = table.getSelectionOptions().getSelectBy();
            int n3 = table.getSelectionOptions().getNavigationMode();
            boolean bl = false;
            int n4 = keyEvent.getKeyCode();
            switch (n4) {
                case 38: {
                    if (n == 0) {
                        table.vScroll(2);
                    } else if (table.getFirstSelectedRow() == -2) {
                        this.selectLast(table);
                    } else {
                        this.doBasicArrowSelection(table, n4, keyEvent.getModifiers());
                    }
                    bl = true;
                    break;
                }
                case 40: {
                    if (n == 0) {
                        table.vScroll(1);
                    } else if (table.getFirstSelectedRow() == -2) {
                        this.selectFirst(table);
                    } else {
                        this.doBasicArrowSelection(table, n4, keyEvent.getModifiers());
                    }
                    bl = true;
                    break;
                }
                case 37: {
                    if (n == 0) {
                        table.hScroll(2);
                    } else if (table.getFirstSelectedRow() == -2) {
                        this.selectLast(table);
                    } else if (n2 == 1 && n == 1 && table.getTreeData() != null) {
                        int n5;
                        int n6;
                        TreeData treeData = table.getTreeData();
                        boolean bl2 = treeData.isExpanded(n6 = treeData.getItemId(n5 = table.getFirstSelectedRow()));
                        if (bl2) {
                            treeData.collapseItem(n6);
                            table.fireValueChangedEvent(n5, -3, new Boolean(true));
                        } else {
                            this.selectParent(table, n5);
                        }
                    } else {
                        this.doBasicArrowSelection(table, n4, keyEvent.getModifiers());
                    }
                    bl = true;
                    break;
                }
                case 39: {
                    if (n == 0) {
                        table.hScroll(1);
                    } else if (table.getFirstSelectedRow() == -2) {
                        this.selectFirst(table);
                    } else if (n2 == 1 && n == 1 && table.getTreeData() != null) {
                        TreeData treeData = table.getTreeData();
                        int n7 = table.getFirstSelectedRow();
                        int n8 = treeData.getItemId(n7);
                        boolean bl3 = treeData.isExpanded(n8);
                        boolean bl4 = treeData.isBranch(n8);
                        if (bl4) {
                            if (!bl3) {
                                treeData.expandItem(n8);
                                if (table.getScrollOnExpand()) {
                                    table.showRows(n7, treeData.getChildren(n8).length + 1);
                                }
                                table.fireValueChangedEvent(n7, -3, new Boolean(false));
                            } else if (treeData.hasChildren(n8)) {
                                table.select(n7 + 1, 0);
                                table.scrollToCell(n7 + 1, 0);
                            }
                        }
                    } else {
                        this.doBasicArrowSelection(table, n4, keyEvent.getModifiers());
                    }
                    bl = true;
                    break;
                }
                case 8: {
                    int n9;
                    if (n == 1 && table.getTreeData() != null && (n9 = table.getFirstSelectedRow()) != -2) {
                        this.selectParent(table, n9);
                    }
                    bl = true;
                    break;
                }
                case 107: {
                    int n10;
                    if (n != 1 || table.getTreeData() == null) break;
                    TreeData treeData = table.getTreeData();
                    int n11 = table.getFirstSelectedRow();
                    if (n11 == -2 || !treeData.isBranch(n10 = treeData.getItemId(n11)) || treeData.isExpanded(n10)) break;
                    treeData.expandItem(n10);
                    break;
                }
                case 106: {
                    if (n != 1 || table.getTreeData() == null) break;
                    TreeData treeData = table.getTreeData();
                    int n12 = table.getFirstSelectedRow();
                    if (n12 != -2) {
                        int n13 = treeData.getItemId(n12);
                        this.recursiveExpand(treeData, n13);
                    }
                    bl = true;
                    break;
                }
                case 109: {
                    if (n != 1 || table.getTreeData() == null) break;
                    TreeData treeData = table.getTreeData();
                    int n14 = table.getFirstSelectedRow();
                    if (n14 != -2) {
                        int n15 = treeData.getItemId(n14);
                        this.recursiveCollapse(treeData, n15);
                    }
                    bl = true;
                    break;
                }
                case 9: {
                    if (!table.isExcelMode()) break;
                    table.setExcelEdit(keyEvent);
                    bl = true;
                    break;
                }
                case 10: {
                    if (table.isExcelMode()) {
                        table.setExcelEdit(keyEvent);
                    } else {
                        this.beginCellEdit(table, null);
                        table.fireActionEvent();
                    }
                    bl = true;
                    break;
                }
                case 33: {
                    if (n == 0 || n3 == 0) {
                        table.vScroll(3);
                    } else if (table.isExcelMode()) {
                        if (table.getFirstRow() != 0) {
                            table.vScroll(3);
                            int n16 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                            table.getSelection().commitSelection(n4, n16, null);
                        }
                    } else {
                        if (table.getFirstSelectedRow() == table.getFirstRow()) {
                            table.vScroll(3);
                        }
                        int n17 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                        table.getSelection().commitSelection(n4, n17, null);
                    }
                    bl = true;
                    break;
                }
                case 34: {
                    if (n == 0 || n3 == 0) {
                        table.vScroll(4);
                    } else if (table.isExcelMode()) {
                        if (table.getLastRow() < table.getData().getHeight() - 1) {
                            table.vScroll(4);
                            int n18 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                            table.getSelection().commitSelection(n4, n18, null);
                        }
                    } else {
                        if (table.getLastSelectedRow() == table.getLastRow()) {
                            table.vScroll(4);
                        }
                        int n19 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                        table.getSelection().commitSelection(n4, n19, null);
                    }
                    bl = true;
                    break;
                }
                case 36: {
                    if (table.isExcelMode()) {
                        if (keyEvent.isShiftDown()) {
                            table.hScroll(-1);
                            boolean bl5 = bl = (keyEvent.getModifiers() & 0xA) == 2;
                            if (bl) {
                                table.vScroll(-1);
                            }
                            if (n != 0 && n3 == 1) {
                                int n20 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                                if (bl) {
                                    table.getSelection().commitSelection(0, 0, n20);
                                } else {
                                    table.getSelection().commitSelection(n4, n20, null);
                                }
                            }
                        } else {
                            int n21 = keyEvent.getModifiers() == 2 ? 0 : table.getActiveCell().y;
                            if (n21 == -1) {
                                n21 = 0;
                            }
                            table.commitEditingCell();
                            table.select(n21, 0);
                            table.scrollToCell(n21, 0);
                        }
                    } else {
                        table.vScroll(-1);
                        if (n != 0 && n3 == 1) {
                            int n22 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                            table.getSelection().commitSelection(n4, n22, null);
                        }
                    }
                    bl = true;
                    break;
                }
                case 35: {
                    table.vScroll(-2);
                    if (n != 0 && n3 == 1) {
                        int n23 = TableUtils.getSelectionModifier(keyEvent.getModifiers());
                        table.getSelection().commitSelection(n4, n23, null);
                    }
                    bl = true;
                    break;
                }
                case 16: 
                case 127: 
                case 144: 
                case 145: 
                case 154: 
                case 155: 
                case 156: {
                    bl = true;
                }
            }
            if (!bl) {
                this.beginCellEdit(table, keyEvent);
            }
        }
    }

    private void beginCellEdit(Table table, KeyEvent keyEvent) {
        Point point = table.getSelection().getAnchor();
        int n = point.x;
        int n2 = point.y;
        if (table.isExcelMode()) {
            point = table.getActiveCell();
            n = point.x;
            n2 = point.y;
        }
        if (n >= 0 && n2 >= 0 && table.getCellStyle(n2, n).isEditable()) {
            Cell cell;
            Point point2 = table.getEditingCell();
            if (point2.x != -2 && (cell = table.getCell(point2.y, point2.x)) != null) {
                cell.commitEdit(point2.y, point2.x);
            }
            if ((cell = table.getCell(n2, n)) != null) {
                if (keyEvent != null && cell instanceof CellText) {
                    ((CellText)cell).beginEdit(n2, n, keyEvent);
                } else {
                    cell.beginEdit(n2, n);
                }
            }
        }
    }

    private void recursiveExpand(TreeData treeData, int n) {
        if (treeData.hasChildren(n)) {
            int[] nArray = treeData.getChildren(n);
            for (int i = 0; i < nArray.length; ++i) {
                this.recursiveExpand(treeData, nArray[i]);
            }
        }
        if (treeData.isBranch(n) && !treeData.isExpanded(n)) {
            treeData.expandItem(n);
        }
    }

    private void recursiveCollapse(TreeData treeData, int n) {
        if (treeData.isBranch(n) && treeData.isExpanded(n)) {
            treeData.collapseItem(n);
        }
        if (treeData.hasChildren(n)) {
            int[] nArray = treeData.getChildren(n);
            for (int i = 0; i < nArray.length; ++i) {
                this.recursiveCollapse(treeData, nArray[i]);
            }
        }
    }

    private void selectParent(Table table, int n) {
        int n2;
        int n3;
        TreeData treeData = table.getTreeData();
        if (n != -2 && treeData != null && (n3 = treeData.getItemId(n)) != -1 && (n2 = treeData.getParent(n3)) != -1) {
            int n4;
            for (n4 = n - 1; n4 >= 0 && treeData.getItemId(n4) != n2; --n4) {
            }
            if (n4 >= 0) {
                table.select(n4, 0);
                table.scrollToCell(n4, 0);
            }
        }
    }

    private void doBasicArrowSelection(Table table, int n, int n2) {
        Point point = new Point();
        int n3 = TableUtils.getSelectionModifier(n2);
        if (table.isExcelMode() && n2 == 0) {
            Point point2 = table.getActiveCell();
            if (point2.x != -2) {
                table.select(point2.y, point2.x);
            }
        }
        table.getSelection().commitSelection(n, n3, point);
        table.scrollToCell(point.y, point.x);
    }

    private void selectFirst(Table table) {
        int n;
        int n2 = table.getData().getWidth();
        if (n2 * (n = table.getData().getHeight()) > 0) {
            table.select(0, 0);
            table.scrollToCell(0, 0);
            table.repaint();
        }
    }

    private void selectLast(Table table) {
        int n;
        int n2 = table.getData().getWidth();
        if (n2 * (n = table.getData().getHeight()) > 0) {
            table.select(n2 - 1, n - 1);
            table.scrollToCell(n2 - 1, n - 1);
            table.repaint();
        }
    }
}

