/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPlugThread
extends Thread {
    private InputStream in;
    private OutputStream out;

    public StreamPlugThread(InputStream inputStream, OutputStream outputStream) {
        this.in = inputStream;
        this.out = outputStream;
    }

    public void run() {
        byte[] byArray = new byte[2048];
        try {
            int n;
            while ((n = this.in.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void plugTogether(InputStream inputStream, OutputStream outputStream) {
        new StreamPlugThread(inputStream, outputStream).start();
    }

    public static void plugTogether(OutputStream outputStream, InputStream inputStream) {
        new StreamPlugThread(inputStream, outputStream).start();
    }

    public static Process userProg(String string) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        StreamPlugThread.plugTogether(System.in, process.getOutputStream());
        StreamPlugThread.plugTogether(System.out, process.getInputStream());
        StreamPlugThread.plugTogether(System.err, process.getErrorStream());
        return process;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            StreamPlugThread.error("usage: StreamPlugThread \"command\"");
        }
        try {
            StreamPlugThread.userProg(stringArray[0]);
        }
        catch (IOException iOException) {
            StreamPlugThread.error("I/O Exception: " + iOException);
        }
    }

    public static void error(String string) {
        System.err.println("StreamPlugThread: " + string);
        System.exit(1);
    }
}

