/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis.
 */
public final class BrowserPreferences
extends Enum<BrowserPreferences> {
    public static final String USER_AGENT_PROPERTY = "jxbrowser.chromium.user-agent";
    public static final String CHROMIUM_DIR_PROPERTY = "jxbrowser.chromium.dir";
    private final Set<String> a;

    private BrowserPreferences() {
        this.a = new LinkedHashSet<String>();
    }

    public static void setChromiumDir(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The chromiumDir parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The chromiumDir string cannot be empty.");
        }
        System.setProperty(CHROMIUM_DIR_PROPERTY, string);
    }

    public static String getChromiumDir() {
        return System.getProperty(CHROMIUM_DIR_PROPERTY, BrowserPreferences.getDefaultChromiumDir());
    }

    public static void setUserAgent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The userAgent parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The userAgent string cannot be empty.");
        }
        System.setProperty(USER_AGENT_PROPERTY, string);
    }

    public static String getUserAgent() {
        return System.getProperty(USER_AGENT_PROPERTY);
    }

    public static String getDefaultChromiumDir() {
        Object object = ChromiumBuild.getStringRepresentation();
        String string = System.getProperty("java.io.tmpdir");
        object = "jxbrowser-chromium-" + (String)object;
        object = new File(string, (String)object);
        return ((File)object).getAbsolutePath();
    }

    public static String getDefaultDataDir() {
        File file = new File(BrowserPreferences.getDefaultChromiumDir(), "data");
        return file.getAbsolutePath();
    }

    public static String getDefaultAcceptLanguage() {
        String string = System.getProperty("user.country");
        String string2 = System.getProperty("user.language");
        string = string2 + '-' + string.toLowerCase();
        return string;
    }

    public static void setChromiumSwitches(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The switches parameter cannot be null.");
        }
        BrowserPreferences.INSTANCE.a.clear();
        Collections.addAll(BrowserPreferences.INSTANCE.a, stringArray);
    }

    public static List<String> getChromiumSwitches() {
        return new ArrayList<String>(BrowserPreferences.INSTANCE.a);
    }
}

