/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ipc.ServerException;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelWriter;
import com.teamdev.jxbrowser.chromium.internal.ipc.a;
import com.teamdev.jxbrowser.chromium.internal.ipc.b;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ServerListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private final int b;
    private final List<ServerListener> c;
    private ServerSocket d;

    public Server(int n2) {
        this.b = n2;
        this.c = new ArrayList<ServerListener>();
    }

    public int getPort() {
        return this.b;
    }

    public void addServerListener(ServerListener serverListener) {
        if (!this.c.contains(serverListener)) {
            this.c.add(serverListener);
        }
    }

    public void removeServerListener(ServerListener serverListener) {
        this.c.remove(serverListener);
    }

    public List<ServerListener> getServerListeners() {
        return new ArrayList<ServerListener>(this.c);
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            this.d = new ServerSocket(this.b, 0, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException iOException) {
            throw new ServerException("Failed to create socket at port: " + this.b, iOException);
        }
        for (ServerListener object3 : this.getServerListeners()) {
            object3.onServerStarted();
        }
        while (true) {
            Object object2;
            try {
                object2 = this.d.accept();
            }
            catch (IOException iOException) {
                if (!this.d.isClosed()) {
                    throw new ServerException("Failed to accept client connection.", iOException);
                }
                for (ServerListener serverListener : this.getServerListeners()) {
                    serverListener.onServerStopped();
                }
                return;
            }
            SocketChannelStream socketChannelStream = new SocketChannelStream((Socket)object2);
            socketChannelStream.addChannelStreamListener(new b(this));
            object2 = new SocketChannelWriter(socketChannelStream);
            SocketChannelReader socketChannelReader = new SocketChannelReader(socketChannelStream);
            socketChannelReader.addChannelListener(new a(this, socketChannelReader, (SocketChannelWriter)object2, socketChannelStream));
            new Thread((Runnable)socketChannelReader, "Socket Reader").start();
            new Thread((Runnable)object2, "Socket Writer").start();
        }
    }

    public boolean isStarted() {
        return this.d != null && !this.d.isClosed();
    }

    public void stop() {
        if (((Server)this).isStarted()) {
            a.info("Stopping Server...");
            try {
                ((Server)this).d.close();
            }
            catch (IOException iOException) {
                throw new ServerException("Failed to close socket connection.", iOException);
            }
            for (ServerListener serverListener : ((Server)this).getServerListeners()) {
                serverListener.onServerStopped();
            }
            a.info("Server is stopped...");
        }
    }

    static /* synthetic */ Logger a() {
        return a;
    }
}

