/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelException;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelStream;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChannelType;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelReader;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketChannelWriter;
import com.teamdev.jxbrowser.chromium.internal.ipc.SocketInfo;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.k;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketChannel
implements Channel {
    private final ChannelStream a;
    private final SocketInfo b;
    private final SocketChannelReader c;
    private final SocketChannelWriter d;

    public SocketChannel(ChannelStream channelStream, SocketInfo socketInfo, SocketChannelReader socketChannelReader, SocketChannelWriter socketChannelWriter) {
        this.a = channelStream;
        this.b = socketInfo;
        this.c = socketChannelReader;
        this.d = socketChannelWriter;
    }

    @Override
    public long getChannelId() {
        return this.b.getChannelId();
    }

    @Override
    public long getBrowserId() {
        return this.b.getBrowserId();
    }

    @Override
    public boolean isClosed() {
        return this.a.isClosed();
    }

    @Override
    public ChannelType getType() {
        return this.b.getChannelType();
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        this.c.addChannelListener(channelListener);
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        this.c.removeChannelListener(channelListener);
    }

    @Override
    public List<ChannelListener> getChannelListeners() {
        return this.c.getChannelListeners();
    }

    @Override
    public void send(Message message) {
        this.d.write(message);
    }

    @Override
    public <T extends Message> T post(T t2) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference atomicReference = new AtomicReference();
        k k2 = new k(this, t2, atomicReference, countDownLatch);
        this.addChannelListener(k2);
        try {
            this.send(t2);
            LatchUtil.await(countDownLatch, new ChannelException("Failed to send message.", new TimeoutException()));
        }
        finally {
            this.removeChannelListener(k2);
        }
        return (T)((Message)atomicReference.get());
    }

    public String toString() {
        return "SocketChannel{cid=" + this.b.getChannelId() + ", bid=" + this.b.getBrowserId() + ", type=" + (Object)((Object)this.b.getChannelType()) + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class a<T extends Message>
    implements ChannelListener {
        private final Message a;

        protected a(Message message) {
            this.a = message;
        }

        @Override
        public final void onMessageReceived(Message message) {
            boolean bl;
            boolean bl2 = this.a.getUID() == message.getUID();
            boolean bl3 = bl = this.a.getType() == message.getType();
            if (bl2 && bl) {
                this.a(message);
            }
        }

        public abstract void a(T var1);
    }
}

