/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.rmi;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class RMIRegistryManager {
    private static final Logger logger = Logger.getLogger(RMIRegistryManager.class.getName());
    private static final Collection<RMIRegistryManager> coll = new ArrayList<RMIRegistryManager>();
    private static final int MAX_RETRIES = 10;
    protected int port;
    protected String host;
    protected Registry registry;
    protected Process registryProcess;
    protected int procStartSleepTime = 2000;

    public RMIRegistryManager() {
        coll.add(this);
    }

    public RMIRegistryManager(String host, int port) {
        this.host = host;
        this.port = port;
        coll.add(this);
    }

    public synchronized Registry getOrCreateRMIRegistry() {
        block6: {
            try {
                if (this.getValidatedRegistry() != null) {
                    return this.registry;
                }
                if (!this.host.equals("localhost")) break block6;
                Runtime runtime = Runtime.getRuntime();
                String[] environment = new String[]{"CLASSPATH=\"" + System.getProperty("java.class.path") + "\""};
                this.registryProcess = runtime.exec("rmiregistry " + this.port, environment);
                runtime.addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (RMIRegistryManager.this.registryProcess != null) {
                            RMIRegistryManager.this.registryProcess.destroy();
                        }
                    }
                }));
                for (int retries = 0; this.registry == null && retries <= 10; ++retries) {
                    try {
                        Thread.sleep(this.procStartSleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    logger.info("Locating RMI registry; retries=" + retries);
                    this.getValidatedRegistry();
                }
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Something bad happened in getOrCreateRegistry(): ", e2);
            }
        }
        return this.registry;
    }

    public synchronized void shutDownRMIRegistry() {
        if (this.registryProcess != null) {
            this.registryProcess.destroy();
        }
    }

    protected void finalize() {
        this.shutDownRMIRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Collection<RMIRegistryManager> collection = coll;
        synchronized (collection) {
            logger.log(Level.FINE, "RMIRegistryManager collection size: " + coll.size());
            for (RMIRegistryManager rm : coll) {
                rm.shutDownRMIRegistry();
            }
        }
    }

    public Registry getValidatedRegistry() throws RemoteException {
        if (this.registry != null) {
            return this.registry;
        }
        try {
            this.registry = LocateRegistry.getRegistry(this.host, this.port);
        }
        catch (RemoteException rme) {
            logger.log(Level.SEVERE, "Remote reference to registry at: " + this.host + ":" + this.port + " could not be created...");
            logger.log(Level.SEVERE, "probably related to a SecurityManager setting.");
        }
        try {
            this.registry.list();
        }
        catch (AccessException ae) {
            logger.log(Level.SEVERE, "Couldn't access the RMI Registry " + ae);
            this.registry = null;
        }
        catch (RemoteException rme) {
            this.registry = null;
        }
        return this.registry;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Process getRegistryProcess() {
        return this.registryProcess;
    }

    public int getProcStartSleepTime() {
        return this.procStartSleepTime;
    }

    public void setProcStartSleepTime(int procStartSleepTime) {
        this.procStartSleepTime = procStartSleepTime;
    }
}

