/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.transport.rmi;

import com.mathworks.matlabserver.common.transport.rmi.RMIRegistryManagerExtended;
import com.mathworks.matlabserver.common.transport.rmi.RMIServerEndpoint;
import com.mathworks.matlabserver.common.transport.rmi.RMIServerManager;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIServerManagerImpl
implements RMIServerManager {
    private static final Logger logger = Logger.getLogger(RMIServerManagerImpl.class.getName());
    private RMIRegistryManagerExtended rmiRegistryManager;
    private RMIServerEndpoint rmiServerEndpoint;
    private static final int MAX_PORT_CONFLICTS = 10;

    public RMIServerManagerImpl() {
    }

    public RMIServerManagerImpl(int registryPort, RMIServerEndpoint rmiServerEndpoint) {
        this.setupServer("localhost", registryPort, rmiServerEndpoint);
    }

    public RMIServerManagerImpl(String registryHostName, int registryPort, RMIServerEndpoint rmiServerEndpoint) {
        this.setupServer(registryHostName, registryPort, rmiServerEndpoint);
    }

    @Override
    public void setupServer(String registryHost, int registryPort, RMIServerEndpoint rmiServerEndpoint) {
        this.rmiServerEndpoint = rmiServerEndpoint;
        this.rmiServerEndpoint = rmiServerEndpoint;
        this.rmiRegistryManager = RMIRegistryManagerExtended.getRMIRegistryManagerForHost(registryHost, registryPort);
    }

    @Override
    public void startServer() {
        this.rmiRegistryManager.getRMIRegistry();
        Registry registry = this.rmiRegistryManager.getRMIRegistry();
        int port = this.rmiServerEndpoint.getRemoteObjPort();
        boolean succeeded = false;
        while (port < this.rmiServerEndpoint.getRemoteObjPort() + 10 && !succeeded) {
            try {
                UnicastRemoteObject.exportObject(this.rmiServerEndpoint.getRemoteObj(), port);
                registry.rebind(this.rmiServerEndpoint.getLookupName(), this.rmiServerEndpoint.getRemoteObj());
                succeeded = true;
            }
            catch (Exception e2) {
                if (e2 instanceof ClassCastException) {
                    logger.log(Level.SEVERE, " >>> Failed to reserve port: received a class cast exception: " + e2);
                } else {
                    logger.log(Level.INFO, " >>> Failed to reserve port: " + port);
                }
                ++port;
            }
        }
        if (succeeded) {
            logger.log(Level.INFO, " >>> Made a new server");
        } else {
            logger.log(Level.SEVERE, " >>> FAILED to create a new server, max port conflicts reached.");
        }
        if (!this.rmiRegistryManager.isValidRegistry()) {
            logger.warning("RMI registry may not be valid on host " + this.rmiRegistryManager.getCanonicalHostName() + " at port " + this.rmiRegistryManager.getPort());
        }
    }

    @Override
    public void stopServer() {
        Registry registry = this.rmiRegistryManager.getRMIRegistry();
        try {
            registry.unbind(this.rmiServerEndpoint.getLookupName());
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, e2.getMessage(), e2);
        }
    }

    protected RMIRegistryManagerExtended getRmiRegistryManager() {
        return this.rmiRegistryManager;
    }
}

