/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.messaging.client;

import com.mathworks.matlabserver.jsonconverter.JsonConverterService;
import com.mathworks.matlabserver.jsonconverter.JsonRequestPayload;
import com.mathworks.matlabserver.webappcommon.comet.CometStrictAuthorizerImpl;
import com.mathworks.matlabserver.webappcommon.comet.CometStrictSecurityPolicy;
import com.mathworks.matlabserver.webappcommon.comet.CommonCometDispatchServiceImpl;
import com.mathworks.matlabserver.webappcommon.dispatcher.AuthorizationValidator;
import com.mathworks.matlabserver.webappcommon.dispatcher.Dispatcher;
import com.mathworks.matlabserver.workercommon.client.ClientServiceRegistryFactory;
import java.util.logging.Logger;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;

public class ConnectorCometDispatchService
extends CommonCometDispatchServiceImpl {
    public static final String NAME = "ConnectorCometDispatchService";
    private static final Logger logger = Logger.getLogger(ConnectorCometDispatchService.class.getName());

    public ConnectorCometDispatchService(BayeuxServer bayeux, JsonConverterService jsonConverter, Dispatcher dispatcher, String serviceId) {
        super(bayeux, jsonConverter, dispatcher, serviceId);
        ConnectorAuthorizationValidator connectorValidator = new ConnectorAuthorizationValidator();
        bayeux.setSecurityPolicy(new CometStrictSecurityPolicy(connectorValidator, this.getBayeux()));
        bayeux.createIfAbsent("/**", new ConfigurableServerChannel.Initializer[0]);
        ServerChannel peerModelChannels = bayeux.getChannel("/**");
        peerModelChannels.addAuthorizer(new CometStrictAuthorizerImpl(connectorValidator, this.getBayeux()));
        logger.info("Security Policy has been started and Authorizer is inspecting all activity");
    }

    public static ConnectorCometDispatchService getService() {
        return (ConnectorCometDispatchService)ClientServiceRegistryFactory.getClientServiceRegistry().getService(NAME);
    }

    private class ConnectorAuthorizationValidator
    implements AuthorizationValidator {
        private ConnectorAuthorizationValidator() {
        }

        public boolean isRequestAuthorized(JsonRequestPayload requestPayload) {
            return true;
        }

        public boolean isRequestAuthorized(String requestToken) {
            return true;
        }

        public void endComputeSession() {
        }
    }
}

