/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.servlet;

import com.mathworks.matlabserver.common.util.CalledFromMATLAB;
import com.mathworks.matlabserver.connectorcommon.embeddedwebserver.WebServerConfig;
import com.mathworks.matlabserver.connectorcommon.util.FileExtensionFilterHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class AddOnsServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(AddOnsServlet.class.getName());
    private final FileExtensionFilterHelper fileExtensionFilterHelper = new FileExtensionFilterHelper(WebServerConfig.getFileExtensionWhiteList());
    private static Map<String, String> pathMap = new HashMap<String, String>();
    private static Map<String, Boolean> enableCacheMap = new HashMap<String, Boolean>();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        if (uri.endsWith("/") | this.fileExtensionFilterHelper.isAllowed(uri)) {
            this.handleRequest(request, response);
        } else {
            response.setStatus(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = null;
        try {
            String pathInfo = request.getPathInfo();
            String[] pathSplits = pathInfo.split("/", 3);
            String filePath = pathMap.get(pathSplits[1]);
            String addressToGo = filePath + FilenameUtils.separatorsToSystem(pathSplits[2]);
            File file = null;
            FileInputStream fis = null;
            try {
                file = new File(addressToGo);
                if (file.isDirectory()) {
                    file = new File(addressToGo + "index.html");
                }
                fis = new FileInputStream(file);
            }
            catch (IOException e2) {
                response.setStatus(404);
            }
            if (fis != null) {
                out = response.getOutputStream();
                IOUtils.copy((InputStream)fis, (OutputStream)out);
                fis.close();
                response.setContentLength((int)file.length());
            } else {
                response.setStatus(404);
            }
            String mimeType = this.getServletContext().getMimeType(file.getName());
            response.setContentType(mimeType);
            int THIRTY_DAYS = 2592000;
            if (enableCacheMap.get(pathSplits[1]).booleanValue()) {
                response.setHeader("Cache-Control", "max-age=" + THIRTY_DAYS);
            } else {
                response.setHeader("Cache-Control", "no-cache");
            }
            IOUtils.closeQuietly(out);
        }
        catch (IOException e3) {
            logger.info(e3.getMessage());
            response.setStatus(404);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    @CalledFromMATLAB
    public static void addToPathForSessionOnly(String webPath, String filePath, boolean cacheEnabled) {
        char lastChar = filePath.charAt(filePath.length() - 1);
        if (!Character.toString(lastChar).equals(File.separator)) {
            filePath = filePath + File.separator;
        }
        pathMap.put(webPath, filePath);
        enableCacheMap.put(webPath, cacheEnabled);
    }

    static String getPathMap(String webPath) {
        return pathMap.get(webPath);
    }

    static Boolean getEnableCacheMap(String webPath) {
        return enableCacheMap.get(webPath);
    }
}

