/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.editordataservice;

import com.mathworks.matlabserver.editordataservice.EditorFeature;
import com.mathworks.matlabserver.editordataservice.EditorNode;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import java.lang.reflect.Constructor;
import java.util.Map;

public class EditorNodeUtilities {
    public static final String FEATURE_REGISTRATION_EVENT_ID = "registerFeature";
    public static final String DOCUMENT_CHANGED_EVENT_ID = "documentChanged";

    private EditorNodeUtilities() {
    }

    static boolean isFeatureRegisterEvent(Event event) {
        return FEATURE_REGISTRATION_EVENT_ID.equals(event.getData().get("type"));
    }

    static boolean isDocumentChanged(Event event) {
        return DOCUMENT_CHANGED_EVENT_ID.equals(event.getData().get("type"));
    }

    static String getFeatureIdFromEvent(Event event) {
        return (String)event.getData().get("feature-id");
    }

    static String getDocumentTextFromEvent(Event event) {
        return (String)event.getData().get("data");
    }

    static String getUniqueIdFromNode(PeerNode child) {
        Map map = (Map)child.getProperty("backingStore");
        return (String)map.get("uniqueId");
    }

    public static EditorFeature constructEditorFeatureInstance(EditorNode node, String className) throws Exception {
        Class[] constructorSignature = new Class[]{EditorNode.class};
        Class<?> classDefinition = Class.forName(className);
        Constructor<?> constructor = classDefinition.getConstructor(constructorSignature);
        Object[] arguments = new Object[]{node};
        return (EditorFeature)constructor.newInstance(arguments);
    }
}

