/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.compute.ComputeTokenDO;
import com.mathworks.matlabserver.internalservices.faults.FaultUtils;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.CloseFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.CloseFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.CreateFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.CreateFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.DeleteFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.DeleteFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.DeleteMultipleFilesRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.DeleteMultipleFilesResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.DisplayVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.DisplayVersionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileMessageService;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.ListVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.ListVersionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.MoveMultipleFilesResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenOrCreateFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.OpenOrCreateFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.ReadFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.ReadFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.RenameFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.RenameFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.SetActiveVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.SetActiveVersionResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.UpdateFileRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.UpdateFileResponseMessageDO;
import com.mathworks.matlabserver.internalservices.file.VersionService;
import com.mathworks.matlabserver.internalservices.message.MLSResponseMessage;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileMessageServiceImpl
implements FileMessageService {
    private static final Logger logger = Logger.getLogger(FileMessageServiceImpl.class.getName());

    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, MessageContainerDO messageContainer) {
        try {
            RegistryService serviceRegistry = ServiceRegistryFactory.getServiceRegistry();
            FileService fileService = (FileService)serviceRegistry.getService(FileService.class);
            VersionService versionService = (VersionService)serviceRegistry.getService(VersionService.class);
            this.handleOpenOrCreateFile(fileService, userToken, messageContainer);
            this.handleOpenFile(fileService, userToken, messageContainer);
            this.handleCreateFile(fileService, userToken, messageContainer);
            this.handleReadFile(fileService, userToken, messageContainer);
            this.handleUpdateFile(fileService, userToken, messageContainer);
            this.handleDeleteFile(fileService, userToken, messageContainer);
            this.handleDeleteMultipleFiles(fileService, userToken, messageContainer);
            this.handleMoveMultipleFiles(fileService, userToken, messageContainer);
            this.handleRenameFiles(fileService, userToken, messageContainer);
            this.handleCloseFiles(fileService, userToken, messageContainer);
            this.handleFileVersioning(fileService, versionService, userToken, messageContainer);
        }
        catch (MLSException mlse) {
            logger.log(Level.INFO, "MLSException bubbling up... " + mlse);
            throw mlse;
        }
        catch (Exception e2) {
            throw new MLSException(e2);
        }
        return messageContainer;
    }

    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, ComputeTokenDO computeToken, MessageContainerDO messageContainer) {
        return this.sendMessages(userToken, messageContainer);
    }

    private void setResponseFault(MLSResponseMessage response, MLSException exception) {
        logger.log(Level.WARNING, exception.getMessage(), exception);
        response.setFault(FaultUtils.convert(exception));
    }

    private void handleOpenOrCreateFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<OpenOrCreateFileRequestMessageDO> openOrCreateList = messageContainer.getMessages(OpenOrCreateFileRequestMessageDO.class);
        for (OpenOrCreateFileRequestMessageDO openOrCreateFile : openOrCreateList) {
            if (openOrCreateFile == null || openOrCreateFile.getFileInfo() == null) continue;
            messageContainer.consumeMessage(OpenOrCreateFileRequestMessageDO.class);
            OpenOrCreateFileResponseMessageDO openOrCreateFileResponse = new OpenOrCreateFileResponseMessageDO();
            openOrCreateFileResponse.setUuid(openOrCreateFile.getUuid());
            FileDO file = null;
            try {
                file = fileService.open(userToken, openOrCreateFile.getFileInfo());
            }
            catch (MLSException openException) {
                if (openException.getFaultCode().equals("FileService.IOError")) {
                    file = new FileDO();
                    file.setFileInfo(openOrCreateFile.getFileInfo());
                    file.setContent("");
                    try {
                        FileInfoDO fileInfo = fileService.create(userToken, file);
                        file.setFileInfo(fileInfo);
                    }
                    catch (MLSException createException) {
                        this.setResponseFault(openOrCreateFileResponse, createException);
                    }
                }
                this.setResponseFault(openOrCreateFileResponse, openException);
            }
            openOrCreateFileResponse.setFile(file);
            messageContainer.addMessage(OpenOrCreateFileResponseMessageDO.class, openOrCreateFileResponse);
        }
    }

    private void handleOpenFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<OpenFileRequestMessageDO> openList = messageContainer.getMessages(OpenFileRequestMessageDO.class);
        for (OpenFileRequestMessageDO openFile : openList) {
            if (openFile == null || openFile.getFileInfo() == null) continue;
            messageContainer.consumeMessage(OpenFileRequestMessageDO.class);
            OpenFileResponseMessageDO openFileResponse = new OpenFileResponseMessageDO();
            openFileResponse.setUuid(openFile.getUuid());
            try {
                FileDO file = fileService.open(userToken, openFile.getFileInfo());
                openFileResponse.setFile(file);
            }
            catch (MLSException e2) {
                this.setResponseFault(openFileResponse, e2);
            }
            messageContainer.addMessage(OpenFileResponseMessageDO.class, openFileResponse);
        }
    }

    private void handleCreateFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<CreateFileRequestMessageDO> openList = messageContainer.getMessages(CreateFileRequestMessageDO.class);
        for (CreateFileRequestMessageDO createFile : openList) {
            if (createFile == null || createFile.getFile() == null) continue;
            messageContainer.consumeMessage(CreateFileRequestMessageDO.class);
            CreateFileResponseMessageDO createFileResponse = new CreateFileResponseMessageDO();
            createFileResponse.setUuid(createFile.getUuid());
            try {
                FileDO file = createFile.getFile();
                FileInfoDO fileInfo = createFile.isUpdateIfExists() && fileService.exists(userToken, file.getFileInfo()) ? fileService.update(userToken, file) : fileService.create(userToken, file);
                createFileResponse.setFileInfo(fileInfo);
            }
            catch (MLSException e2) {
                this.setResponseFault(createFileResponse, e2);
            }
            messageContainer.addMessage(CreateFileResponseMessageDO.class, createFileResponse);
        }
    }

    private void handleReadFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<ReadFileRequestMessageDO> readList = messageContainer.getMessages(ReadFileRequestMessageDO.class);
        for (ReadFileRequestMessageDO readFile : readList) {
            if (readFile == null || readFile.getFileInfo() == null) continue;
            messageContainer.consumeMessage(ReadFileRequestMessageDO.class);
            ReadFileResponseMessageDO readFileResponse = new ReadFileResponseMessageDO();
            readFileResponse.setUuid(readFile.getUuid());
            try {
                FileDO file = fileService.read(userToken, readFile.getFileInfo());
                readFileResponse.setFile(file);
            }
            catch (MLSException e2) {
                this.setResponseFault(readFileResponse, e2);
            }
            messageContainer.addMessage(ReadFileResponseMessageDO.class, readFileResponse);
        }
    }

    private void handleUpdateFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<UpdateFileRequestMessageDO> updateList = messageContainer.getMessages(UpdateFileRequestMessageDO.class);
        for (UpdateFileRequestMessageDO updateFile : updateList) {
            if (updateFile == null || updateFile.getFile() == null) continue;
            messageContainer.consumeMessage(UpdateFileRequestMessageDO.class);
            UpdateFileResponseMessageDO updateFileResponse = new UpdateFileResponseMessageDO();
            updateFileResponse.setUuid(updateFile.getUuid());
            try {
                FileDO file = updateFile.getFile();
                FileInfoDO fileInfo = fileService.update(userToken, file);
                updateFileResponse.setFileInfo(fileInfo);
            }
            catch (MLSException e2) {
                this.setResponseFault(updateFileResponse, e2);
            }
            messageContainer.addMessage(UpdateFileResponseMessageDO.class, updateFileResponse);
        }
    }

    private void handleDeleteFile(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<DeleteFileRequestMessageDO> deleteList = messageContainer.getMessages(DeleteFileRequestMessageDO.class);
        for (DeleteFileRequestMessageDO deleteFile : deleteList) {
            if (deleteFile == null || deleteFile.getFileInfo() == null) continue;
            messageContainer.consumeMessage(DeleteFileRequestMessageDO.class);
            DeleteFileResponseMessageDO deleteFileResponse = new DeleteFileResponseMessageDO();
            deleteFileResponse.setUuid(deleteFile.getUuid());
            try {
                FileInfoDO fileInfo = deleteFile.getFileInfo();
                FileInfoDO fileInfoReturn = fileService.delete(userToken, fileInfo);
                deleteFileResponse.setFileInfo(fileInfoReturn);
            }
            catch (MLSException e2) {
                this.setResponseFault(deleteFileResponse, e2);
            }
            messageContainer.addMessage(DeleteFileResponseMessageDO.class, deleteFileResponse);
        }
    }

    private void handleDeleteMultipleFiles(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        DeleteMultipleFilesRequestMessageDO deleteMultipleFiles = messageContainer.getMessage(DeleteMultipleFilesRequestMessageDO.class);
        if (deleteMultipleFiles != null && deleteMultipleFiles.getFileInfoArray() != null && deleteMultipleFiles.getFileInfoArray().length > 0) {
            messageContainer.consumeMessage(DeleteMultipleFilesRequestMessageDO.class);
            DeleteMultipleFilesResponseMessageDO deleteMultipleFileResponse = new DeleteMultipleFilesResponseMessageDO();
            deleteMultipleFileResponse.setUuid(deleteMultipleFiles.getUuid());
            try {
                FileInfoDO[] fileInfoReturnArray = fileService.delete(userToken, deleteMultipleFiles.getFileInfoArray());
                deleteMultipleFileResponse.setFileInfoArray(fileInfoReturnArray);
            }
            catch (MLSException e2) {
                this.setResponseFault(deleteMultipleFileResponse, e2);
            }
            messageContainer.addMessage(DeleteMultipleFilesResponseMessageDO.class, deleteMultipleFileResponse);
        }
    }

    private void handleMoveMultipleFiles(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<MoveMultipleFilesRequestMessageDO> moveList = messageContainer.getMessages(MoveMultipleFilesRequestMessageDO.class);
        for (MoveMultipleFilesRequestMessageDO moveMultipleFiles : moveList) {
            if (moveMultipleFiles == null || moveMultipleFiles.getFileInfoArray() == null || moveMultipleFiles.getFileInfoArray().length <= 0) continue;
            messageContainer.consumeMessage(MoveMultipleFilesRequestMessageDO.class);
            MoveMultipleFilesResponseMessageDO moveMultipleFilesResponseMessage = new MoveMultipleFilesResponseMessageDO();
            moveMultipleFilesResponseMessage.setUuid(moveMultipleFiles.getUuid());
            try {
                FileInfoDO[] fileInfoResponse = fileService.move(userToken, moveMultipleFiles.getFileInfoArray(), moveMultipleFiles.getDestDir());
                moveMultipleFilesResponseMessage.setFileInfoArray(fileInfoResponse);
                moveMultipleFilesResponseMessage.setSrcFileInfoArray(moveMultipleFiles.getFileInfoArray());
                moveMultipleFilesResponseMessage.setUuid(moveMultipleFiles.getUuid());
            }
            catch (MLSException e2) {
                this.setResponseFault(moveMultipleFilesResponseMessage, e2);
            }
            messageContainer.addMessage(MoveMultipleFilesResponseMessageDO.class, moveMultipleFilesResponseMessage);
        }
    }

    private void handleRenameFiles(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<RenameFileRequestMessageDO> renameList = messageContainer.getMessages(RenameFileRequestMessageDO.class);
        for (RenameFileRequestMessageDO renameFile : renameList) {
            if (renameFile == null || renameFile.getNewFileInfo() == null || renameFile.getOriginalFileInfo() == null) continue;
            messageContainer.consumeMessage(RenameFileRequestMessageDO.class);
            RenameFileResponseMessageDO renameFileResponse = new RenameFileResponseMessageDO();
            renameFileResponse.setUuid(renameFile.getUuid());
            try {
                FileInfoDO newFileInfo = fileService.rename(userToken, renameFile.getOriginalFileInfo(), renameFile.getNewFileInfo());
                renameFileResponse.setNewFileInfo(newFileInfo);
            }
            catch (MLSException e2) {
                this.setResponseFault(renameFileResponse, e2);
            }
            messageContainer.addMessage(RenameFileResponseMessageDO.class, renameFileResponse);
        }
    }

    private void handleCloseFiles(FileService fileService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        List<CloseFileRequestMessageDO> closeList = messageContainer.getMessages(CloseFileRequestMessageDO.class);
        for (CloseFileRequestMessageDO closeFile : closeList) {
            if (closeFile == null || closeFile.getFile() == null) continue;
            messageContainer.consumeMessage(CloseFileRequestMessageDO.class);
            CloseFileResponseMessageDO closeFileResponse = new CloseFileResponseMessageDO();
            closeFileResponse.setUuid(closeFile.getUuid());
            try {
                FileDO file = closeFile.getFile();
                FileInfoDO fileInfo = file.getFileInfo();
                if (closeFile.isUpdateFile().booleanValue()) {
                    fileInfo = fileService.update(userToken, file);
                }
                fileInfo = fileService.close(userToken, fileInfo);
                closeFileResponse.setFileInfo(fileInfo);
            }
            catch (MLSException e2) {
                this.setResponseFault(closeFileResponse, e2);
            }
            messageContainer.addMessage(CloseFileResponseMessageDO.class, closeFileResponse);
        }
    }

    private void handleFileVersioning(FileService fileService, VersionService versionService, UserTokenDO userToken, MessageContainerDO messageContainer) {
        DisplayVersionRequestMessageDO displayVersionRequest;
        FileDO file;
        SetActiveVersionRequestMessageDO setActiveVersionRequest;
        ListVersionRequestMessageDO listVersionRequest = messageContainer.getMessage(ListVersionRequestMessageDO.class);
        if (listVersionRequest != null && listVersionRequest.getFileInfo() != null) {
            messageContainer.consumeMessage(ListVersionRequestMessageDO.class);
            ListVersionResponseMessageDO listVersionResponse = new ListVersionResponseMessageDO();
            listVersionResponse.setUuid(listVersionRequest.getUuid());
            try {
                FileInfoDO fileInfo = listVersionRequest.getFileInfo();
                FileInfoDO[] versions = versionService.getVersionHistory(userToken, fileInfo);
                listVersionResponse.setFileInfoList(versions);
            }
            catch (MLSException e2) {
                this.setResponseFault(listVersionResponse, e2);
            }
            messageContainer.addMessage(ListVersionResponseMessageDO.class, listVersionResponse);
        }
        if ((setActiveVersionRequest = messageContainer.getMessage(SetActiveVersionRequestMessageDO.class)) != null && setActiveVersionRequest.getFileInfo() != null) {
            messageContainer.consumeMessage(SetActiveVersionRequestMessageDO.class);
            SetActiveVersionResponseMessageDO setActiveVersionResponse = new SetActiveVersionResponseMessageDO();
            setActiveVersionResponse.setUuid(setActiveVersionRequest.getUuid());
            try {
                FileInfoDO fileInfo = setActiveVersionRequest.getFileInfo();
                FileInfoDO response = versionService.restoreVersion(userToken, fileInfo);
                file = fileService.read(userToken, response);
                setActiveVersionResponse.setFile(file);
            }
            catch (MLSException e3) {
                this.setResponseFault(setActiveVersionResponse, e3);
            }
            messageContainer.addMessage(SetActiveVersionResponseMessageDO.class, setActiveVersionResponse);
        }
        if ((displayVersionRequest = messageContainer.getMessage(DisplayVersionRequestMessageDO.class)) != null && displayVersionRequest.getFileInfo() != null) {
            messageContainer.consumeMessage(DisplayVersionRequestMessageDO.class);
            DisplayVersionResponseMessageDO displayVersionResponse = new DisplayVersionResponseMessageDO();
            displayVersionResponse.setUuid(displayVersionRequest.getUuid());
            try {
                FileInfoDO fileInfo = displayVersionRequest.getFileInfo();
                file = versionService.readVersion(userToken, fileInfo);
                displayVersionResponse.setFile(file);
            }
            catch (MLSException e4) {
                this.setResponseFault(displayVersionResponse, e4);
            }
            messageContainer.addMessage(DisplayVersionResponseMessageDO.class, displayVersionResponse);
        }
    }
}

