/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.fileservices.policy.MetadataProviderManager;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.fileservices.util.FilenameConverterDirect;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FilePermissionsDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.usagedata.UdcComponentId;
import com.mathworks.matlabserver.internalservices.usagedata.UdcEventType;
import com.mathworks.matlabserver.internalservices.usagedata.UdcService;
import com.mathworks.matlabserver.internalservices.usagedata.UdcServiceNullImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileServiceDirect
implements FileService {
    private static final Logger logger = Logger.getLogger(FileServiceDirect.class.getName());
    private UdcService udcService = new UdcServiceNullImpl();
    protected final MetadataProviderManager metadataProvider;
    protected final FilenameConverter filenameConverter;

    public FileServiceDirect(String mountPoint, String matlabRoot) {
        this(mountPoint);
    }

    public FileServiceDirect(String mountPoint) {
        this.filenameConverter = new FilenameConverterDirect(mountPoint);
        this.metadataProvider = new MetadataProviderManager();
    }

    public FileServiceDirect(FilenameConverter filenameConverter) {
        this.filenameConverter = filenameConverter;
        this.metadataProvider = new MetadataProviderManager();
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, file.getFileInfo());
        File fsFile = new File(fileName);
        if (fsFile.exists()) {
            throw this.createMLSException(file.getFileInfo(), ", could not be written or already exists.");
        }
        if (file.getFileInfo().isDirectory()) {
            if (!fsFile.mkdir()) {
                throw this.createMLSException(file.getFileInfo(), ", could not be written or already exists.");
            }
        } else {
            try {
                FileUtils.writeByteArrayToFile(fsFile, file.getData());
            }
            catch (IOException ioe) {
                throw this.createMLSException(file.getFileInfo(), "Error writing data for create to file", ioe);
            }
        }
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_CREATE.toString(), file.getFileInfo().getName());
        FileInfoDO fileInfoResult = file.getFileInfo();
        this.addMetadata(fileInfoResult);
        return fileInfoResult;
    }

    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileInfoDO newFileInfo = this.readInfo(userToken, fileInfo);
        FileDO result = new FileDO(newFileInfo);
        String fileName = this.prepareFileInfo(userToken, newFileInfo);
        try {
            File file = new File(fileName);
            byte[] fileContent = FileUtils.readFileToByteArray(file);
            result.setData(fileContent);
            FilePermissionsDO permissions = new FilePermissionsDO();
            permissions.setCanWrite(file.canWrite());
            fileInfo.setFilePermissions(permissions);
        }
        catch (IOException ioe) {
            throw this.createMLSException(fileInfo, ioe);
        }
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_READ.toString(), newFileInfo.getName());
        this.addMetadata(result.getFileInfo());
        return result;
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, file.getFileInfo());
        File testFile = new File(fileName);
        if (testFile.exists()) {
            try {
                FileUtils.writeByteArrayToFile(testFile, file.getData());
            }
            catch (IOException e2) {
                throw this.createMLSException(file.getFileInfo(), e2);
            }
        } else {
            throw this.createMLSException(file.getFileInfo(), "Unable to update a file which does not exist");
        }
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_UPDATE.toString(), file.getFileInfo().getName());
        FileInfoDO fileInfoResult = file.getFileInfo();
        this.addMetadata(fileInfoResult);
        return fileInfoResult;
    }

    @Override
    public FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        fileInfo.setDeleted(true);
        File file = new File(fileName);
        if (!FileUtils.deleteQuietly(file)) {
            throw this.createMLSException(fileInfo, ", Unable to delete(s)");
        }
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_DELETE.toString(), fileInfo.getName());
        this.addMetadata(fileInfo);
        return fileInfo;
    }

    @Override
    public FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        if (userToken == null || fileInfoArray == null || fileInfoArray.length <= 0) {
            throw new MLSException("FileService.IOError", "Illegal Arguments");
        }
        for (FileInfoDO fileDO : fileInfoArray) {
            if (fileDO == null) continue;
            String fileName = this.prepareFileInfo(userToken, fileDO);
            File file = new File(fileName);
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException e2) {
                throw this.createMLSException(fileDO, ", Unable to delete(s)", e2);
            }
            this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_DELETE.toString(), fileName);
            fileDO.setDeleted(true);
        }
        this.addMetadata(fileInfoArray);
        return fileInfoArray;
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        if (userToken == null || sourceFileInfoArray == null || sourceFileInfoArray.length <= 0 || destinationFileInfo == null) {
            throw this.createMLSException(destinationFileInfo, "Illegal Arguments");
        }
        String rootPath = this.prepareFileInfo(userToken, new FileInfoDO(""));
        String destFileName = this.prepareFileInfo(userToken, destinationFileInfo);
        File destFile = new File(destFileName);
        if (destFile.isDirectory()) {
            try {
                for (FileInfoDO fileDO : sourceFileInfoArray) {
                    if (fileDO == null) continue;
                    String srcFileName = this.prepareFileInfo(userToken, fileDO);
                    if (!srcFileName.equals(destFileName) && !srcFileName.equals(rootPath)) {
                        File srcFile = new File(srcFileName);
                        if (srcFile.isDirectory()) {
                            this.moveDirectoryToDirectory(srcFile, destFile);
                        } else {
                            this.moveFileToDirectory(srcFile, destFile);
                        }
                        fileDO.setLocation(this.filenameConverter.convertFilenameFromServerToWorker(userToken, destFile.getCanonicalPath()));
                        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_MOVE.toString(), "MV FROM:" + srcFileName + " TO:" + destFileName);
                        continue;
                    }
                    throw this.createMLSException(destinationFileInfo, ", unable to move file(s)");
                }
            }
            catch (IOException ioe) {
                throw this.createMLSException(destinationFileInfo, ", unable to move file(s)", ioe);
            }
        } else {
            throw this.createMLSException(destinationFileInfo, "directory invalid");
        }
        this.addMetadata(sourceFileInfoArray);
        return sourceFileInfoArray;
    }

    @Override
    public FileInfoDO rename(UserTokenDO userToken, FileInfoDO originalFileInfo, FileInfoDO newFileInfo) throws MLSException {
        if (userToken == null || originalFileInfo == null || newFileInfo == null) {
            throw this.createMLSException(originalFileInfo, "Illegal Arguments");
        }
        String originalFileName = this.prepareFileInfo(userToken, originalFileInfo);
        String destFileName = this.prepareFileInfo(userToken, newFileInfo);
        String rootPath = this.prepareFileInfo(userToken, new FileInfoDO(""));
        File originalFile = new File(originalFileName);
        File destFile = new File(destFileName);
        if (!originalFile.equals(destFileName) && !originalFileName.equals(rootPath)) {
            if (originalFile.isDirectory()) {
                newFileInfo.setDirectory(true);
                try {
                    this.moveDirectory(originalFile, destFile);
                }
                catch (IOException e2) {
                    throw this.createMLSException(originalFileInfo, "Error renaming directory: '" + originalFileName + "' to '" + destFileName + "'", e2);
                }
            } else {
                try {
                    this.moveFile(originalFile, destFile);
                }
                catch (IOException e3) {
                    throw this.createMLSException(originalFileInfo, "Error renaming file: '" + originalFileName + "' to '" + destFileName + "'", e3);
                }
            }
        } else {
            throw this.createMLSException(new FileInfoDO(destFileName), ", unable to move file(s)");
        }
        this.addMetadata(newFileInfo);
        return newFileInfo;
    }

    @Override
    public FileInfoDO[] list(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        File dir = new File(fileName);
        if (!dir.exists()) {
            throw this.createMLSException(fileInfo, ", resource not found");
        }
        File[] files = dir.listFiles();
        ArrayList<FileInfoDO> fileInfos = new ArrayList<FileInfoDO>();
        if (files != null) {
            for (File f2 : files) {
                FileInfoDO item = new FileInfoDO();
                item.setName(f2.getName());
                item.setSize(f2.length());
                item.setLocation(this.filenameConverter.convertFilenameFromServerToWorker(userToken, fileName));
                item.setModified(new Date(f2.lastModified()));
                item.setType(FilenameUtils.getExtension(f2.getName()));
                item.setDirectory(f2.isDirectory());
                FilePermissionsDO permissions = new FilePermissionsDO();
                permissions.setCanWrite(f2.canWrite());
                item.setFilePermissions(permissions);
                fileInfos.add(item);
            }
        }
        FileInfoDO[] result = new FileInfoDO[fileInfos.size()];
        result = fileInfos.toArray(result);
        this.addMetadata(result);
        return result;
    }

    @Override
    public FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_CLOSE.toString(), fileInfo.getName());
        this.addMetadata(fileInfo);
        return fileInfo;
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileDO retVal = this.read(userToken, fileInfo);
        this.udcService.recordUsageDataForUser(userToken.getName(), UdcComponentId.FILE_SERVICE.toString(), UdcEventType.FILE_OPEN.toString(), fileInfo.getName());
        return retVal;
    }

    @Override
    public InputStream readContent(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        FileInputStream stream = null;
        try {
            File file = new File(fileName);
            if (file.isFile()) {
                stream = FileUtils.openInputStream(file);
            }
        }
        catch (IOException e2) {
            logger.log(Level.SEVERE, "Error reading the file", e2);
        }
        return stream;
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) {
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        FileInfoDO item = new FileInfoDO(this.filenameConverter.convertFilenameFromServerToWorker(userToken, fileName));
        File file = new File(fileName);
        if (file.exists()) {
            item.setSize(file.length());
            item.setModified(new Date(file.lastModified()));
            item.setType(FilenameUtils.getExtension(file.getName()));
            item.setDirectory(file.isDirectory());
        } else {
            item.setDeleted(true);
        }
        this.addMetadata(item);
        return item;
    }

    @Override
    public FileInfoDO updateInfo(UserTokenDO userToken, FileInfoDO fileInfo) {
        return fileInfo;
    }

    @Override
    public FileInfoDO updateContent(UserTokenDO userToken, FileInfoDO fileInfo, InputStream contents) throws MLSException {
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        File testFile = new File(fileName);
        if (testFile.exists()) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(testFile);
                IOUtils.copy(contents, (OutputStream)out);
            }
            catch (IOException e2) {
                try {
                    throw this.createMLSException(fileInfo, ", Unable to write a file", e2);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(out);
        }
        return fileInfo;
    }

    @Override
    public boolean exists(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        boolean exists;
        String fileName = this.prepareFileInfo(userToken, fileInfo);
        try {
            File file = new File(fileName);
            exists = file.exists();
        }
        catch (Exception e2) {
            throw this.createMLSException(fileInfo, "Error trying to check if the file exists or not.", e2);
        }
        return exists;
    }

    protected String prepareFileInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String filename = this.filenameConverter.getServerFilename(userToken, fileInfo);
        fileInfo.setLocation(this.filenameConverter.convertFilenameFromServerToWorker(userToken, FilenameUtils.getFullPath(filename)));
        fileInfo.setName(FilenameUtils.getName(filename));
        return filename;
    }

    private MLSException createMLSException(FileInfoDO file, Throwable e2) {
        return this.createMLSException(file, e2.getMessage(), e2);
    }

    private MLSException createMLSException(FileInfoDO file, String message) {
        return new MLSException("FileService.IOError", "File: " + file.getLocation() + this.filenameConverter.getWorkerFileSeparator() + file.getName() + ": " + message);
    }

    private MLSException createMLSException(FileInfoDO file, String message, Throwable e2) {
        return new MLSException("FileService.IOError", "File: " + file.getLocation() + this.filenameConverter.getWorkerFileSeparator() + file.getName() + ": " + message, e2);
    }

    @Override
    public String getWorkerMountPoint() {
        return this.filenameConverter.getWorkerMountPoint();
    }

    @Override
    public String getServerMountPoint() {
        return this.filenameConverter.getServerMountPoint();
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        return this.filenameConverter.getServerMountPoint(userToken);
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        return this.filenameConverter.getWorkerMountPoint(userToken);
    }

    public UdcService getUdcService() {
        return this.udcService;
    }

    public void setUdcService(UdcService udcService) {
        this.udcService = udcService;
    }

    protected void moveFile(File originalFile, File destFile) throws IOException {
        FileUtils.moveFile(originalFile, destFile);
    }

    protected void moveDirectory(File originalFile, File destFile) throws IOException {
        FileUtils.moveDirectory(originalFile, destFile);
    }

    protected void moveDirectoryToDirectory(File srcFile, File destFile) throws IOException {
        FileUtils.moveDirectoryToDirectory(srcFile, destFile, false);
    }

    protected void moveFileToDirectory(File srcFile, File destFile) throws IOException {
        FileUtils.moveFileToDirectory(srcFile, destFile, false);
    }

    protected void addMetadata(FileInfoDO sourceFileInfo) {
        boolean forceUpdate = true;
        this.metadataProvider.addMetadata(sourceFileInfo, forceUpdate);
    }

    protected void addMetadata(FileInfoDO[] fileInfoArray) {
        boolean forceUpdate = true;
        this.metadataProvider.addMetadata(fileInfoArray, forceUpdate);
    }
}

