/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.google.common.base.Preconditions;
import com.mathworks.matlabserver.common.fileservice.FilePatternMatcher;
import com.mathworks.matlabserver.fileservices.policy.MetadataProviderManager;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.fileservices.util.FilenameConverterGdsImpl;
import com.mathworks.matlabserver.fileservices.util.FileserviceActionGds;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.FileServiceMessageFaultDO;
import com.mathworks.matlabserver.internalservices.path.PathManager;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.internalservices.workersecurity.UserManager;
import com.mathworks.matlabserver.internalservices.workersecurity.impl.UserManagerImpl;
import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.gds.FileAccess;
import com.mathworks.webservices.gds.GDSClient;
import com.mathworks.webservices.gds.GDSClientImpl;
import com.mathworks.webservices.gds.model.GDSErrorCode;
import com.mathworks.webservices.gds.model.Resource;
import com.mathworks.webservices.gds.model.fileaccess.FileAttributes;
import com.mathworks.webservices.gds.model.fileaccess.FileAttributesReadRequest;
import com.mathworks.webservices.gds.model.fileaccess.FileAttributesReadResponse;
import com.mathworks.webservices.gds.model.fileaccess.FileCreateRequest;
import com.mathworks.webservices.gds.model.fileaccess.FileDeleteRequest;
import com.mathworks.webservices.gds.model.fileaccess.FileReadRequest;
import com.mathworks.webservices.gds.model.fileaccess.FileReadResponse;
import com.mathworks.webservices.gds.model.fileaccess.FileSummary;
import com.mathworks.webservices.gds.model.fileaccess.FileUpdateRequest;
import com.mathworks.webservices.gds.model.fileaccess.FolderCreateRequest;
import com.mathworks.webservices.gds.model.fileaccess.FolderDeleteRequest;
import com.mathworks.webservices.gds.model.fileaccess.FolderListRequest;
import com.mathworks.webservices.gds.model.fileaccess.FolderListResponse;
import com.mathworks.webservices.gds.model.fileaccess.FolderSummary;
import com.mathworks.webservices.gds.model.fileaccess.MoveRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.util.ByteArrayBuffer;

public class FileServiceGdsImpl
implements FileService {
    private static final Logger logger = Logger.getLogger(FileServiceGdsImpl.class.getName());
    private FileserviceActionGds fileActionExecutor;
    FilePatternMatcher filePatternMatcher;
    private FilenameConverter filenameConverter;
    private MetadataProviderManager metadataProvider;
    private PathManager pathManager = null;
    private static final String clientLocale = "en-US";
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool();
    private static final int MAX_FOLDER_DEPTH = 20;
    private static final String CLIENT_NAME = "MOTW";
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static String gdsEndpoint;
    private static ClientConfiguration clientConfig;

    public FileServiceGdsImpl(GDSClientImpl gdsClient, FilenameConverterGdsImpl filenameConverter) {
        this.init(filenameConverter);
    }

    public FileServiceGdsImpl(String gdsEndpoint, FilenameConverterGdsImpl filenameConverter) {
        FileServiceGdsImpl.gdsEndpoint = gdsEndpoint;
        clientConfig = new ClientConfiguration();
        clientConfig.setConnectionTimeout(60000);
        clientConfig.setSocketTimeout(30000);
        this.init(filenameConverter);
    }

    private void init(FilenameConverter filenameConverter) {
        this.filenameConverter = filenameConverter;
        this.metadataProvider = new MetadataProviderManager();
        this.filePatternMatcher = new FilePatternMatcher();
        this.fileActionExecutor = FileserviceActionGds.getInstance();
    }

    public PathManager getPathManager() {
        return this.pathManager;
    }

    public void setPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    private GDSClient fetchGdsClient(ClientConfiguration clientConfig) {
        GDSClientImpl gdsClient = new GDSClientImpl(clientConfig);
        gdsClient.setEndpoint(gdsEndpoint);
        gdsClient.setClientString(CLIENT_NAME);
        gdsClient.setLocale(clientLocale);
        return gdsClient;
    }

    @Override
    public FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        logger.info("Entering create(userToken=" + userToken + ", fileDO=" + file + ")");
        Preconditions.checkArgument(userToken != null, "create() was called with a null token");
        Preconditions.checkArgument(file != null, "create() was called with a null fileDO");
        Preconditions.checkArgument(file.getFileInfo() != null, "create() was called with a null fileInfoDO");
        FileInfoDO returnInfo = null;
        if (this.filePatternMatcher.isSharedFolderOrDescendent(this.getFullPath(file.getFileInfo()))) {
            logger.severe("Received call to create a file under another user's shared location: " + file);
            throw new MLSException("SharingService.GeneralError", "Contents shared by others can not be modified");
        }
        FileInfoDO fileInfo = this.translateFileInfo_clientToGDS(userToken, file.getFileInfo(), false);
        FileDO workFile = new FileDO(fileInfo);
        if (!fileInfo.isDirectory()) {
            workFile.setContent(file.getContent());
            workFile.setData(file.getData());
        }
        logger.info("Calling fileCreateAction for fileDO=" + workFile + ")");
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        FileCreate fileCreateAction = new FileCreate(workFile, gdsClient, userToken);
        returnInfo = this.fileActionExecutor.execute(fileCreateAction);
        logger.info("Returning from create: " + returnInfo);
        return returnInfo;
    }

    @Override
    public FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering readInfo(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "readInfo() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "readInfo() was called with a null fileDO");
        FileInfoDO returnInfo = null;
        if (this.filePatternMatcher.isSharedFolderOrDescendent(this.getFullPath(fileInfo))) {
            logger.info("Reading file info for shared file: " + fileInfo);
        } else {
            FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, true);
            GDSClient gdsClient = this.fetchGdsClient(clientConfig);
            logger.info("Calling fileInfoReadAction for fileInfo=" + gdsFileInfo + ")");
            FileInfoRead fileInfoReadAction = new FileInfoRead(gdsFileInfo, fileInfo, gdsClient, userToken);
            returnInfo = this.fileActionExecutor.execute(fileInfoReadAction);
            logger.info("Returning from readInfo: " + returnInfo);
        }
        return returnInfo;
    }

    @Override
    public FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering read(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "read() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "read() was called with a null fileInfoDO");
        Preconditions.checkArgument(!fileInfo.isDirectory(), "read() was called for a directory: %s", fileInfo);
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileReadAction for fileInfo=" + gdsFileInfo + ")");
        FileRead fileReadAction = new FileRead(gdsFileInfo, gdsClient, userToken);
        FileDO returnInfo = this.fileActionExecutor.execute(fileReadAction);
        logger.info("Returning from read: " + returnInfo);
        return returnInfo;
    }

    @Override
    public InputStream readContent(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering readContent(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "readContent() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "readContent() was called with a null fileInfoDO");
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, false);
        logger.info("Calling read for fileInfo=" + gdsFileInfo + ")");
        FileDO file = this.read(userToken, gdsFileInfo);
        ByteArrayInputStream returnStream = new ByteArrayInputStream(file.getData());
        logger.info("Returning from readContent: " + returnStream.toString());
        return returnStream;
    }

    @Override
    public FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering open(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "open() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "open() was called with a null fileInfoDO");
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, false);
        logger.info("Calling read for fileInfo=" + gdsFileInfo + ")");
        FileDO returnDO = this.read(userToken, gdsFileInfo);
        logger.info("Returning from open: " + returnDO);
        return returnDO;
    }

    @Override
    public FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        logger.info("Entering update(userToken=" + userToken + ", fileDO=" + file + ")");
        Preconditions.checkArgument(userToken != null, "update() was called with a null token");
        Preconditions.checkArgument(file != null && file.getFileInfo() != null, "update() was called with a null fileDO");
        Preconditions.checkArgument(!file.getFileInfo().isDirectory(), "update() was called for a directory: %s", file.getFileInfo());
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, file.getFileInfo(), false);
        FileDO gdsFile = new FileDO(gdsFileInfo);
        gdsFile.setContent(file.getContent());
        gdsFile.setData(file.getData());
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileUpdateAction for fileDO=" + gdsFile + ")");
        FileUpdate fileUpdateAction = new FileUpdate(gdsFile, gdsClient, userToken);
        FileInfoDO returnInfo = this.fileActionExecutor.execute(fileUpdateAction);
        logger.info("Returning from update: " + returnInfo);
        return returnInfo;
    }

    @Override
    public FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering close(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "close() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "close() was called with a null fileDO");
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        logger.info("Returning from close: " + fileInfo);
        return fileInfo;
    }

    @Override
    public FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering delete(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "delete() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "delete() was called with a null fileDO");
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileDeleteAction for fileInfo=" + gdsFileInfo + ")");
        FileDelete fileDeleteAction = new FileDelete(gdsFileInfo, gdsClient, userToken);
        FileInfoDO returnInfo = this.fileActionExecutor.execute(fileDeleteAction);
        logger.info("Returning from delete: " + returnInfo);
        return returnInfo;
    }

    @Override
    public FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        logger.info("Entering delete(userToken=" + userToken + ", fileInfo[]=" + fileInfoArray + ")");
        Preconditions.checkArgument(userToken != null, "delete() was called with a null token");
        Preconditions.checkArgument(fileInfoArray.length > 0, "delete() was called without any file in the list");
        ArrayList<FileInfoDO> filesFailedDeletion = new ArrayList<FileInfoDO>();
        ArrayList<FileInfoDO> returnFileInfoList = new ArrayList<FileInfoDO>();
        for (FileInfoDO fileInfoDO : fileInfoArray) {
            try {
                FileInfoDO updatedFileInfo = this.delete(userToken, fileInfoDO);
                returnFileInfoList.add(updatedFileInfo);
            }
            catch (MLSException mlex) {
                filesFailedDeletion.add(fileInfoDO);
                returnFileInfoList.add(fileInfoDO);
            }
        }
        FileInfoDO[] returnInfoArr = returnFileInfoList.toArray(new FileInfoDO[returnFileInfoList.size()]);
        logger.info("Returning from delete multiple files: " + returnInfoArr);
        return returnInfoArr;
    }

    @Override
    public FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        logger.info("Entering move(userToken=" + userToken + ", sourceFileInfo[]=" + sourceFileInfoArray + ", destination=" + destinationFileInfo + ")");
        Preconditions.checkArgument(userToken != null, "move() was called with a null token");
        Preconditions.checkArgument(sourceFileInfoArray.length > 0, "move() was called without any file in the list");
        Preconditions.checkArgument(destinationFileInfo != null, "move() for a set of files was called with a null destination");
        Preconditions.checkArgument(destinationFileInfo.isDirectory(), "move() for a set of files was called with a destination that is not a directory: %s", destinationFileInfo);
        FileInfoDO gdsDestinationFileInfo = this.translateFileInfo_clientToGDS(userToken, destinationFileInfo, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileMoveAction for sourceFileInfoArr=" + sourceFileInfoArray + ", destinationFileInfo=" + destinationFileInfo + ")");
        FileMove fileMoveAction = new FileMove(Arrays.asList(sourceFileInfoArray), gdsDestinationFileInfo, gdsClient, userToken);
        FileInfoDO[] returnInfoArr = this.fileActionExecutor.execute(fileMoveAction);
        logger.info("Returning from move multiple files: " + returnInfoArr);
        return returnInfoArr;
    }

    private FileInfoDO move(UserTokenDO userToken, FileInfoDO sourceFile, FileInfoDO destinationFileInfo) throws MLSException {
        logger.info("Entering move(userToken=" + userToken + ", sourceFileInfo=" + sourceFile + ", destination=" + destinationFileInfo + ")");
        Preconditions.checkArgument(userToken != null, "move() was called with a null token");
        Preconditions.checkArgument(sourceFile != null, "move() was called with a null source file");
        Preconditions.checkArgument(destinationFileInfo != null, "move() was called with a null destination");
        List<FileInfoDO> sourceFileList = Arrays.asList(sourceFile);
        FileInfoDO gdsDestinationFileInfo = this.translateFileInfo_clientToGDS(userToken, destinationFileInfo, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileMoveAction for sourceFile=" + sourceFile + ", destination=" + destinationFileInfo + ")");
        FileMove fileMoveAction = new FileMove(sourceFileList, gdsDestinationFileInfo, gdsClient, userToken);
        FileInfoDO[] returnFileInfoArr = this.fileActionExecutor.execute(fileMoveAction);
        logger.info("Returning from readInfo: " + returnFileInfoArr[0]);
        return returnFileInfoArr[0];
    }

    @Override
    public FileInfoDO rename(UserTokenDO userToken, FileInfoDO originalFileInfo, FileInfoDO newFileInfo) throws MLSException {
        logger.info("Entering rename(userToken=" + userToken + ", originalFileInfo=" + originalFileInfo + ", newFileInfo=" + newFileInfo + ")");
        Preconditions.checkArgument(userToken != null, "rename() was called with a null token");
        Preconditions.checkArgument(originalFileInfo != null, "rename() was called with a null fileInfo");
        Preconditions.checkArgument(newFileInfo != null, "rename() was called with a null destination fileInfo");
        FileInfoDO gdsOriginalFileInfo = this.translateFileInfo_clientToGDS(userToken, originalFileInfo, false);
        FileInfoDO gdsNewFileInfo = this.translateFileInfo_clientToGDS(userToken, newFileInfo, false);
        this.move(userToken, gdsOriginalFileInfo, gdsNewFileInfo);
        FileInfoDO clientNewFileInfo = this.translateFileInfo_GDStoClient(userToken, gdsNewFileInfo);
        logger.info("Returning from rename: " + clientNewFileInfo);
        return clientNewFileInfo;
    }

    @Override
    public FileInfoDO[] list(UserTokenDO userToken, FileInfoDO directory) throws MLSException {
        logger.info("Entering list(userToken=" + userToken + ", fileInfo=" + directory + ")");
        Preconditions.checkArgument(userToken != null, "list() was called with a null token");
        Preconditions.checkArgument(directory != null, "list() was called with a null folder specification");
        FileInfoDO gdsDirectory = this.translateFileInfo_clientToGDS(userToken, directory, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling folderListAction for fileInfo=" + gdsDirectory + ")");
        ListFolderContents folderListAction = new ListFolderContents(gdsDirectory, gdsClient, userToken);
        FileInfoDO[] returnInfoArr = this.fileActionExecutor.execute(folderListAction);
        logger.info("Returning from list: " + returnInfoArr);
        return returnInfoArr;
    }

    @Override
    public String getWorkerMountPoint() {
        return this.filenameConverter.getWorkerMountPoint();
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        Preconditions.checkArgument(userToken != null, "getWorkerMountPoint() was called with a null token");
        return this.filenameConverter.getWorkerMountPoint(userToken);
    }

    @Override
    public String getServerMountPoint() {
        return this.filenameConverter.getServerMountPoint();
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        Preconditions.checkArgument(userToken != null, "getServerMountPoint() was called with a null token");
        return this.filenameConverter.getServerMountPoint(userToken);
    }

    @Override
    public FileInfoDO updateInfo(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering updateInfo(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        Preconditions.checkArgument(userToken != null, "updateInfo() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "updateInfo() was called with a null fileInfo");
        boolean forceRefresh = true;
        fileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
        logger.info("Returning from updateInfo: " + fileInfo);
        return fileInfo;
    }

    @Override
    public FileInfoDO updateContent(UserTokenDO userToken, FileInfoDO fileInfo, InputStream contents) throws MLSException {
        logger.info("Entering updateContent(userToken=" + userToken + ", fileInfo=" + fileInfo + ", inputStream=" + contents + ")");
        Preconditions.checkArgument(userToken != null, "updateContent() was called with a null token");
        Preconditions.checkArgument(fileInfo != null, "updateContent() was called with a null fileInfo");
        Preconditions.checkArgument(contents != null, "updateContent() was called with a null InputStream");
        FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, false);
        GDSClient gdsClient = this.fetchGdsClient(clientConfig);
        logger.info("Calling fileUpdateContents for fileInfo=" + gdsFileInfo + ")");
        FileUpdateContents fileUpdateAction = new FileUpdateContents(gdsFileInfo, contents, gdsClient, userToken);
        FileInfoDO returnInfo = this.fileActionExecutor.execute(fileUpdateAction);
        logger.info("Returning from updateContent: " + returnInfo);
        return returnInfo;
    }

    @Override
    public boolean exists(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        boolean returnValue;
        block4: {
            logger.info("Entering exists(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
            Preconditions.checkArgument(userToken != null, "exists() was called with a null token");
            Preconditions.checkArgument(fileInfo != null, "exists() was called with a null fileInfo");
            returnValue = false;
            if (this.filePatternMatcher.isSharedFolderOrDescendent(this.getFullPath(fileInfo))) {
                logger.info("Checking the existence of shared file: " + fileInfo);
            } else {
                FileInfoDO gdsFileInfo = this.translateFileInfo_clientToGDS(userToken, fileInfo, true);
                try {
                    GDSClient gdsClient = this.fetchGdsClient(clientConfig);
                    logger.info("Calling fileInfoReadAction for fileInfo=" + gdsFileInfo + ")");
                    FileInfoRead fileInfoReadAction = new FileInfoRead(gdsFileInfo, fileInfo, gdsClient, userToken);
                    FileInfoDO returnInfo = this.fileActionExecutor.execute(fileInfoReadAction);
                    logger.info("Return from readInfo: " + returnInfo);
                    returnValue = true;
                }
                catch (MLSException mlex) {
                    if (mlex.getFaultCode().equals("FileService.IOError")) break block4;
                    throw mlex;
                }
            }
        }
        return returnValue;
    }

    private String getFullPath(FileInfoDO fileInfo) {
        String path = "";
        if (fileInfo.getLocation() != null) {
            path = path + fileInfo.getLocation();
        }
        if (fileInfo.getName() != null) {
            path = path + "/" + fileInfo.getName();
        }
        return path;
    }

    private FileInfoDO translateFileInfo_clientToGDS(UserTokenDO userToken, FileInfoDO fileInfo, boolean isReadInfo) throws MLSException {
        String serverSeparator;
        String serverFilePath;
        logger.info("Entering translateFileInfo_clientToGDS(userToken=" + userToken + ", fileInfo=" + fileInfo + ", isReadInfo=" + isReadInfo + ")");
        if (userToken.getName() == null && (userToken = this.fetchUserToken()).getName() == null) {
            throw new MLSException("GeneralServerFault", "Can not fetch the user Id -> can not translate filename to repository location; file: " + fileInfo);
        }
        FileInfoDO translatedFileInfo = new FileInfoDO();
        translatedFileInfo.setDirectory(fileInfo.isDirectory());
        translatedFileInfo.setCreated(fileInfo.getCreated());
        translatedFileInfo.setFilePermissions(fileInfo.getFilePermissions());
        translatedFileInfo.setModified(fileInfo.getModified());
        translatedFileInfo.setDirectory(fileInfo.isDirectory());
        translatedFileInfo.setShareAttributes(fileInfo.getShareAttributes());
        if (!fileInfo.isDirectory()) {
            translatedFileInfo.setType("text/plain");
        }
        String mountPoint = this.getServerMountPoint();
        String filePath = fileInfo.getLocation();
        String fileName = fileInfo.getName();
        String workerSeparator = this.filenameConverter.getWorkerFileSeparator();
        if ((fileInfo.isDirectory() || isReadInfo) && !fileName.isEmpty()) {
            filePath = filePath + (filePath.endsWith(workerSeparator) || fileName.startsWith(workerSeparator) ? "" : workerSeparator) + fileName;
        }
        if ((serverFilePath = this.filenameConverter.convertFilenameFromWorkerToServer(userToken, filePath)).startsWith(mountPoint)) {
            serverFilePath = serverFilePath.substring(mountPoint.length());
        }
        if (!serverFilePath.startsWith(serverSeparator = this.filenameConverter.getServerFileSeparator())) {
            serverFilePath = serverSeparator + serverFilePath;
        }
        if (isReadInfo || fileInfo.isDirectory() || fileInfo.getName() == null || fileInfo.getName().isEmpty()) {
            String serverFileName = "";
            int i2 = serverFilePath.lastIndexOf(serverSeparator);
            if (i2 < serverFilePath.length()) {
                serverFileName = serverFilePath.substring(i2 + 1);
                serverFilePath = serverFilePath.substring(0, i2);
            }
            if (!serverFilePath.startsWith(serverSeparator)) {
                serverFilePath = serverSeparator + serverFilePath;
            }
            translatedFileInfo.setLocation(serverFilePath);
            translatedFileInfo.setName(serverFileName);
        } else {
            translatedFileInfo.setLocation(serverFilePath);
            translatedFileInfo.setName(fileInfo.getName());
        }
        logger.info("Returning from translateFileInfo_clientToGDS: " + translatedFileInfo);
        return translatedFileInfo;
    }

    private FileInfoDO translateFileInfo_GDStoClient(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        logger.info("Entering translateFileInfo_GDStoClient(userToken=" + userToken + ", fileInfo=" + fileInfo + ")");
        if (userToken.getName() == null && (userToken = this.fetchUserToken()).getName() == null) {
            throw new MLSException("GeneralServerFault", "Can not fetch the user Id -> can not translate filename from repository location; file: " + fileInfo);
        }
        FileInfoDO translatedFileInfo = new FileInfoDO();
        String filePath = fileInfo.getLocation();
        String translatedFilePath = this.filenameConverter.convertFilenameFromServerToWorker(userToken, filePath);
        translatedFileInfo.setLocation(translatedFilePath);
        translatedFileInfo.setName(fileInfo.getName());
        translatedFileInfo.setDirectory(fileInfo.isDirectory());
        translatedFileInfo.setCreated(fileInfo.getCreated());
        translatedFileInfo.setFilePermissions(fileInfo.getFilePermissions());
        translatedFileInfo.setModified(fileInfo.getModified());
        translatedFileInfo.setDirectory(fileInfo.isDirectory());
        translatedFileInfo.setShareAttributes(fileInfo.getShareAttributes());
        translatedFileInfo.setVersion(fileInfo.getVersion());
        translatedFileInfo.setSize(fileInfo.getSize());
        logger.info("Returning from translateFileInfo_GDStoClient: " + translatedFileInfo);
        return translatedFileInfo;
    }

    private boolean isGdsClientErrorInSet(RuntimeException mwe, EnumSet<GDSErrorCode> errorsSet) {
        Preconditions.checkArgument(mwe != null, "isGdsClientErrorInSet() was called with a null exception instance");
        Preconditions.checkArgument(mwe instanceof MathWorksClientException || mwe instanceof MathWorksServiceException, "isGdsClientErrorInSet() called with an exception of non-gds error class: " + mwe.getClass().getName());
        boolean result = false;
        String codeStr = "";
        try {
            codeStr = mwe instanceof MathWorksClientException ? ((MathWorksClientException)((Object)mwe)).getErrorCode() : ((MathWorksServiceException)((Object)mwe)).getErrorCode();
            GDSErrorCode gdsCode = GDSErrorCode.valueOf((String)codeStr);
            if (errorsSet.contains(gdsCode)) {
                result = true;
            }
        }
        catch (Exception ex) {
            logger.warning("Failed checking if the GDS returned error: \"" + mwe + "\", error code: \"" + codeStr + "\" is in the set: " + errorsSet + " : " + ex.getMessage());
        }
        return result;
    }

    private void createPath(FileAccess fileAccessor, String path, int depth) {
        boolean keepGoing;
        long start;
        FolderCreateRequest requestCreateFolder;
        block7: {
            Preconditions.checkArgument(path != null, "createPath() was called with an null path arg");
            Preconditions.checkArgument(!path.isEmpty(), "createPath() was called with an empty path string");
            if (depth > 20) {
                throw new MLSException("FileService.IOError", "Create folder called for a path with more than the maximum depth of 20; path=" + path);
            }
            Resource folderResource = new Resource();
            folderResource.setPath(path);
            requestCreateFolder = (FolderCreateRequest)new FolderCreateRequest().withResource(folderResource);
            start = System.nanoTime();
            keepGoing = true;
            try {
                fileAccessor.createFolder(requestCreateFolder);
                String operationName = "GDScreateFolder";
                logger.info("SLA_GDScreateFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                keepGoing = false;
            }
            catch (MathWorksServiceException mwse) {
                if (this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.RESOURCE_ALREADY_EXISTS))) {
                    String operationName = "GDScreateAlreadyExistingFolder";
                    logger.info("SLA_GDScreateAlreadyExistingFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                    keepGoing = false;
                }
                if (this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.PARENT_RESOURCE_DOES_NOT_EXIST, GDSErrorCode.RESOURCE_DOES_NOT_EXIST))) break block7;
                String operationName = "GDScreateFolderFailed";
                logger.info("SLA_GDScreateFolderFailed:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                logger.warning("Create folder in GDS failed with error code " + mwse.getErrorCode());
                throw mwse;
            }
        }
        if (keepGoing) {
            int lastSeparatorIdx = FilenameUtils.indexOfLastSeparator(FilenameUtils.normalizeNoEndSeparator(path));
            if (lastSeparatorIdx <= 1) {
                throw new MLSException("FileService.IOError", "Create folder called for the root folder.");
            }
            String basePath = path.substring(0, lastSeparatorIdx + 1);
            this.createPath(fileAccessor, basePath, depth + 1);
            long start_2 = 0L;
            fileAccessor.createFolder(requestCreateFolder);
            String operationName = "GDScreateFolder";
            logger.info("SLA_GDScreateFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
        if (depth == 1) {
            String operationName = "GDScreatePath";
            logger.info("SLA_GDScreatePath:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        }
    }

    private UserTokenDO fetchUserToken() {
        UserManager userManager = (UserManager)ServiceRegistryFactory.getServiceRegistry().getService(UserManagerImpl.NAME);
        UserTokenDO userToken = userManager.getUserToken();
        logger.info("Have fetched userToken for user: " + userToken.getName());
        return userToken;
    }

    private class FileMove
    extends FileserviceActionGds.FileAction<FileInfoDO[]> {
        private List<FileInfoDO> sourceFileList;
        private FileInfoDO destinationFile;

        FileMove(List<FileInfoDO> sourceFileList, FileInfoDO destinationFile, GDSClient gdsClient, UserTokenDO userToken) {
            this.sourceFileList = sourceFileList;
            this.destinationFile = destinationFile;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO[] call() throws MathWorksServiceException, MathWorksClientException {
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            ArrayList<FileInfoDO> resultFileList = new ArrayList<FileInfoDO>();
            for (final FileInfoDO fileInfoDO : this.sourceFileList) {
                long start = 0L;
                try {
                    String pathDestination;
                    FileInfoDO gdsfileInfoDO = FileServiceGdsImpl.this.translateFileInfo_clientToGDS(this.userToken, fileInfoDO, false);
                    String pathSource = FilenameUtils.normalize(gdsfileInfoDO.getLocation());
                    Resource sourceFileRes = new Resource().withPath(pathSource + gdsfileInfoDO.getName());
                    FileInfoDO fileInfo = new FileInfoDO();
                    fileInfo.setDirectory(false);
                    if (this.destinationFile.isDirectory()) {
                        pathDestination = FilenameUtils.normalize(this.destinationFile.getLocation() + this.destinationFile.getName()) + gdsfileInfoDO.getName();
                        fileInfo.setLocation(this.destinationFile.getLocation() + this.destinationFile.getName());
                        fileInfo.setName(gdsfileInfoDO.getName());
                    } else {
                        pathDestination = FilenameUtils.normalize(this.destinationFile.getLocation() + this.destinationFile.getName());
                        fileInfo.setLocation(this.destinationFile.getLocation());
                        fileInfo.setName(this.destinationFile.getName());
                    }
                    Resource targetFileRes = new Resource().withPath(pathDestination + this.destinationFile.getName());
                    MoveRequest fileMoveReq = new MoveRequest().withSource(sourceFileRes).withTarget(targetFileRes);
                    try {
                        start = System.nanoTime();
                        fileAccessor.move(fileMoveReq);
                    }
                    finally {
                        String operationName = "GDSmoveFile";
                        logger.info("SLA_GDSmoveFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                    }
                    boolean forceRefresh = true;
                    FileServiceGdsImpl.this.metadataProvider.addMetadata(fileInfo, forceRefresh);
                    FileInfoDO serverFileInfoDO = FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo);
                    resultFileList.add(serverFileInfoDO);
                    if (!this.destinationFile.isDirectory() || FileServiceGdsImpl.this.pathManager == null) continue;
                    FileServiceGdsImpl.this.asyncExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            String originalFolder = FileServiceGdsImpl.this.filenameConverter.convertFilenameFromServerToWorker(FileMove.this.userToken, fileInfoDO.getLocation());
                            String newFolder = FileServiceGdsImpl.this.filenameConverter.convertFilenameFromServerToWorker(FileMove.this.userToken, FileServiceGdsImpl.this.translateFileInfo_GDStoClient(FileMove.this.userToken, FileMove.this.destinationFile).getLocation());
                            logger.info("Moving folder on the path: " + originalFolder + " to " + newFolder);
                            FileServiceGdsImpl.this.pathManager.moveFolderOnPath(originalFolder, newFolder);
                        }
                    });
                }
                catch (Exception ex) {
                    logger.severe("Exception thrown in moving file: " + fileInfoDO + " to destination: " + this.destinationFile.getLocation() + "/" + this.destinationFile.getName());
                    resultFileList.add(fileInfoDO);
                }
            }
            return resultFileList.toArray(new FileInfoDO[resultFileList.size()]);
        }
    }

    private class ListFolderContents
    extends FileserviceActionGds.FileAction<FileInfoDO[]> {
        private FileInfoDO folder;

        ListFolderContents(FileInfoDO folder, GDSClient gdsClient, UserTokenDO userToken) {
            this.folder = folder;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO[] call() throws MathWorksServiceException, MathWorksClientException {
            List files;
            FolderListResponse folderListResponse;
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            ArrayList<FileInfoDO> filesList = new ArrayList<FileInfoDO>();
            String path = FilenameUtils.normalize(this.folder.getLocation()) + this.folder.getName();
            Resource folderResource = new Resource();
            folderResource.setPath(path);
            FolderListRequest folderListReq = (FolderListRequest)new FolderListRequest().withResource(folderResource);
            long start = System.nanoTime();
            try {
                folderListResponse = fileAccessor.listFolder(folderListReq);
            }
            finally {
                String operationName = "GDSlistFolder";
                logger.info("SLA_GDSlistFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            List folders = folderListResponse.getFolders();
            if (folders != null) {
                for (FolderSummary folderSummary : folders) {
                    FileInfoDO fileInfo = new FileInfoDO();
                    fileInfo.setDirectory(true);
                    fileInfo.setLocation(path);
                    fileInfo.setName(folderSummary.getName());
                    fileInfo.setModified(folderSummary.getLastModifiedDate());
                    FileInfoDO serverFileInfo = FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo);
                    filesList.add(serverFileInfo);
                }
            }
            if ((files = folderListResponse.getFiles()) != null) {
                for (FileSummary fileSummary : files) {
                    FileInfoDO fileInfo = new FileInfoDO();
                    fileInfo.setDirectory(false);
                    fileInfo.setLocation(path);
                    fileInfo.setName(fileSummary.getName());
                    fileInfo.setSize(fileSummary.getSize());
                    fileInfo.setModified(fileSummary.getLastModifiedDate());
                    FileInfoDO serverFileInfo = FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo);
                    filesList.add(serverFileInfo);
                }
            }
            return filesList.toArray(new FileInfoDO[filesList.size()]);
        }
    }

    private class FileInfoRead
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileInfoDO fileInfoDO;
        private FileInfoDO workerFileInfo;

        FileInfoRead(FileInfoDO fileInfoDO, FileInfoDO workerFileInfo, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.workerFileInfo = workerFileInfo;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            String path = FilenameUtils.normalize(this.fileInfoDO.getLocation());
            Resource fileResource = new Resource();
            fileResource.setPath(path + this.fileInfoDO.getName());
            FileAttributesReadRequest fileAttrReq = (FileAttributesReadRequest)new FileAttributesReadRequest().withResource(fileResource);
            long start = System.nanoTime();
            try {
                FileAttributesReadResponse response = fileAccessor.readFileAttributes(fileAttrReq);
                this.workerFileInfo.setDirectory(response.getFileAttributes().getFileType() == FileAttributes.FileType.FOLDER);
                this.workerFileInfo.setSize(response.getFileAttributes().getSize());
                this.workerFileInfo.setModified(response.getFileAttributes().getLastModifiedDate());
                this.workerFileInfo.setCreated(response.getFileAttributes().getCreatedDate());
            }
            catch (ServiceNotFoundException ex) {
                FileServiceMessageFaultDO fault = new FileServiceMessageFaultDO("FileService.IOError", "Requested resource not found", this.fileInfoDO);
                throw new MLSException(fault);
            }
            catch (MathWorksServiceException mwse) {
                if (FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.RESOURCE_DOES_NOT_EXIST, GDSErrorCode.PARENT_RESOURCE_DOES_NOT_EXIST))) {
                    logger.warning("File info read called for a file that does not exist: " + this.fileInfoDO);
                    FileServiceMessageFaultDO fault = new FileServiceMessageFaultDO("FileService.IOError", "Requested resource not found", this.fileInfoDO);
                    throw new MLSException(fault);
                }
            }
            finally {
                String operationName = "GDSfileInfoRead";
                logger.info("SLA_GDSfileInfoRead:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            return this.workerFileInfo;
        }
    }

    private class FileUpdateContents
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileInfoDO fileInfoDO;
        private InputStream contentsStream;

        FileUpdateContents(FileInfoDO fileInfo, InputStream contents, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfo;
            this.contentsStream = contents;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            ByteArrayBuffer fileContentsBytes = new ByteArrayBuffer(1000);
            byte[] buffer = new byte[1000];
            int len = 0;
            try {
                if (this.contentsStream != null) {
                    while ((len = this.contentsStream.read(buffer)) > 0) {
                        fileContentsBytes.append(buffer, 0, len);
                    }
                }
            }
            catch (IOException ex) {
                throw new MLSException("Failed reading from the input stream on file update.", (Throwable)ex);
            }
            String path = FilenameUtils.normalize(this.fileInfoDO.getLocation());
            Resource fileResource = new Resource();
            fileResource.setPath(path + this.fileInfoDO.getName());
            long start = System.nanoTime();
            try {
                fileAccessor.updateFile(((FileUpdateRequest)new FileUpdateRequest().withResource(fileResource)).withContentType(this.fileInfoDO.getType() != null ? this.fileInfoDO.getType() : "text/plain").withContent(fileContentsBytes.toByteArray()));
            }
            finally {
                String operationName = "GDSfileContentsUpdate";
                logger.info("SLA_GDSfileContentsUpdate:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            this.fileInfoDO.setSize(fileContentsBytes.length() - fileContentsBytes.capacity());
            FileInfoDO serverFileInfoDO = FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, this.fileInfoDO);
            boolean forceRefresh = true;
            serverFileInfoDO = FileServiceGdsImpl.this.metadataProvider.addMetadata(serverFileInfoDO, forceRefresh);
            return serverFileInfoDO;
        }
    }

    private class FileRead
    extends FileserviceActionGds.FileAction<FileDO> {
        private FileInfoDO fileInfoDO;

        FileRead(FileInfoDO fileInfoDO, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileDO call() throws MathWorksServiceException, MathWorksClientException {
            FileReadResponse fileReadResponse;
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            String path = FilenameUtils.normalize(this.fileInfoDO.getLocation());
            Resource fileResource = new Resource();
            fileResource.setPath(path + this.fileInfoDO.getName());
            long start = System.nanoTime();
            try {
                fileReadResponse = fileAccessor.readFile((FileReadRequest)new FileReadRequest().withResource(fileResource));
            }
            finally {
                String operationName = "GDSreadFile";
                logger.info("SLA_GDSreadFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            byte[] fileContentsBytes = fileReadResponse.getResponseBody();
            FileInfoDO serverFileInfoDO = FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, this.fileInfoDO);
            FileDO fileDO = new FileDO(serverFileInfoDO);
            fileDO.setData(fileContentsBytes);
            return fileDO;
        }
    }

    private class FileDelete
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileInfoDO fileInfoDO;

        FileDelete(FileInfoDO fileInfoDO, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileInfoDO = fileInfoDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            long start = 0L;
            if (this.fileInfoDO.isDirectory()) {
                String fileSeparator = FileServiceGdsImpl.this.filenameConverter.getServerFileSeparator();
                Resource folderResource = new Resource();
                folderResource.setPath(FilenameUtils.normalizeNoEndSeparator(this.fileInfoDO.getLocation()) + fileSeparator + this.fileInfoDO.getName());
                FolderDeleteRequest folderDeleteRequest = (FolderDeleteRequest)new FolderDeleteRequest().withResource(folderResource);
                start = System.nanoTime();
                fileAccessor.deleteFolder(folderDeleteRequest);
                String operationName = "GDSdeleteFile";
                logger.info("SLA_GDSdeleteFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            } else {
                String path = FilenameUtils.normalize(this.fileInfoDO.getLocation());
                Resource fileResource = new Resource();
                fileResource.setPath(path + this.fileInfoDO.getName());
                FileDeleteRequest fileDeleteReq = (FileDeleteRequest)new FileDeleteRequest().withResource(fileResource);
                try {
                    start = System.nanoTime();
                    fileAccessor.deleteFile(fileDeleteReq);
                }
                catch (ServiceNotFoundException ex) {
                    logger.severe("Delete called for a file that does not exist: " + this.fileInfoDO);
                    throw ex;
                }
                catch (MathWorksServiceException mwse) {
                    if (FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.RESOURCE_DOES_NOT_EXIST, GDSErrorCode.PARENT_RESOURCE_DOES_NOT_EXIST))) {
                        logger.severe("Delete called for a file that does not exist: " + this.fileInfoDO);
                        throw mwse;
                    }
                }
                finally {
                    String operationName = "GDSdeleteFile";
                    logger.info("SLA_GDSdeleteFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                }
            }
            this.fileInfoDO.setDeleted(true);
            boolean forceRefresh = true;
            this.fileInfoDO = FileServiceGdsImpl.this.metadataProvider.addMetadata(this.fileInfoDO, forceRefresh);
            return FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, this.fileInfoDO);
        }
    }

    private class FileUpdate
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileDO fileDO;

        FileUpdate(FileDO fileDO, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileDO = fileDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            FileAccess fileAccessor = this.gdsClient.getFileAccess();
            FileInfoDO fileInfo = this.fileDO.getFileInfo();
            String path = FilenameUtils.normalize(fileInfo.getLocation());
            Resource fileResource = new Resource();
            fileResource.setPath(path + fileInfo.getName());
            FileUpdateRequest fileUpdateReq = ((FileUpdateRequest)new FileUpdateRequest().withResource(fileResource)).withContentType(fileInfo.getType() != null ? fileInfo.getType() : "text/plain").withContent(this.fileDO.getData());
            long start = System.nanoTime();
            try {
                fileAccessor.updateFile(fileUpdateReq);
            }
            catch (ServiceNotFoundException ex) {
                logger.severe("Update called for a file that does not exist: " + fileInfo);
                throw ex;
            }
            catch (MathWorksServiceException mwse) {
                if (FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.RESOURCE_DOES_NOT_EXIST))) {
                    logger.severe("Update called for a file that does not exist: " + fileInfo);
                } else {
                    logger.severe("Update failed for file : " + fileInfo + " with error: " + (Object)((Object)mwse));
                }
                throw mwse;
            }
            finally {
                String operationName = "GDSupdateFile";
                logger.info("SLA_GDSupdateFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
            }
            boolean forceRefresh = true;
            fileInfo = FileServiceGdsImpl.this.metadataProvider.addMetadata(fileInfo, forceRefresh);
            return FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo);
        }
    }

    private class FileCreate
    extends FileserviceActionGds.FileAction<FileInfoDO> {
        private FileDO fileDO;

        FileCreate(FileDO fileDO, GDSClient gdsClient, UserTokenDO userToken) {
            this.fileDO = fileDO;
            this.gdsClient = gdsClient;
            this.userToken = userToken;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FileInfoDO call() throws MathWorksServiceException, MathWorksClientException {
            FileInfoDO fileInfo;
            block11: {
                String path;
                FileAccess fileAccessor;
                block12: {
                    fileAccessor = this.gdsClient.getFileAccess();
                    fileInfo = this.fileDO.getFileInfo();
                    path = fileInfo.getLocation();
                    String fileSeparator = FileServiceGdsImpl.this.filenameConverter.getServerFileSeparator();
                    if ((path = path + (path.endsWith(fileSeparator) ? "" : fileSeparator) + fileInfo.getName()).endsWith(fileSeparator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (!fileInfo.isDirectory()) break block12;
                    if (path.isEmpty()) {
                        logger.warning("Request to create the user's root folder; ignoring");
                        break block11;
                    } else {
                        Resource folderResource = new Resource();
                        folderResource.setPath(path);
                        FolderCreateRequest folderCreateReq = (FolderCreateRequest)new FolderCreateRequest().withResource(folderResource);
                        long start = System.nanoTime();
                        try {
                            fileAccessor.createFolder(folderCreateReq);
                            String operationName = "GDScreateFolder";
                            logger.info("SLA_GDScreateFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                            if (FileServiceGdsImpl.this.pathManager != null) {
                                final String folder = FileServiceGdsImpl.this.filenameConverter.convertFilenameFromServerToWorker(this.userToken, FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo).getLocation());
                                FileServiceGdsImpl.this.asyncExecutor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        logger.info("Adding folder to path: " + folder);
                                        FileServiceGdsImpl.this.pathManager.addFolderToPath(folder);
                                    }
                                });
                            }
                            break block11;
                        }
                        catch (MathWorksServiceException mwse) {
                            if (FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.RESOURCE_ALREADY_EXISTS))) {
                                logger.warning("Path already exists: " + path);
                                throw mwse;
                            }
                            if (!FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.PARENT_RESOURCE_DOES_NOT_EXIST, GDSErrorCode.RESOURCE_DOES_NOT_EXIST))) {
                                logger.severe("Directory creation failed for fileInfo: " + fileInfo + " with error: " + mwse.getMessage());
                                throw mwse;
                            }
                            logger.info("Path does not exist; creating path: " + fileInfo.getLocation());
                            FileServiceGdsImpl.this.createPath(fileAccessor, fileInfo.getLocation(), 1);
                            start = System.nanoTime();
                            fileAccessor.createFolder(folderCreateReq);
                            String operationName = "GDScreateFolder";
                            logger.info("SLA_GDScreateFolder:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                        }
                    }
                    break block11;
                }
                Resource fileResource = new Resource();
                fileResource.setPath(path);
                FileCreateRequest fileCreateReq = ((FileCreateRequest)new FileCreateRequest().withResource(fileResource)).withContentType(fileInfo.getType() != null ? fileInfo.getType() : "text/plain").withContent(this.fileDO.getData());
                long start = System.nanoTime();
                try {
                    fileAccessor.createFile(fileCreateReq);
                    String operationName = "GDScreateFile";
                    logger.info("SLA_GDScreateFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                }
                catch (MathWorksServiceException mwse) {
                    if (!FileServiceGdsImpl.this.isGdsClientErrorInSet((RuntimeException)((Object)mwse), EnumSet.of(GDSErrorCode.PARENT_RESOURCE_DOES_NOT_EXIST, GDSErrorCode.RESOURCE_DOES_NOT_EXIST))) {
                        logger.severe("File creation failed for fileInfo: " + fileInfo + " with error: " + mwse.getMessage());
                        throw mwse;
                    }
                    logger.info("Path does not exist; creating path: " + fileInfo.getLocation());
                    FileServiceGdsImpl.this.createPath(fileAccessor, fileInfo.getLocation(), 1);
                    start = System.nanoTime();
                    fileAccessor.createFile(fileCreateReq);
                    String operationName = "GDScreateFile";
                    logger.info("SLA_GDScreateFile:" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                }
            }
            boolean forceRefresh = true;
            fileInfo = FileServiceGdsImpl.this.metadataProvider.addMetadata(fileInfo, forceRefresh);
            return FileServiceGdsImpl.this.translateFileInfo_GDStoClient(this.userToken, fileInfo);
        }
    }
}

