/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.locking.impl;

import com.mathworks.matlabserver.fileservices.locking.FileLockDAO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileLockDO;
import com.mathworks.matlabserver.internalservices.file.FileLockService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;

public class FileLockServiceImpl
implements FileLockService {
    FileLockDAO fileLockDAO = null;

    public FileLockServiceImpl(FileLockDAO fileLockDAO) {
        this.fileLockDAO = fileLockDAO;
    }

    @Override
    public FileLockDO getFileLock(FileInfoDO fileInfo, UserTokenDO user) {
        FileLockDO fileLock = this.fileLockDAO.getLock(fileInfo);
        if (fileLock != null) {
            fileLock = this.updateEditable(fileLock, user);
        }
        return fileLock;
    }

    @Override
    public FileLockDO lockFile(FileInfoDO fileInfo, UserTokenDO owner) {
        FileLockDO fileLock = this.fileLockDAO.getLock(fileInfo);
        if (fileLock == null) {
            fileLock = new FileLockDO();
            fileLock.setLockOwner(owner.getName());
            this.fileLockDAO.addLock(fileInfo, fileLock);
        }
        fileLock = this.updateEditable(fileLock, owner);
        return fileLock;
    }

    @Override
    public Boolean unlockFile(FileInfoDO fileInfo, UserTokenDO user) {
        FileLockDO fileLock = this.fileLockDAO.getLock(fileInfo);
        if (fileLock != null && this.isOwnedByUser(fileLock, user)) {
            this.fileLockDAO.removeLock(fileInfo);
            return true;
        }
        return false;
    }

    @Override
    public void unlockAllForUser(UserTokenDO owner) {
        this.fileLockDAO.removeLocksByOwner(owner);
    }

    private FileLockDO updateEditable(FileLockDO fileLock, UserTokenDO user) {
        if (this.isOwnedByUser(fileLock, user)) {
            fileLock.setEditable(true);
        } else {
            fileLock.setEditable(false);
        }
        return fileLock;
    }

    private boolean isOwnedByUser(FileLockDO fileLock, UserTokenDO user) {
        return fileLock.getLockOwner().equals(user.getName());
    }
}

