/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.message;

import com.mathworks.matlabserver.internalservices.faults.FaultUtils;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.message.MLSResponseMessage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileHandlerUtils {
    private static final Logger logger = Logger.getLogger(FileHandlerUtils.class.getName());
    public static final String UFS_BASE_PATH = "/users";

    public static FileInfoDO[] removeHiddenFilesAndDirs(FileInfoDO[] input) {
        FileInfoDO[] retval = null;
        if (input != null) {
            ArrayList<FileInfoDO> cleanList = new ArrayList<FileInfoDO>();
            for (FileInfoDO fido : input) {
                if (fido == null || fido.getName() == null || fido.getName().startsWith(".")) continue;
                cleanList.add(fido);
            }
            retval = cleanList.toArray(new FileInfoDO[cleanList.size()]);
        }
        return retval;
    }

    public static void setResponseFault(MLSResponseMessage response, MLSException exception) {
        logger.log(Level.WARNING, exception.getMessage(), exception);
        response.setFault(FaultUtils.convert(exception));
    }

    public static boolean isInUfs(String path) {
        return path.startsWith(UFS_BASE_PATH);
    }
}

