/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.policy;

import com.mathworks.matlabserver.common.fileservice.FilePatternMatcher;
import com.mathworks.matlabserver.fileservices.policy.MetadataProvider;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.filesharing.ShareAttributesDO;
import java.util.logging.Logger;

public class ShareMetadataProviderImpl
implements MetadataProvider {
    private static final Logger logger = Logger.getLogger(ShareMetadataProviderImpl.class.getName());
    private static final String separator = "/";
    private final FilePatternMatcher filePatternMatcher;

    public ShareMetadataProviderImpl() {
        this(new FilePatternMatcher());
    }

    public ShareMetadataProviderImpl(FilePatternMatcher filePatternMatcher) {
        this.filePatternMatcher = filePatternMatcher;
    }

    @Override
    public FileInfoDO addMetadata(FileInfoDO fileInfo, boolean isProduced, boolean forceUpdate) {
        ShareAttributesDO shareAttributes;
        logger.finest("Entering addMetadata(fileInfo = " + fileInfo + ", isProduced = " + isProduced + ", forceUpdate = " + forceUpdate);
        if (fileInfo != null && ((shareAttributes = fileInfo.getShareAttributes()) == null || forceUpdate)) {
            shareAttributes = new ShareAttributesDO();
            fileInfo.setShareAttributes(shareAttributes);
            boolean canProduceShare = this.canProduceShare(fileInfo);
            shareAttributes.setCanProduceShare(canProduceShare);
            boolean isConsumed = this.isConsumed(fileInfo);
            shareAttributes.setConsumed(isConsumed);
            if (!isConsumed) {
                shareAttributes.setProduced(isProduced);
                if (isProduced && canProduceShare) {
                    shareAttributes.setProducedRoot(true);
                } else {
                    shareAttributes.setProducedRoot(false);
                }
            } else {
                shareAttributes.setProduced(false);
                if (isProduced) {
                    logger.warning("addMetadata() was called with isProduced = true for a consumed file: " + fileInfo);
                }
            }
            logger.finest("Have set ShareAttributes for folder: " + this.getFullPath(fileInfo) + ": " + "canProduceShare: " + canProduceShare + " isConsumed: " + isConsumed + " isProduced: " + shareAttributes.isProduced() + " isProducedRoot: " + shareAttributes.isProducedRoot() + ", " + this.getFullPath(fileInfo));
        }
        return fileInfo;
    }

    @Override
    public FileInfoDO addMetadata(FileInfoDO fileInfo, boolean forceUpdate) {
        return this.addMetadata(fileInfo, false, forceUpdate);
    }

    protected boolean canProduceShare(FileInfoDO fileInfo) {
        boolean retval = false;
        if (fileInfo != null && fileInfo.isDirectory()) {
            String path = this.getFullPath(fileInfo);
            boolean isTopLevelFolder = this.filePatternMatcher.isTopLevelFileOrFolder(path);
            boolean isTopLevelSharedFolder = this.filePatternMatcher.isTopLevelSharedFolder(path);
            boolean isTopLevelPublishedFolder = this.filePatternMatcher.isTopLevelPublishedFolder(path);
            retval = isTopLevelFolder && !isTopLevelSharedFolder && !isTopLevelPublishedFolder;
        }
        return retval;
    }

    protected boolean isConsumed(FileInfoDO fileInfo) {
        boolean retval = false;
        if (fileInfo != null) {
            String path = this.getFullPath(fileInfo);
            retval = this.filePatternMatcher.isSharedFolderOrDescendent(path);
        }
        return retval;
    }

    private String getFullPath(FileInfoDO fileInfo) {
        String path = "";
        if (fileInfo.getLocation() != null) {
            path = path + fileInfo.getLocation();
        }
        if (fileInfo.getName() != null) {
            path = path + separator + fileInfo.getName();
        }
        return path;
    }
}

