/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.util;

import com.mathworks.matlabserver.fileservices.util.FilenameConverterBase;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.File;

public class FilenameConverterGdsImpl
extends FilenameConverterBase {
    private final String unMappedMatlabRoot;

    public FilenameConverterGdsImpl(String serverMountPoint, String workerMountPoint, String matlabRoot) {
        this(serverMountPoint, workerMountPoint, matlabRoot, "/", File.separator);
    }

    public FilenameConverterGdsImpl(String serverMountPoint, String workerMountPoint, String matlabRoot, String serverFileSeparator, String workerFileSeparator) {
        super(serverMountPoint, workerMountPoint, serverFileSeparator, workerFileSeparator);
        this.unMappedMatlabRoot = this.translateFilenameToInternalForm(matlabRoot);
    }

    @Override
    protected void validateFileName(UserTokenDO userToken, String filename) throws MLSException {
        if (!this.isMatlabToolboxFile(filename)) {
            super.validateFileName(userToken, filename);
        }
    }

    @Override
    protected String mapToWorker(UserTokenDO userToken, String filename) {
        if (!this.isMatlabToolboxFile(filename)) {
            String userId = userToken.getName();
            if (filename.startsWith(userId)) {
                filename = filename.substring(userId.length());
            }
            if (filename.startsWith(this.getServerFileSeparator() + userId)) {
                filename = filename.substring(userId.length() + this.getServerFileSeparator().length());
            }
            filename = filename.replace("/", this.getWorkerFileSeparator());
            String workerMountPoint = this.getWorkerMountPoint(userToken);
            if (!filename.isEmpty() && !filename.startsWith(this.getWorkerFileSeparator())) {
                workerMountPoint = workerMountPoint + (workerMountPoint.endsWith(this.getWorkerFileSeparator()) ? "" : this.getWorkerFileSeparator());
            }
            filename = (filename = workerMountPoint + filename).endsWith(this.getWorkerFileSeparator()) ? filename.substring(0, filename.length() - this.getWorkerFileSeparator().length()) : filename;
        } else {
            filename = filename.replace("/", this.getWorkerFileSeparator());
        }
        while (!filename.equals(this.getWorkerFileSeparator()) && filename.endsWith(this.getWorkerFileSeparator())) {
            filename = filename.substring(0, filename.length() - this.getWorkerFileSeparator().length());
        }
        return filename;
    }

    @Override
    protected String mapToServer(UserTokenDO userToken, String filename) {
        String workerFileSeparator = this.getWorkerFileSeparator();
        String serverFileSeparator = this.getServerFileSeparator();
        if (!this.isMatlabToolboxFile(filename)) {
            if (!filename.startsWith(workerFileSeparator)) {
                filename = workerFileSeparator + filename;
            }
            if (filename.startsWith(this.getWorkerMountPoint())) {
                filename = filename.substring(this.getWorkerMountPoint().length());
            }
            if ((filename = filename.replace(workerFileSeparator, serverFileSeparator)).startsWith(userToken.getName())) {
                filename = filename.substring(userToken.getName().length());
            }
            if (filename.startsWith(serverFileSeparator + userToken.getName())) {
                filename = filename.substring(serverFileSeparator.length() + userToken.getName().length());
            }
            if (!filename.startsWith(serverFileSeparator)) {
                filename = serverFileSeparator + filename;
            }
        }
        if (!filename.equals(this.getServerFileSeparator()) && filename.endsWith(serverFileSeparator)) {
            filename = filename.substring(0, filename.length() - serverFileSeparator.length());
        }
        return filename;
    }

    private boolean isMatlabToolboxFile(String filename) {
        return filename.startsWith(this.unMappedMatlabRoot) || filename.startsWith(this.getWorkerFileSeparator() + this.unMappedMatlabRoot);
    }

    @Override
    public String convertFilenameFromWorkerToServer(UserTokenDO userToken, String filename) {
        this.validateFileName(userToken, filename);
        filename = this.mapToServer(userToken, filename);
        return filename;
    }

    @Override
    public String convertFilenameFromServerToWorker(UserTokenDO userToken, String filename) {
        this.validateFileName(userToken, filename);
        filename = this.mapToWorker(userToken, filename);
        return filename;
    }
}

