/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.util;

import com.mathworks.matlabserver.common.fileservice.FileUtils;
import com.mathworks.matlabserver.fileservices.util.FilenameConverterBase;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class FilenameConverterWebdavImpl
extends FilenameConverterBase {
    private static final Logger logger = Logger.getLogger(FilenameConverterWebdavImpl.class.getName());

    public FilenameConverterWebdavImpl(String serverMountPoint, String workerMountPoint) {
        this(serverMountPoint, workerMountPoint, "/", File.separator);
    }

    public FilenameConverterWebdavImpl(String serverMountPoint, String workerMountPoint, String serverFileSeparator, String workerFileSeparator) {
        super(serverMountPoint, workerMountPoint, serverFileSeparator, workerFileSeparator);
    }

    @Override
    protected String unMapFromServer(UserTokenDO userToken, String filename) {
        filename = super.unMapFromServer(userToken, filename);
        filename = FileUtils.ufsUriDecode(filename);
        return filename;
    }

    @Override
    protected String mapToServer(UserTokenDO userToken, String filename) {
        filename = super.mapToServer(userToken, filename);
        try {
            int sepIndex = filename.lastIndexOf(this.getServerFileSeparator());
            String path = filename.substring(0, sepIndex);
            String name = filename.substring(sepIndex);
            path = URIUtil.encodePath((String)path);
            name = URIUtil.encodeQuery((String)name);
            filename = path + name;
        }
        catch (URIException e2) {
            logger.log(Level.SEVERE, "Error encoding filename", e2);
        }
        return filename;
    }
}

