/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.versioning;

import com.mathworks.matlabserver.fileservices.impl.WebdavClient;
import com.mathworks.matlabserver.fileservices.impl.WebdavClientImpl;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.FileVersionAttributesDO;
import com.mathworks.matlabserver.internalservices.file.VersionService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.util.HttpDateFormat;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;

public class VersionServiceDeltaVImpl
implements VersionService {
    private static final Logger logger = Logger.getLogger(VersionServiceDeltaVImpl.class.getName());
    private final WebdavClient webdavClient;
    private final FilenameConverter filenameConverter;
    private final FileService fileService;
    private static final ThreadLocal<DateFormat> modificationDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new HttpDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        }
    };

    public VersionServiceDeltaVImpl(FilenameConverter filenameConverter, FileService fileService) {
        this(filenameConverter, fileService, new WebdavClientImpl(filenameConverter.getServerMountPoint()));
    }

    public VersionServiceDeltaVImpl(FilenameConverter filenameConverter, FileService fileService, WebdavClient webdavClient) {
        this.filenameConverter = filenameConverter;
        this.fileService = fileService;
        this.webdavClient = webdavClient;
        logger.setLevel(Level.INFO);
    }

    @Override
    public FileDO readVersion(UserTokenDO userToken, FileInfoDO fileInfo) {
        if (fileInfo.getVersion() == null) {
            throw this.createMLSException("No version information specified.");
        }
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        DavPropertyNameSet propertyNames = new DavPropertyNameSet();
        propertyNames.add(DavPropertyName.DISPLAYNAME);
        ReportInfo reportInfo = new ReportInfo(ReportType.VERSION_TREE, Integer.MAX_VALUE, propertyNames);
        MultiStatusResponse[] responses = this.webdavClient.report(client, fileUrl, reportInfo);
        byte[] data = null;
        for (MultiStatusResponse response : responses) {
            DavProperty prop;
            String versionName;
            DavPropertySet properties = response.getProperties(200);
            if (!properties.contains(DavPropertyName.DISPLAYNAME) || !(versionName = (String)(prop = properties.get(DavPropertyName.DISPLAYNAME)).getValue()).equals(fileInfo.getVersion().getVersionNumber())) continue;
            data = this.webdavClient.getFile(client, response.getHref());
        }
        FileDO file = new FileDO(fileInfo);
        file.setData(data);
        return file;
    }

    @Override
    public FileInfoDO[] getVersionHistory(UserTokenDO userToken, FileInfoDO fileInfo) {
        String fileUrl = this.filenameConverter.getServerFilename(userToken, fileInfo);
        HttpClient client = this.webdavClient.getHttpClient(userToken);
        DavPropertyNameSet propertyNames = new DavPropertyNameSet();
        propertyNames.add(DavPropertyName.DISPLAYNAME);
        propertyNames.add(DavPropertyName.GETLASTMODIFIED);
        ReportInfo reportInfo = new ReportInfo(ReportType.VERSION_TREE, Integer.MAX_VALUE, propertyNames);
        MultiStatusResponse[] responses = this.webdavClient.report(client, fileUrl, reportInfo);
        return this.convertVersionResponses(responses, fileInfo);
    }

    @Override
    public FileInfoDO[] listDeleted(UserTokenDO userToken, FileInfoDO folder) throws MLSException {
        throw new MLSException("VersionService.Error", "Listing deleted files isn't supported yet.");
    }

    @Override
    public FileInfoDO restoreVersion(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileDO oldVersion = this.readVersion(userToken, fileInfo);
        FileInfoDO newFileInfo = this.fileService.exists(userToken, fileInfo) ? this.fileService.update(userToken, oldVersion) : this.fileService.create(userToken, oldVersion);
        return newFileInfo;
    }

    private FileInfoDO[] convertVersionResponses(MultiStatusResponse[] responses, FileInfoDO originalFileInfo) {
        FileInfoDO[] fileVersions = new FileInfoDO[responses.length - 1];
        for (int i2 = 1; i2 < responses.length; ++i2) {
            fileVersions[i2 - 1] = this.convertToFileInfo(responses[i2], originalFileInfo);
        }
        return fileVersions;
    }

    private FileInfoDO convertToFileInfo(MultiStatusResponse response, FileInfoDO originalFileInfo) {
        String filename = this.getServerFilename(response);
        FileInfoDO fileInfo = new FileInfoDO();
        fileInfo.setName(originalFileInfo.getName());
        fileInfo.setLocation(originalFileInfo.getLocation());
        FileVersionAttributesDO version = new FileVersionAttributesDO();
        version.setVersionNumber(FilenameUtils.getName(filename));
        fileInfo.setVersion(version);
        DavPropertySet properties = response.getProperties(200);
        DavPropertyName lastModifiedName = DavPropertyName.GETLASTMODIFIED;
        if (properties.contains(lastModifiedName)) {
            String lastModified = (String)properties.get(lastModifiedName).getValue();
            try {
                Date modifiedDate = this.getModificationDateFormat().parse(lastModified);
                version.setVersionDate(modifiedDate);
                fileInfo.setModified(modifiedDate);
            }
            catch (ParseException e2) {
                logger.log(Level.SEVERE, "Unable to parse modification date: " + lastModified, e2);
            }
        }
        return fileInfo;
    }

    protected DateFormat getModificationDateFormat() {
        return modificationDateFormat.get();
    }

    private String getServerFilename(MultiStatusResponse response) {
        String filename = response.getHref();
        try {
            filename = URIUtil.encodePath((String)URIUtil.decode((String)filename));
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return filename.endsWith(this.filenameConverter.getServerFileSeparator()) ? filename.substring(0, filename.length() - 1) : filename;
    }

    private MLSException createMLSException(String message) {
        return new MLSException("VersionService.Error", message);
    }
}

