/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.converter;

import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.converter.BeanConverter;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public final class BeanConverterImpl
implements BeanConverter {
    private final BeanUtilsBean beanUtilsBean = new BeanUtilsBean();

    public BeanConverterImpl() {
        ConvertUtilsBean convertUtils = this.beanUtilsBean.getConvertUtils();
        if (convertUtils.lookup(Date.class) != null) {
            convertUtils.deregister(Date.class);
        }
        convertUtils.register(new DateConverter(), Date.class);
    }

    @Override
    public void registerConverter(Converter converter, Class type) {
        this.beanUtilsBean.getConvertUtils().register(converter, type);
    }

    @Override
    public void copyProperties(Object dest, Object src) {
        if (dest instanceof MessageContainerDO || src instanceof MessageContainerDO) {
            throw new IllegalArgumentException("Invoking copyProperties(...) on a message conatiner is not supported, instead use the convert(...) method");
        }
        try {
            this.beanUtilsBean.copyProperties(dest, src);
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        Object obj = this.beanUtilsBean.getConvertUtils().convert(value, type);
        return type.cast(obj);
    }

    private static class DateConverter
    implements Converter {
        private DateConverter() {
        }

        @Override
        public Object convert(Class type, Object value) {
            Object retval = null;
            if (value instanceof Date) {
                retval = ((Date)value).clone();
            }
            return retval;
        }
    }
}

