/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.file;

import com.mathworks.matlabserver.internalservices.annotations.ExposeClass;
import com.mathworks.matlabserver.internalservices.file.FileLockDO;
import com.mathworks.matlabserver.internalservices.file.FilePermissionsDO;
import com.mathworks.matlabserver.internalservices.file.FileVersionAttributesDO;
import com.mathworks.matlabserver.internalservices.filesharing.ShareAttributesDO;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

@ExposeClass
public class FileInfoDO
implements Serializable,
Cloneable {
    public static final String MLS_FILE_SEPARATOR = "/";
    public static final String TYPE_BASE64 = "base64";
    public static final String TYPE_BASE64_WIN = "base64win";
    private static final long serialVersionUID = 1L;
    private String separator;
    private String name;
    private String location;
    private Date modified;
    private Date created;
    private String type;
    private FileVersionAttributesDO version;
    private long size = 0L;
    private FilePermissionsDO filePermissions;
    private boolean deleted;
    private boolean isDirectory;
    private FileLockDO fileLock = new FileLockDO();
    private ShareAttributesDO shareAttributes;

    public FileInfoDO() {
    }

    public FileInfoDO(String path, String separator, int dummy) {
        this();
        int lastSeparator;
        int newLength = path.length() - separator.length();
        if (path.endsWith(separator) && newLength > 0) {
            path = path.substring(0, newLength);
        }
        if ((lastSeparator = path.lastIndexOf(separator)) >= 0 && lastSeparator < path.length()) {
            this.setLocation(path.substring(0, lastSeparator + 1));
            this.setName(path.substring(lastSeparator + separator.length()));
        } else {
            this.setLocation("");
            this.setName(path);
        }
    }

    public FileInfoDO(String path) {
        this(path, File.separator, -1);
    }

    public FileInfoDO(String location, String name) {
        this();
        this.setLocation(location);
        this.setName(name);
    }

    public static FileInfoDO newInstanceWithMetadataDefaults(String location, String name) {
        FileInfoDO fileInfo = new FileInfoDO();
        fileInfo.setLocation(location);
        fileInfo.setName(name);
        fileInfo.setFilePermissions(new FilePermissionsDO());
        fileInfo.setShareAttributes(new ShareAttributesDO());
        return fileInfo;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FileInfoDO that = (FileInfoDO)o2;
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.isDirectory != that.isDirectory) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.created != null ? !this.created.equals(that.created) : that.created != null) {
            return false;
        }
        if (this.fileLock != null ? !this.fileLock.equals(that.fileLock) : that.fileLock != null) {
            return false;
        }
        if (this.filePermissions != null ? !this.filePermissions.equals(that.filePermissions) : that.filePermissions != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.modified != null ? !this.modified.equals(that.modified) : that.modified != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.shareAttributes != null ? !this.shareAttributes.equals(that.shareAttributes) : that.shareAttributes != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.modified != null ? this.modified.hashCode() : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.filePermissions != null ? this.filePermissions.hashCode() : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.isDirectory ? 1 : 0);
        result = 31 * result + (this.fileLock != null ? this.fileLock.hashCode() : 0);
        result = 31 * result + (this.shareAttributes != null ? this.shareAttributes.hashCode() : 0);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (location != null) {
            if (location.contains("\\")) {
                this.separator = "\\";
            } else if (location.contains(MLS_FILE_SEPARATOR)) {
                this.separator = MLS_FILE_SEPARATOR;
            }
        }
        if (location != null && this.separator != null && location.length() > 0 && !location.endsWith(this.separator)) {
            location = location + this.separator;
        }
        this.location = location;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FileVersionAttributesDO getVersion() {
        return this.version;
    }

    public void setVersion(FileVersionAttributesDO version) {
        this.version = version;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public FilePermissionsDO getFilePermissions() {
        return this.filePermissions;
    }

    public void setFilePermissions(FilePermissionsDO filePermissions) {
        this.filePermissions = filePermissions;
    }

    public ShareAttributesDO getShareAttributes() {
        return this.shareAttributes;
    }

    public void setShareAttributes(ShareAttributesDO shareAttributes) {
        this.shareAttributes = shareAttributes;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public FileLockDO getFileLock() {
        return this.fileLock;
    }

    public void setFileLock(FileLockDO fileLock) {
        this.fileLock = fileLock;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toString() {
        return "FileInfoDO{name='" + this.name + '\'' + ", location='" + this.location + '\'' + ", isDirectory='" + (this.isDirectory ? "true" : "false") + "'" + ", version=" + this.version + ", filePermissions=" + this.filePermissions + ", shareAttributes=" + this.shareAttributes + '}';
    }
}

