/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.message;

import com.mathworks.matlabserver.internalservices.common.MessageContainerDO;
import com.mathworks.matlabserver.internalservices.compute.ComputeService;
import com.mathworks.matlabserver.internalservices.compute.ComputeTokenDO;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.SharedDirectoryService;
import com.mathworks.matlabserver.internalservices.message.MessageContainerUtil;
import com.mathworks.matlabserver.internalservices.message.MessageService;
import com.mathworks.matlabserver.internalservices.message.MessageServiceChain;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.internalservices.session.SessionService;
import com.mathworks.matlabserver.internalservices.usagedata.UdcService;
import com.mathworks.matlabserver.internalservices.usagedata.UdcServiceNullImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class MessageServiceChainImpl
implements MessageServiceChain {
    private static final Logger logger = Logger.getLogger(MessageServiceChainImpl.class.getName());
    private final MessageService[] serviceArray;
    private final UdcService udcService;
    private final boolean isValidMessageOrder;

    public MessageServiceChainImpl(MessageService[] serviceArray) {
        this.serviceArray = serviceArray;
        this.udcService = this.extractUDCService(Arrays.asList(serviceArray));
        this.isValidMessageOrder = this.isValidMessageChainOrder();
    }

    public MessageServiceChainImpl() {
        RegistryService serviceRegistry = ServiceRegistryFactory.getServiceRegistry();
        List<MessageService> serviceList = this.extractMessageServices(serviceRegistry.getCollection());
        this.serviceArray = new MessageService[serviceList.size()];
        serviceList.toArray(this.serviceArray);
        this.udcService = this.extractUDCService(serviceRegistry.getCollection());
        this.isValidMessageOrder = this.isValidMessageChainOrder();
    }

    public MessageServiceChainImpl(List<Object> services) {
        List<MessageService> serviceList = this.extractMessageServices(services);
        this.serviceArray = new MessageService[serviceList.size()];
        serviceList.toArray(this.serviceArray);
        logger.info("Service List: " + Arrays.toString(this.serviceArray));
        this.udcService = this.extractUDCService(services);
        this.isValidMessageOrder = this.isValidMessageChainOrder();
    }

    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, MessageContainerDO messageContainer) {
        if (!this.isValidMessageOrder) {
            throw new IllegalStateException("Configuration Bug: The service list defined in mlsedu-services.xml or Java code is not in the correct order.");
        }
        MessageContainerDO incomingMessage = new MessageContainerDO();
        incomingMessage.addAllMessages(messageContainer.getAllMessages());
        Exception propagateException = null;
        if (this.serviceArray != null) {
            for (MessageService service : this.serviceArray) {
                if (service == null) continue;
                try {
                    messageContainer = service.sendMessages(userToken, messageContainer);
                }
                catch (Exception e2) {
                    if (propagateException != null) continue;
                    propagateException = e2;
                }
            }
        }
        this.collectUsageData(userToken, incomingMessage);
        if (propagateException != null) {
            throw new MLSException(propagateException);
        }
        return messageContainer;
    }

    @Override
    public MessageContainerDO sendMessages(UserTokenDO userToken, ComputeTokenDO computeToken, MessageContainerDO messageContainer) {
        MessageContainerUtil.addComputeToken(messageContainer, computeToken);
        return this.sendMessages(userToken, messageContainer);
    }

    protected boolean isValidMessageChainOrder() {
        int missing;
        boolean isValidOrder = true;
        int indexOfComputeService = missing = -1;
        int indexOfSessionService = missing;
        int indexOfSharingService = missing;
        for (int n2 = 0; n2 < this.serviceArray.length; ++n2) {
            MessageService service = this.serviceArray[n2];
            if (service instanceof ComputeService) {
                indexOfComputeService = n2;
                continue;
            }
            if (service instanceof SessionService) {
                indexOfSessionService = n2;
                continue;
            }
            if (!(service instanceof SharedDirectoryService)) continue;
            indexOfSharingService = n2;
        }
        if (indexOfComputeService != missing && indexOfSharingService != missing && indexOfComputeService < indexOfSharingService) {
            logger.severe("ComputeService should appear after SharingService");
            isValidOrder = false;
        } else if (indexOfComputeService != missing && indexOfSessionService != missing && indexOfComputeService < indexOfSessionService) {
            logger.severe("ComputeService should appear after SessionService");
            isValidOrder = false;
        }
        return isValidOrder;
    }

    private void collectUsageData(UserTokenDO token, MessageContainerDO container) {
        logger.fine("Calling UDC Service.");
        this.udcService.setServiceToken(token != null ? token.getMwaToken() : "");
        this.udcService.recordUsageDataForUser(token != null ? token.getSessionCorrelationId() : "", container);
    }

    private List<MessageService> extractMessageServices(Collection<Object> services) {
        Iterator<Object> it = services.iterator();
        ArrayList<MessageService> messageServiceList = new ArrayList<MessageService>();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof MessageService)) continue;
            messageServiceList.add((MessageService)obj);
        }
        return messageServiceList;
    }

    private UdcService extractUDCService(Collection<Object> services) {
        UdcService udcService = new UdcServiceNullImpl();
        for (Object obj : services) {
            if (!(obj instanceof UdcService)) continue;
            udcService = (UdcService)obj;
            break;
        }
        return udcService;
    }
}

