/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.workerprovider;

import com.mathworks.matlabserver.internalservices.common.VersionedModel;
import com.mathworks.matlabserver.internalservices.converter.BeanConverterManager;
import com.mathworks.matlabserver.internalservices.mrm.MetadataOwner;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class MachineInfoDO
implements Serializable,
VersionedModel,
MetadataOwner {
    private static final long serialVersionUID = 1L;
    private String machineId;
    private String hostname;
    private String ipaddress;
    private String groupName;
    private String description;
    private MachineState state = MachineState.UNDEFINED;
    private String volumeId;
    private boolean dynamic = false;
    private Date createTime;
    private Date mostRecentWorkerActivityTime;
    private int numberOfRegisteredWorkers = 0;
    private AtomicLong version = new AtomicLong();
    private final Map<String, String> metadata = new HashMap<String, String>();
    private UserTokenDO userToken;
    private String lastWorkerInfo;
    private String statusInfo;
    private String availabilityZone;

    public MachineInfoDO() {
    }

    public MachineInfoDO(MachineInfoDO src) {
        BeanConverterManager.getBeanConverter().copyProperties(this, src);
    }

    public Date getMostRecentWorkerActivityTime() {
        return this.mostRecentWorkerActivityTime;
    }

    public void setMostRecentWorkerActivityTime(Date mostRecentWorkerActivityTime) {
        this.mostRecentWorkerActivityTime = mostRecentWorkerActivityTime;
    }

    public boolean isRunning() {
        return this.state == MachineState.RUNNING;
    }

    public boolean isLaunching() {
        return this.state == MachineState.LAUNCHING;
    }

    public boolean isSick() {
        return this.state == MachineState.SICK;
    }

    public boolean isTerminating() {
        return this.state == MachineState.TERMINATING;
    }

    public boolean isTerminated() {
        return this.state == MachineState.TERMINATED;
    }

    public String getUserName() {
        String userName = null;
        if (this.userToken != null) {
            userName = this.userToken.getName();
        }
        return userName;
    }

    public UserTokenDO getUserToken() {
        return this.userToken;
    }

    public void setUserToken(UserTokenDO userToken) {
        this.userToken = userToken;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public MachineState getState() {
        return this.state;
    }

    public void setState(MachineState state) {
        this.state = state;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastWorkerInfo() {
        return this.lastWorkerInfo;
    }

    public void setLastWorkerInfo(String lastWorkerInfo) {
        this.lastWorkerInfo = lastWorkerInfo;
    }

    public String getStatusInfo() {
        return this.statusInfo;
    }

    public void setStatusInfo(String statusInfo) {
        this.statusInfo = statusInfo;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MachineInfoDO that = (MachineInfoDO)o2;
        if (this.dynamic != that.dynamic) {
            return false;
        }
        if (this.createTime != null ? !this.createTime.equals(that.createTime) : that.createTime != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ipaddress != null ? !this.ipaddress.equals(that.ipaddress) : that.ipaddress != null) {
            return false;
        }
        if (this.machineId != null ? !this.machineId.equals(that.machineId) : that.machineId != null) {
            return false;
        }
        if (this.mostRecentWorkerActivityTime != null ? !this.mostRecentWorkerActivityTime.equals(that.mostRecentWorkerActivityTime) : that.mostRecentWorkerActivityTime != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        return !(this.volumeId != null ? !this.volumeId.equals(that.volumeId) : that.volumeId != null);
    }

    public int hashCode() {
        int result = this.machineId != null ? this.machineId.hashCode() : 0;
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.ipaddress != null ? this.ipaddress.hashCode() : 0);
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.volumeId != null ? this.volumeId.hashCode() : 0);
        result = 31 * result + (this.dynamic ? 1 : 0);
        result = 31 * result + (this.createTime != null ? this.createTime.hashCode() : 0);
        result = 31 * result + (this.mostRecentWorkerActivityTime != null ? this.mostRecentWorkerActivityTime.hashCode() : 0);
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MachineInfoDO{machineId='" + this.machineId + '\'' + ", hostname='" + this.hostname + '\'' + ", ipaddress='" + this.ipaddress + '\'' + ", groupName='" + this.groupName + '\'' + ", description='" + this.description + '\'' + ", state=" + (Object)((Object)this.state) + ", volumeId='" + this.volumeId + '\'' + ", dynamic=" + this.dynamic + ", createTime=" + this.createTime + ", mostRecentWorkerActivityTime=" + this.mostRecentWorkerActivityTime + ", numberOfRegisteredWorkers=" + this.numberOfRegisteredWorkers + ", userToken=" + this.userToken + '}';
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public void setVersion(long version) {
        this.version.set(version);
    }

    @Override
    public String getMetadataAttribute(String attributeName) {
        return this.metadata.get(attributeName);
    }

    @Override
    public void setMetadataAttribute(String attributeName, String attributeValue) {
        this.metadata.put(attributeName, attributeValue);
    }

    @Override
    public Map<String, String> getMetadataAttributesAsMap() {
        return this.metadata != null ? Collections.unmodifiableMap(this.metadata) : Collections.emptyMap();
    }

    @Override
    public void setMetadataAttributesAsMap(Map<String, String> metadataAttributes) {
        this.metadata.putAll(metadataAttributes);
    }

    public int getNumberOfRegisteredWorkers() {
        return this.numberOfRegisteredWorkers;
    }

    public void setNumberOfRegisteredWorkers(int numberOfRegisteredWorkers) {
        this.numberOfRegisteredWorkers = numberOfRegisteredWorkers;
    }

    public void incrementRegisteredWorkerCount() {
        ++this.numberOfRegisteredWorkers;
    }

    public void decrementRegisteredWorkerCount() {
        --this.numberOfRegisteredWorkers;
    }

    public static enum MachineState {
        UNDEFINED,
        LAUNCHING,
        RUNNING,
        TERMINATING,
        SICK,
        PARKED,
        TERMINATED;

    }
}

