/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalservices.workerprovider;

import java.io.Serializable;
import java.util.Date;

public class StatusMessageDO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ENTITY_ID = "00000000-0000-0000-0000-000000000000";
    private String id;
    private Date date;
    private String message;
    private Level level;
    private EntityType entityType = EntityType.OTHER;
    private String entityId = "00000000-0000-0000-0000-000000000000";

    public static StatusMessageDO newError(String message) {
        return new StatusMessageDO(Level.ERROR, message);
    }

    public static StatusMessageDO newError(EntityType entityType, String entityId, String message) {
        return new StatusMessageDO(Level.ERROR, message, entityType, entityId);
    }

    public static StatusMessageDO newWarning(String message) {
        return new StatusMessageDO(Level.WARNING, message);
    }

    public static StatusMessageDO newWarning(EntityType entityType, String entityId, String message) {
        return new StatusMessageDO(Level.WARNING, message, entityType, entityId);
    }

    public static StatusMessageDO newInfo(String message) {
        return new StatusMessageDO(Level.INFO, message);
    }

    public static StatusMessageDO newInfo(EntityType entityType, String entityId, String message) {
        return new StatusMessageDO(Level.INFO, message, entityType, entityId);
    }

    public StatusMessageDO(Level level, String message) {
        this(level, message, EntityType.OTHER, DEFAULT_ENTITY_ID);
    }

    public StatusMessageDO(Level level, String message, EntityType entityType, String entityId) {
        this(new Date(), level, message, entityType, entityId);
    }

    public StatusMessageDO() {
    }

    public StatusMessageDO(Date date, Level level, String message, EntityType entityType, String entityId) {
        this.date = date;
        this.level = level;
        this.message = message;
        this.entityType = entityType;
        this.entityId = entityId;
        this.generateId();
    }

    public void generateId() {
        this.id = this.entityId + ":" + this.date.getTime();
    }

    public String getId() {
        return this.id;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Date getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusMessageDO other = (StatusMessageDO)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public String toString() {
        return "StatusMessageDO{date=" + this.date + ", message='" + this.message + '\'' + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static enum EntityType {
        OTHER,
        MACHINE,
        WORKER;

    }

    public static enum Level {
        INFO,
        WARNING,
        ERROR;

    }
}

